/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import restringer.IString;
import restringer.Mod;
import restringer.Timer;
import restringer.gui.ProgressModel;
import restringer.pex.PexFile;
import restringer.pex.RemappingStats;

public class Profile {
    private final String NAME;
    private final ArrayList<Mod> MODLIST;
    private File outputDirectory;
    private long buildTime;
    private final transient Timer TIMER;
    private static final Logger LOG = Logger.getLogger(Profile.class.getCanonicalName());
    private static final String SCRIPTS_PATH = "scripts\\";
    private static final Pattern FILENAME_PATTERN = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);

    private Profile() {
        this("Default");
    }

    public Profile(String name) {
        Objects.requireNonNull(name);
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Profile name must not be empty.");
        }
        if (!Profile.validateName(name)) {
            throw new IllegalArgumentException("Profile name must be a valid filename.");
        }
        this.NAME = name;
        this.buildTime = -1L;
        this.TIMER = new Timer("Timer");
        this.MODLIST = new ArrayList();
        String HOME = System.getProperty("user.home");
        File HOME_DIRECTORY = new File(HOME);
        String PROFILE_PATH = "Restringer-" + this.NAME;
        this.outputDirectory = new File(HOME_DIRECTORY, PROFILE_PATH);
        this.outputDirectory = null;
    }

    public String getName() {
        return this.NAME;
    }

    public List<Mod> getMods() {
        return Collections.unmodifiableList(this.MODLIST);
    }

    public List<Mod> getCheckmarkedMods() {
        Predicate<Mod> isChecked = mod -> mod.getStatus() == Mod.Status.CHECKED && !mod.isEmpty();
        Stream<Mod> stream = this.MODLIST.stream().filter(isChecked);
        return stream.collect(Collectors.toList());
    }

    public boolean contains(Mod mod) {
        return this.MODLIST.contains(mod);
    }

    public int size() {
        return this.MODLIST.size();
    }

    public int addMod(int index, Mod mod) {
        Objects.requireNonNull(mod);
        index = Math.min(index, this.MODLIST.size());
        if (this.MODLIST.contains(mod)) {
            this.MODLIST.remove(mod);
            this.MODLIST.add(index, mod);
        } else {
            this.MODLIST.add(index, mod);
        }
        return index;
    }

    public int addMod(Mod mod) {
        Objects.requireNonNull(mod);
        if (!this.MODLIST.contains(mod)) {
            this.MODLIST.add(mod);
            return this.MODLIST.indexOf(mod);
        }
        return this.getMods().indexOf(mod);
    }

    public int removeMod(Mod mod) {
        Objects.requireNonNull(mod);
        int index = this.MODLIST.indexOf(mod);
        this.MODLIST.remove(mod);
        return index;
    }

    public int indexOf(Mod mod) {
        return this.MODLIST.indexOf(mod);
    }

    public void clear() {
        this.MODLIST.clear();
    }

    public Mod.Analysis getFastAnalysis() {
        Mod.Analysis total = new Mod.Analysis();
        for (Mod mod : this.getCheckmarkedMods()) {
            Mod.Analysis subAnalysis = mod.fastAnalysis();
            if (null == subAnalysis) continue;
            total = Mod.Analysis.combine(total, subAnalysis);
        }
        return total;
    }

    public void updateBuildTime() {
        this.buildTime = new Date().getTime();
    }

    public Date getBuildTime() {
        if (this.buildTime < 0L) {
            return null;
        }
        return new Date(this.buildTime);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File dir) {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.outputDirectory = dir;
    }

    public String toString() {
        return this.NAME;
    }

    public RemappingStats execute2(ProgressModel model, boolean compress) throws RestringingError {
        return null;
    }

    public static Analysis analyzeMod(Mod mod) {
        if (mod.getScripts().isEmpty()) {
            try {
                mod.readScripts(true);
            }
            catch (Mod.ScriptReadError scriptReadError) {
                // empty catch block
            }
        }
        Analysis ANALYSIS = new Analysis();
        String MODNAME = mod.getName();
        ANALYSIS.MODS.add(mod);
        ANALYSIS.ESPS.put(MODNAME, new ObjectLinkedOpenHashSet<String>(mod.getESPNames()));
        mod.getScripts().forEach((file, pexFile) -> {
            pexFile.STRINGS.parallelStream().forEach(string -> {
                Map<IString, Map<String, Integer>> stringOrigins = ANALYSIS.STRING_ORIGINS;
                Map modCounts = stringOrigins.computeIfAbsent((IString)string, s -> new Object2IntLinkedOpenHashMap(6));
                modCounts.merge(MODNAME, 1, Integer::sum);
            });
            pexFile.SCRIPTS.forEach(pex -> {
                ANALYSIS.SCRIPTS.put(pex.NAME, (File)file);
                Map<IString, SortedSet<String>> scriptOrigins = ANALYSIS.SCRIPT_ORIGINS;
                SortedSet scriptMods = scriptOrigins.computeIfAbsent(pex.NAME, s -> new ObjectLinkedOpenHashSet());
                scriptMods.add(MODNAME);
                pex.getFunctionNames().forEach(name -> {
                    Map<IString, SortedSet<String>> functionOrigins = ANALYSIS.FUNCTION_ORIGINS;
                    SortedSet funcMods = functionOrigins.computeIfAbsent((IString)name, s -> new ObjectLinkedOpenHashSet());
                    funcMods.add(MODNAME);
                });
            });
        });
        return ANALYSIS;
    }

    public Analysis createAnalysisMap(ProgressModel model) throws RestringingError {
        Objects.requireNonNull(model);
        List<Mod> MODS = this.getCheckmarkedMods();
        double WT_PREFACE = 6.2;
        double WT_READ = 6.655619447651847E-6;
        double WT_SORT1 = 0.0681829618272595;
        Mod.Analysis analysis = new Mod.Analysis();
        for (Mod mod2 : MODS) {
            analysis = Mod.Analysis.combine(analysis, mod2.analysis());
        }
        double max = 6.2;
        max += (double)analysis.NUMBYTES * 6.655619447651847E-6;
        model.setValueIsAdjusting(true);
        model.setMaximum((int)(max += (double)analysis.NUMSCRIPTS * 0.0681829618272595));
        model.setMinimum(0);
        model.setValue(0);
        model.setValueIsAdjusting(false);
        LOG.info(String.format("Total bytes %d, total scripts %d.", analysis.NUMBYTES, analysis.NUMSCRIPTS));
        model.modifyValue(6.2);
        LOG.info("Reading Mod scripts.");
        this.TIMER.start();
        LinkedList READERRORS = new LinkedList();
        MODS.parallelStream().forEach(mod -> {
            try {
                mod.readScripts(false);
                model.modifyValue((double)mod.analysis().NUMBYTES * 6.655619447651847E-6);
            }
            catch (Mod.ScriptReadError ex) {
                READERRORS.add(ex);
            }
        });
        if (!READERRORS.isEmpty()) {
            throw new RestringingReadError(READERRORS);
        }
        this.TIMER.stop();
        LOG.info(String.format("Required %s to read %d mods.", this.TIMER.getFormattedTime(), this.MODLIST.size()));
        this.TIMER.reset();
        System.out.println(analysis);
        LOG.info("Sorting strings.");
        this.TIMER.start();
        LinkedHashMap SCRIPTS = new LinkedHashMap();
        MODS.forEach(mod -> mod.getScripts().values().forEach(script -> {
            IString filename = script.getFilename();
            if (SCRIPTS.containsKey(filename)) {
                long originalDate = ((PexFile)SCRIPTS.get(filename)).getDate();
                long newDate = script.getDate();
                if (newDate > originalDate) {
                    SCRIPTS.put(filename, script);
                }
            } else {
                SCRIPTS.put(filename, script);
            }
        }));
        LOG.info("Remapping strings: made identity map.");
        model.modifyValue((double)analysis.NUMSCRIPTS * 0.0681829618272595);
        this.TIMER.start();
        Analysis ANALYSIS = new Analysis();
        MODS.forEach(mod -> {
            String MODNAME = mod.getName();
            ANALYSIS.MODS.add((Mod)mod);
            ANALYSIS.ESPS.put(MODNAME, new ObjectLinkedOpenHashSet<String>(mod.getESPNames()));
            mod.getScripts().forEach((file, pexFile) -> {
                pexFile.STRINGS.parallelStream().forEach(string -> {
                    Map<IString, Map<String, Integer>> stringOrigins = ANALYSIS.STRING_ORIGINS;
                    Map modCounts = stringOrigins.computeIfAbsent((IString)string, s -> new Object2IntLinkedOpenHashMap(6));
                    modCounts.merge(MODNAME, 1, Integer::sum);
                });
                pexFile.SCRIPTS.forEach(pex -> {
                    ANALYSIS.SCRIPTS.put(pex.NAME, (File)file);
                    Map<IString, SortedSet<String>> scriptOrigins = ANALYSIS.SCRIPT_ORIGINS;
                    SortedSet scriptMods = scriptOrigins.computeIfAbsent(pex.NAME, s -> new ObjectLinkedOpenHashSet());
                    scriptMods.add(MODNAME);
                    pex.getFunctionNames().forEach(name -> {
                        Map<IString, SortedSet<String>> functionOrigins = ANALYSIS.FUNCTION_ORIGINS;
                        SortedSet funcMods = functionOrigins.computeIfAbsent((IString)name, s -> new ObjectLinkedOpenHashSet());
                        funcMods.add(MODNAME);
                    });
                });
            });
        });
        this.TIMER.stop();
        LOG.info(String.format("Required %s to analyse %d scripts over %d mods.", this.TIMER.getFormattedTime(), SCRIPTS.size(), MODS.size()));
        this.TIMER.reset();
        return ANALYSIS;
    }

    public static void compareFiles(File f1, File f2) throws FileNotFoundException, IOException {
        assert (f1.isFile());
        assert (f1.canRead());
        assert (f1.exists());
        assert (f2.isFile());
        assert (f2.canRead());
        assert (f2.exists());
        try (BufferedInputStream bis1 = new BufferedInputStream(new FileInputStream(f1));
             BufferedInputStream bis2 = new BufferedInputStream(new FileInputStream(f2));){
            byte[] BUF1 = new byte[1024];
            byte[] BUF2 = new byte[1024];
            int position = 0;
            int mismatches = 0;
            System.out.println();
            while (0 < bis1.available() && 0 < bis2.available() && mismatches < 10) {
                bis1.read(BUF1);
                bis2.read(BUF2);
                if (!Arrays.equals(BUF1, BUF2)) {
                    for (int offset = 0; offset < BUF1.length; ++offset) {
                        if (BUF1[offset] == BUF2[offset]) continue;
                        int index = position + offset;
                        System.out.printf("Mismatch: %06x : %02x -> %02x\n", index, BUF1[offset], BUF2[offset]);
                        ++mismatches;
                    }
                }
                position += BUF1.length;
            }
            if (mismatches == 0) {
                System.out.printf("\nPerfect match.\n", new Object[0]);
            } else {
                System.out.printf("\nThere were %d mismatches.\n", mismatches);
            }
        }
    }

    public static boolean validateName(String name) {
        return FILENAME_PATTERN.matcher(name).matches();
    }

    public class RestringingWriteError
    extends RestringingError {
        private final Collection<IOException> CAUSES;

        private RestringingWriteError(Collection<IOException> causes) {
            super("Error while writing patched scripts.");
            Objects.requireNonNull(causes);
            this.CAUSES = new ArrayList<IOException>(causes);
        }

        public Collection<IOException> getCauses() {
            return Collections.unmodifiableCollection(this.CAUSES);
        }
    }

    public class RestringingReadError
    extends RestringingError {
        private final Collection<Mod.ScriptReadError> CAUSES;

        private RestringingReadError(Collection<Mod.ScriptReadError> causes) {
            super("Error while reading scripts.");
            Objects.requireNonNull(causes);
            this.CAUSES = new ArrayList<Mod.ScriptReadError>(causes);
        }

        public Collection<Mod.ScriptReadError> getCauses() {
            return Collections.unmodifiableCollection(this.CAUSES);
        }
    }

    public abstract class RestringingError
    extends IOException {
        private RestringingError(String msg) {
            super(msg);
        }
    }

    public static class Analysis
    implements Serializable {
        public final SortedSet<Mod> MODS = new ObjectLinkedOpenHashSet<Mod>();
        public final Map<IString, File> SCRIPTS = new ConcurrentHashMap<IString, File>();
        public final Map<String, SortedSet<String>> ESPS = new ConcurrentHashMap<String, SortedSet<String>>();
        public final Map<IString, Map<String, Integer>> STRING_ORIGINS = new ConcurrentHashMap<IString, Map<String, Integer>>();
        public final Map<IString, SortedSet<String>> SCRIPT_ORIGINS = new ConcurrentHashMap<IString, SortedSet<String>>();
        public final Map<IString, SortedSet<String>> STRUCT_ORIGINS = new ConcurrentHashMap<IString, SortedSet<String>>();
        public final Map<IString, SortedSet<String>> FUNCTION_ORIGINS = new ConcurrentHashMap<IString, SortedSet<String>>();

        public Analysis merge(Analysis sub) {
            this.MODS.addAll(sub.MODS);
            this.SCRIPTS.putAll(sub.SCRIPTS);
            sub.ESPS.forEach((name, list) -> this.ESPS.merge((String)name, (SortedSet<String>)list, (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            }));
            sub.STRING_ORIGINS.forEach((name, list) -> this.STRING_ORIGINS.merge((IString)name, (Map<String, Integer>)list, (l1, l2) -> {
                l1.putAll(l2);
                return l1;
            }));
            sub.SCRIPT_ORIGINS.forEach((name, list) -> this.SCRIPT_ORIGINS.merge((IString)name, (SortedSet<String>)list, (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            }));
            sub.STRUCT_ORIGINS.forEach((name, list) -> this.STRUCT_ORIGINS.merge((IString)name, (SortedSet<String>)list, (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            }));
            sub.FUNCTION_ORIGINS.forEach((name, list) -> this.FUNCTION_ORIGINS.merge((IString)name, (SortedSet<String>)list, (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            }));
            return this;
        }
    }
}

