/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import org.apache.commons.cli.CommandLine;
import restringer.pex.AssemblyLevel;
import restringer.pex.PexFile;

public class ReAssembler {
    static final Logger LOG = Logger.getLogger(ReAssembler.class.getCanonicalName());
    static final Pattern FILENAMEPATTERN = Pattern.compile("^.*\\.(pex)$", 2);

    public static void execute(CommandLine line) {
        try {
            LOG.getParent().addHandler(new FileHandler("ReAssembler.%g.log.xml", 0x100000, 1));
        }
        catch (IOException ex) {
            LOG.warning("Couldn't create log file.");
            LOG.warning(ex.toString());
        }
        LOG.getParent().getHandlers()[0].setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                Level LEVEL = record.getLevel();
                String MSG = record.getMessage();
                String SRC = record.getSourceClassName() + "." + record.getSourceMethodName();
                return String.format("%s: %s (in %s)\n", LEVEL, MSG, SRC);
            }
        });
        LOG.setLevel(Level.FINE);
        LOG.getParent().getHandlers()[0].setLevel(Level.FINE);
        AssemblyLevel LEVEL = line.hasOption('c') ? AssemblyLevel.STRIPPED : (line.hasOption('b') ? AssemblyLevel.BYTECODE : AssemblyLevel.FULL);
        boolean CONSOLE = line.hasOption('s');
        List<String> FILES = line.getArgList();
        if (null == System.console() && !GraphicsEnvironment.isHeadless()) {
            if (FILES.isEmpty()) {
                JOptionPane.showMessageDialog(null, "No script files!", "Error", 0);
                return;
            }
            String DOC1 = ReAssembler.makeDoc(FILES, AssemblyLevel.FULL);
            String DOC2 = ReAssembler.makeDoc(FILES, AssemblyLevel.STRIPPED);
            String DOC3 = ReAssembler.makeDoc(FILES, AssemblyLevel.BYTECODE);
            DisasmPane PANE1 = new DisasmPane(DOC1);
            DisasmPane PANE2 = new DisasmPane(DOC2);
            DisasmPane PANE3 = new DisasmPane(DOC3);
            JTabbedPane PANE = new JTabbedPane();
            PANE.add("Source", new JScrollPane(PANE1));
            PANE.add("Stripped", new JScrollPane(PANE2));
            PANE.add("ByteCode", new JScrollPane(PANE3));
            PANE.setPreferredSize(new Dimension(850, 700));
            JOptionPane.showMessageDialog(null, PANE, "Disassembly", 1);
        } else {
            for (String filename : FILES) {
                PexFile SCRIPT;
                File SCRIPTFILE = new File(filename);
                Matcher REGEX = FILENAMEPATTERN.matcher(SCRIPTFILE.getName());
                if (!REGEX.matches()) {
                    System.err.println("Skipping invalid filename: " + filename);
                    continue;
                }
                try {
                    SCRIPT = PexFile.readScript(SCRIPTFILE);
                }
                catch (IOException ex) {
                    System.err.println("Error reading script: " + ex.getMessage());
                    continue;
                }
                LinkedList<String> CODE = new LinkedList<String>();
                try {
                    SCRIPT.disassemble(CODE, LEVEL);
                }
                catch (RuntimeException ex) {
                    System.err.println("Error disassembling script: " + ex.getMessage());
                    continue;
                }
                if (CONSOLE) {
                    CODE.forEach(s -> System.out.println((String)s));
                    continue;
                }
                File OUTFILE = LEVEL != AssemblyLevel.FULL ? new File(filename.replaceFirst("\\.pex$", ".txt")) : new File(filename.replaceFirst("\\.pex$", ".psc"));
                if (OUTFILE.exists()) {
                    System.err.printf("Output file already exists: %s\n", OUTFILE);
                }
                try (BufferedWriter OUT = new BufferedWriter(new FileWriter(OUTFILE));){
                    for (String s2 : CODE) {
                        OUT.write(s2);
                        ((Writer)OUT).write(10);
                    }
                }
                catch (IOException ex) {
                    System.err.println("Error disassembling script: " + ex.getMessage());
                    continue;
                }
                if (CONSOLE) continue;
                switch (LEVEL) {
                    case FULL: {
                        System.out.println("Wrote disassembled script for " + filename + " to " + OUTFILE);
                        break;
                    }
                    case STRIPPED: {
                        System.out.println("Wrote cleaned-bytecode script for " + filename + " to " + OUTFILE);
                        break;
                    }
                    case BYTECODE: {
                        System.out.println("Wrote bytecode-level script for " + filename + " to " + OUTFILE);
                        break;
                    }
                }
            }
        }
    }

    private static String makeDoc(List<String> files, AssemblyLevel level) {
        StringWriter BUF = new StringWriter(20480);
        PrintWriter OUT = new PrintWriter(BUF);
        OUT.println("<html>");
        for (String filename : files) {
            PexFile SCRIPT;
            File SCRIPTFILE = new File(filename);
            Matcher REGEX = FILENAMEPATTERN.matcher(SCRIPTFILE.getName());
            if (!REGEX.matches()) {
                OUT.printf("<p>Skipped invalid filename: %s\n</p>", filename);
                continue;
            }
            try {
                SCRIPT = PexFile.readScript(SCRIPTFILE);
            }
            catch (IOException ex) {
                OUT.printf("<p>Error reading script: %s\n</p>", filename);
                continue;
            }
            LinkedList<String> CODE = new LinkedList<String>();
            try {
                SCRIPT.disassemble(CODE, level);
            }
            catch (Error | Exception ex) {
                ex.printStackTrace(System.err);
                OUT.printf("<p>Error disassembling script: %s\n</p>", filename);
            }
            OUT.println("<code><pre>");
            CODE.forEach(s -> {
                String s2 = s.replace("<", "%lt;");
                OUT.println(s2);
            });
            OUT.println("</pre></code>");
            OUT.println("<hr/>");
        }
        OUT.println("</html>");
        return BUF.toString();
    }

    private static class DisasmPane
    extends JTextPane {
        public DisasmPane(String doc) {
            super.setFont(super.getFont().deriveFont(12.0f));
            super.setEditable(true);
            super.setContentType("text/html");
            super.setPreferredSize(new Dimension(850, 700));
            super.setText(doc);
        }
    }
}

