/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.CommandLine;
import restringer.gui.SaveWindow;

public class ReSaver {
    static final Logger LOG = Logger.getLogger(ReSaver.class.getCanonicalName());

    public static void execute(CommandLine line) {
        try {
            LOG.getParent().addHandler(new FileHandler("ReSaver.%g.log.xml", 0x100000, 1));
        }
        catch (IOException ex) {
            LOG.warning("Couldn't create log file.");
            LOG.warning(ex.toString());
        }
        LOG.getParent().getHandlers()[0].setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                Level LEVEL = record.getLevel();
                String MSG = record.getMessage();
                String SRC = record.getSourceClassName() + "." + record.getSourceMethodName();
                return String.format("%s: %s (in %s)\n", LEVEL, MSG, SRC);
            }
        });
        LOG.setLevel(Level.FINE);
        LOG.getParent().getHandlers()[0].setLevel(Level.FINE);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (!line.getArgList().isEmpty()) {
            String ARG = line.getArgList().get(0);
            File FILE = new File(ARG);
            try {
                EventQueue.invokeLater(() -> new SaveWindow(FILE).setVisible(true));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
                ex.printStackTrace(System.out);
            }
        } else {
            try {
                EventQueue.invokeLater(() -> new SaveWindow().setVisible(true));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, null, ex);
                ex.printStackTrace(System.out);
            }
        }
    }
}

