/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class Timer {
    private final String NAME;
    private long totalElapsed_;
    private long initialTime_;
    private boolean running_;
    private Map<String, Long> records;
    private static final float MICROSECOND = 1000.0f;
    private static final float MILLISECOND = 1000000.0f;
    private static final float SECOND = 1.0E9f;
    private static final float MINUTE = 6.0E10f;

    public static Timer startNew(String name) {
        Timer t = new Timer(name);
        t.start();
        return t;
    }

    public Timer(String name) {
        this.NAME = null == name || name.isEmpty() ? null : (name.length() > 100 ? name.substring(0, 100).trim() : name.trim());
        this.reset();
    }

    public void reset() {
        this.totalElapsed_ = 0L;
        this.initialTime_ = 0L;
        this.running_ = false;
    }

    public void start() {
        if (this.running_) {
            return;
        }
        this.initialTime_ = System.nanoTime();
        this.running_ = true;
    }

    public void restart() {
        this.reset();
        this.start();
    }

    public void stop() {
        if (!this.running_) {
            return;
        }
        long finalTime = System.nanoTime();
        this.running_ = false;
        this.totalElapsed_ += finalTime - this.initialTime_;
    }

    public boolean isRunning() {
        return this.running_;
    }

    public long getElapsed() {
        if (this.running_) {
            long finalTime = System.nanoTime();
            return this.totalElapsed_ + (finalTime - this.initialTime_);
        }
        return this.totalElapsed_;
    }

    public String getName() {
        return this.NAME;
    }

    public void record(String recordName) {
        Objects.requireNonNull(recordName);
        long elapsed = this.getElapsed();
        if (null == this.records) {
            this.records = new LinkedHashMap<String, Long>();
        }
        this.records.merge(recordName, elapsed, Long::sum);
    }

    public void recordRestart(String recordName) {
        this.record(recordName);
        this.restart();
    }

    public Map<String, Long> getRecords() {
        if (null == this.records) {
            return null;
        }
        return Collections.unmodifiableMap(this.records);
    }

    public String getFormattedTime() {
        long elapsed = this.getElapsed();
        if ((float)elapsed < 1000.0f) {
            return String.format("%d ns", elapsed);
        }
        if ((float)elapsed < 1000000.0f) {
            float microseconds = (float)elapsed / 1000.0f;
            return String.format("%1.1f us", Float.valueOf(microseconds));
        }
        if ((float)elapsed < 1.0E9f) {
            float milliseconds = (float)elapsed / 1000000.0f;
            return String.format("%1.1f ms", Float.valueOf(milliseconds));
        }
        if ((float)elapsed < 6.0E10f) {
            float seconds = (float)elapsed / 1.0E9f;
            return String.format("%1.1f s", Float.valueOf(seconds));
        }
        float seconds = (float)elapsed / 6.0E10f;
        return String.format("%1.1f m", Float.valueOf(seconds));
    }

    public String toString() {
        StringBuilder SB = new StringBuilder();
        SB.append("Timer ");
        SB.append(this.getName());
        SB.append(": ");
        long elapsed = this.getElapsed();
        if ((float)elapsed < 1000.0f) {
            SB.append(String.format("%d ns", elapsed));
        } else if ((float)elapsed < 1000000.0f) {
            float microseconds = (float)elapsed / 1000.0f;
            SB.append(String.format("%.2f us", Float.valueOf(microseconds)));
        } else if ((float)elapsed < 1.0E9f) {
            float milliseconds = (float)elapsed / 1000000.0f;
            SB.append(String.format("%.2f ms", Float.valueOf(milliseconds)));
        } else if ((float)elapsed < 6.0E10f) {
            float seconds = (float)elapsed / 1.0E9f;
            SB.append(String.format("%.2f s", Float.valueOf(seconds)));
        } else {
            float seconds = (float)elapsed / 6.0E10f;
            SB.append(String.format("%.2f m", Float.valueOf(seconds)));
        }
        if (this.running_) {
            SB.append(" (running)");
        }
        return SB.toString();
    }
}

