/*
 * Decompiled with CFR 0.152.
 */
package restringer.bsa;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import restringer.LittleEndianRAF;
import restringer.Mod;
import restringer.bsa.BSAHeader;
import restringer.bsa.FileData;
import restringer.bsa.FileRecord;
import restringer.bsa.FileRecordBlock;
import restringer.bsa.FolderRecord;
import restringer.esp.StringsFile;
import restringer.pex.PexFile;

public class BSAParser {
    final String NAME;
    final BSAHeader HEADER;
    final List<FolderRecord> FOLDERRECORDS;
    final List<FileRecordBlock> FILERECORD_BLOCKS;
    final ArrayList<String> FILENAMES;
    final LittleEndianRAF INPUT;

    public BSAParser(String name, LittleEndianRAF input) throws IOException {
        this.INPUT = Objects.requireNonNull(input);
        this.NAME = name;
        this.HEADER = new BSAHeader(input);
        this.FOLDERRECORDS = new ArrayList<FolderRecord>(this.HEADER.FOLDER_COUNT);
        this.FILERECORD_BLOCKS = new ArrayList<FileRecordBlock>(this.HEADER.FOLDER_COUNT);
        this.FILENAMES = new ArrayList(this.HEADER.FILE_COUNT);
        for (int i = 0; i < this.HEADER.FOLDER_COUNT; ++i) {
            FolderRecord folder = new FolderRecord(input, this.HEADER);
            this.FOLDERRECORDS.add(folder);
        }
        for (FolderRecord folder : this.FOLDERRECORDS) {
            FileRecordBlock block2 = new FileRecordBlock(input, folder, this.HEADER);
            this.FILERECORD_BLOCKS.add(block2);
        }
        if (this.HEADER.isIncludeFilenames()) {
            for (int i = 0; i < this.HEADER.FILE_COUNT; ++i) {
                String fileName = input.readZString();
                this.FILENAMES.add(fileName);
            }
            Iterator<String> nameIterator = this.FILENAMES.iterator();
            this.FILERECORD_BLOCKS.forEach(block -> block.FILERECORDS.forEach(file -> {
                file.name = (String)nameIterator.next();
            }));
        }
    }

    public Map<File, PexFile> getScripts() throws IOException {
        LinkedHashMap<File, PexFile> SCRIPTS = new LinkedHashMap<File, PexFile>();
        Optional<FileRecordBlock> o = this.FILERECORD_BLOCKS.parallelStream().filter(block -> block.NAME.equalsIgnoreCase("scripts")).findFirst();
        if (!o.isPresent()) {
            return SCRIPTS;
        }
        FileRecordBlock SCRIPTFOLDER = o.get();
        for (FileRecord SCRIPTFILE : SCRIPTFOLDER.FILERECORDS) {
            if (!Mod.PEX_REGEX.matcher(SCRIPTFILE.name).matches()) continue;
            FileData FILEDATA = new FileData(this.INPUT, SCRIPTFILE, this.HEADER);
            PexFile pex = PexFile.readScript(FILEDATA.DATA);
            File pseudoFile = new File(pex.getFilename().toString());
            SCRIPTS.put(pseudoFile, pex);
        }
        return SCRIPTS;
    }

    public PexFile getScript(String filename) throws IOException {
        Optional<FileRecordBlock> o = this.FILERECORD_BLOCKS.parallelStream().filter(block -> block.NAME.equalsIgnoreCase("scripts")).findFirst();
        if (!o.isPresent()) {
            return null;
        }
        FileRecordBlock SCRIPTFOLDER = o.get();
        for (FileRecord SCRIPTFILE : SCRIPTFOLDER.FILERECORDS) {
            if (!Mod.PEX_REGEX.matcher(SCRIPTFILE.name).matches() || SCRIPTFILE.name.equalsIgnoreCase(filename)) continue;
            FileData FILEDATA = new FileData(this.INPUT, SCRIPTFILE, this.HEADER);
            PexFile pex = PexFile.readScript(FILEDATA.DATA);
            return pex;
        }
        return null;
    }

    public List<StringsFile> getStrings(String language) throws IOException {
        LinkedList<StringsFile> STRINGS = new LinkedList<StringsFile>();
        Optional<FileRecordBlock> o = this.FILERECORD_BLOCKS.parallelStream().filter(block -> block.NAME.equalsIgnoreCase("strings")).findFirst();
        if (!o.isPresent()) {
            return STRINGS;
        }
        FileRecordBlock STRINGSFOLDER = o.get();
        for (FileRecord STRINGSFILE : STRINGSFOLDER.FILERECORDS) {
            String FILENAME = STRINGSFILE.name.toLowerCase();
            if (!Mod.STR_REGEX.matcher(FILENAME).matches() || !FILENAME.contains(language)) continue;
            FileData FILEDATA = new FileData(this.INPUT, STRINGSFILE, this.HEADER);
            StringsFile.Type type = StringsFile.Type.match(FILEDATA.NAME);
            StringsFile strings = new StringsFile(FILENAME, FILEDATA.getStream(), type);
            STRINGS.add(strings);
        }
        return STRINGS;
    }
}

