/*
 * Decompiled with CFR 0.152.
 */
package restringer.bsa;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.LittleEndianRAF;
import restringer.bsa.BSAHeader;
import restringer.bsa.FileRecord;

public class FileData {
    public final String NAME;
    public final int ORIGINALSIZE;
    public final byte[] DATA;

    FileData(LittleEndianRAF input, FileRecord record, BSAHeader header) throws IOException {
        input.seek(record.OFFSET);
        this.NAME = header.isEmbedFilename() ? input.readBString() : record.name;
        if (record.COMPRESSED) {
            this.ORIGINALSIZE = input.readInt();
            this.DATA = new byte[this.ORIGINALSIZE];
            byte[] ZLIBDATA = new byte[record.SIZE - 4];
            input.readFully(ZLIBDATA);
            Inflater INFLATER = new Inflater();
            INFLATER.setInput(ZLIBDATA);
            try {
                INFLATER.inflate(this.DATA);
            }
            catch (DataFormatException ex) {
                throw new IOException(ex);
            }
            finally {
                INFLATER.end();
            }
        } else {
            this.ORIGINALSIZE = record.SIZE;
            this.DATA = new byte[this.ORIGINALSIZE];
            input.readFully(this.DATA);
        }
    }

    public LittleEndianInput getStream() {
        return LittleEndianInputStream.wrap(this.DATA);
    }
}

