/*
 * Decompiled with CFR 0.152.
 */
package restringer.bsa;

import java.io.IOException;
import restringer.LittleEndianRAF;
import restringer.bsa.BSAHeader;

class FileRecord {
    public final long NAMEHASH;
    public final int SIZE;
    public final int OFFSET;
    public final boolean COMPRESSED;
    public String name;

    public FileRecord(LittleEndianRAF input, BSAHeader header) throws IOException {
        this.NAMEHASH = input.readLong();
        int size = input.readInt();
        int BIT30 = 0x40000000;
        boolean compressToggle = (size & 0x40000000) != 0;
        this.SIZE = size & 0xBFFFFFFF;
        this.OFFSET = input.readInt();
        this.COMPRESSED = header.isCompressedArchive() ^ compressToggle;
        this.name = null;
    }

    public String toString() {
        if (this.name == null) {
            return String.format("%d bytes at offset %d", this.SIZE, this.OFFSET);
        }
        return this.name;
    }
}

