/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import restringer.Game;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInputStream;
import restringer.esp.ESPContext;
import restringer.esp.ESPIDMap;
import restringer.esp.Entry;
import restringer.esp.Record;
import restringer.esp.RecordTes4;

public final class ESP
implements Entry {
    private final List<Record> RECORDS;

    public static ESP readESP(File modFile, Game game, int index, List<String> espList) throws FileNotFoundException, IOException {
        Objects.requireNonNull(modFile);
        assert (modFile.isFile());
        assert (modFile.canRead());
        assert (modFile.exists());
        try (LittleEndianInputStream input = LittleEndianInputStream.open(modFile);){
            ESP eSP = new ESP(input, game, index, modFile.getName(), espList);
            return eSP;
        }
    }

    public static void writeESP(ESP esp, File modFile) throws FileNotFoundException, IOException {
        assert (!modFile.exists() || modFile.isFile());
        assert (!modFile.exists() || modFile.canWrite());
        try (LittleEndianDataOutput output = new LittleEndianDataOutput(new BufferedOutputStream(new FileOutputStream(modFile)));){
            esp.write(output);
        }
    }

    public static ESPIDMap skimESP(Game game, File modFile, int index, List<String> espList) throws FileNotFoundException, IOException {
        assert (modFile.isFile());
        assert (modFile.canRead());
        assert (modFile.exists());
        try (LittleEndianInputStream input = LittleEndianInputStream.open(modFile);){
            assert (input.available() > 0);
            RecordTes4 TES4 = new RecordTes4(input, index, modFile.getName(), espList, new ESPContext(game, null));
            ESPContext CTX = new ESPContext(game, TES4);
            CTX.pushContext(TES4.NAME);
            while (input.available() > 0) {
                Record.skimRecord(input, CTX);
            }
            ESPIDMap eSPIDMap = CTX.IDMAP;
            return eSPIDMap;
        }
    }

    public ESP(LittleEndianInputStream input, Game game, int index, String name, List<String> espList) throws IOException {
        assert (input.available() > 0);
        this.RECORDS = new LinkedList<Record>();
        RecordTes4 TES4 = new RecordTes4(input, index, name, espList, new ESPContext(game, null));
        ESPContext CTX = new ESPContext(game, TES4);
        CTX.pushContext(TES4.NAME);
        this.RECORDS.add(TES4);
        while (input.available() > 0) {
            Record record = Record.readRecord(input, CTX);
            this.RECORDS.add(record);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        for (Record record : this.RECORDS) {
            record.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        return sum += this.RECORDS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        this.RECORDS.forEach(record -> BUF.append(record.toString()));
        return BUF.toString();
    }
}

