/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.util.LinkedList;
import java.util.Objects;
import restringer.Game;
import restringer.esp.ESPIDMap;
import restringer.esp.RecordTes4;

public class ESPContext {
    public final Game GAME;
    public final RecordTes4 TES4;
    private final LinkedList<CharSequence> CONTEXT;
    public final ESPIDMap IDMAP;

    public ESPContext(Game game, RecordTes4 tes4) {
        Objects.requireNonNull(game);
        this.GAME = game;
        this.TES4 = tes4;
        this.CONTEXT = new LinkedList();
        this.IDMAP = new ESPIDMap("name");
    }

    protected ESPContext(ESPContext orig) {
        this.GAME = orig.GAME;
        this.TES4 = orig.TES4;
        this.CONTEXT = new LinkedList<CharSequence>(orig.CONTEXT);
        this.IDMAP = new ESPIDMap("name");
        this.IDMAP.addAll(orig.IDMAP);
    }

    public void pushContext(CharSequence ctx) {
        this.CONTEXT.push(ctx);
    }

    public void popContext() {
        this.CONTEXT.pop();
    }

    public String toString() {
        return this.CONTEXT.toString();
    }
}

