/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import restringer.IString;
import restringer.esp.Field;
import restringer.esp.FieldEDID;
import restringer.esp.FieldFull;
import restringer.esp.FieldName;
import restringer.esp.StringTable;

public final class ESPIDMap {
    private final Int2ObjectMap<Info> MAP = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
    private final String ESPNAME;

    public ESPIDMap(String espName) {
        this.ESPNAME = espName;
    }

    public void addRecord(int formID, List<Field> fields) {
        Info INFO = new Info(fields);
        this.MAP.put(formID, INFO);
    }

    public void addAll(ESPIDMap other) {
        this.MAP.putAll(other.MAP);
    }

    public IntSet getID(String name, StringTable strings) {
        IString VAL = IString.get(name.trim());
        IntOpenHashSet matches = new IntOpenHashSet(this.MAP.keySet().stream().filter(id -> {
            String n = this.getName((int)id, strings);
            return null == n ? false : VAL.equals(n);
        }).collect(Collectors.toSet()));
        return matches;
    }

    public String getName(int formID, StringTable strings) {
        if (!this.MAP.containsKey(formID)) {
            return null;
        }
        Info INFO = (Info)this.MAP.get(formID);
        if (null != INFO.FULL && null != strings) {
            int index;
            String lookup;
            if (INFO.FULL.hasString()) {
                return INFO.FULL.getString();
            }
            if (INFO.FULL.hasIndex() && (lookup = strings.get(index = INFO.FULL.getIndex())) != null) {
                return lookup;
            }
        }
        if (null != INFO.NAME) {
            int baseID = INFO.NAME.getFormID();
            assert (baseID != formID);
            String baseName = this.getName(baseID, strings);
            if (null != baseName) {
                return baseName;
            }
        }
        if (null != INFO.EDID) {
            return INFO.EDID.getValue();
        }
        return null;
    }

    public String toString() {
        return this.ESPNAME;
    }

    private static final class Info {
        public final FieldEDID EDID;
        public final FieldFull FULL;
        public final FieldName NAME;

        public Info(List<Field> fields) {
            Optional<Field> edid = ((Stream)fields.stream().parallel()).filter(v -> v instanceof FieldEDID).findAny();
            this.EDID = edid.isPresent() ? (FieldEDID)edid.get() : null;
            Optional<Field> full = ((Stream)fields.stream().parallel()).filter(v -> v instanceof FieldFull).findAny();
            this.FULL = full.isPresent() ? (FieldFull)full.get() : null;
            Optional<Field> name = ((Stream)fields.stream().parallel()).filter(v -> v instanceof FieldName).findAny();
            this.NAME = name.isPresent() ? (FieldName)name.get() : null;
        }
    }
}

