/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.esp.ESPContext;
import restringer.esp.Field;

public class FieldBasic
implements Field {
    private final IString CODE;
    private final byte[] DATA;
    final boolean BIG;

    public FieldBasic(IString code, LittleEndianInput input, int size, boolean big, ESPContext ctx) throws IOException {
        Objects.requireNonNull(input);
        this.CODE = code;
        this.BIG = big;
        this.DATA = new byte[size];
        input.read(this.DATA);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.getBytes());
        if (this.BIG) {
            output.writeShort(0);
        } else {
            output.writeShort(this.DATA.length);
        }
        output.write(this.DATA);
    }

    @Override
    public int calculateSize() {
        return 6 + this.DATA.length;
    }

    @Override
    public IString getCode() {
        return this.CODE;
    }

    public byte[] getData() {
        return this.DATA;
    }

    public LittleEndianInput getDecoder() {
        return LittleEndianInputStream.wrap(this.DATA);
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        BUF.append(this.getCode()).append("=").append(Arrays.toString(this.DATA));
        return BUF.toString();
    }
}

