/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentInfoPack
extends FragmentBase {
    final byte UNKNOWN;
    final byte FLAGS;
    final Script SCRIPT;
    final String FILENAME;
    final List<Fragment> FRAGMENTS;

    public FragmentInfoPack(LittleEndianInput input, ESPContext ctx) throws IOException {
        this.UNKNOWN = input.readByte();
        this.FLAGS = input.readByte();
        if (ctx.GAME.isFO4()) {
            ctx.pushContext("FragmentInfoPack");
            this.FILENAME = null;
            this.SCRIPT = new Script(input, ctx);
        } else {
            this.FILENAME = input.readUTF();
            this.SCRIPT = null;
            ctx.pushContext("FragmentInfoPack:" + this.FILENAME);
        }
        this.FRAGMENTS = new LinkedList<Fragment>();
        int flagsCount = FragmentBase.NumberOfSetBits(this.FLAGS);
        for (int i = 0; i < flagsCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeByte(this.FLAGS);
        if (null != this.SCRIPT) {
            this.SCRIPT.write(output);
        }
        if (null != this.FILENAME) {
            output.writeUTF(this.FILENAME);
        }
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += null != this.SCRIPT ? this.SCRIPT.calculateSize() : 0;
        sum += null != this.FILENAME ? 2 + this.FILENAME.length() : 0;
        return sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        if (null != this.SCRIPT) {
            return String.format("InfoPack: %s (%d, %d, %d frags)", this.SCRIPT.NAME, this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size());
        }
        if (null != this.FILENAME) {
            return String.format("InfoPack: %s (%d, %d, %d frags)", this.FILENAME, this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size());
        }
        return String.format("InfoPack: (%d, %d, %d frags)", this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size());
    }

    public class Fragment
    implements Entry {
        private final byte UNKNOWN;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.UNKNOWN = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.UNKNOWN);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 5 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }
}

