/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentPerk
extends FragmentBase {
    private final byte UNKNOWN;
    private final String FILENAME;
    private final Script SCRIPT;
    private final List<Fragment> FRAGMENTS;

    public FragmentPerk(LittleEndianInput input, ESPContext ctx) throws IOException {
        try {
            this.UNKNOWN = input.readByte();
            if (ctx.GAME.isFO4()) {
                ctx.pushContext("FragmentPerk");
                this.FILENAME = null;
                this.SCRIPT = new Script(input, ctx);
            } else {
                this.FILENAME = input.readUTF();
                this.SCRIPT = null;
                ctx.pushContext("FragmentPerk:" + this.FILENAME);
            }
            int fragmentCount = input.readUnsignedShort();
            this.FRAGMENTS = new ArrayList<Fragment>(fragmentCount);
            for (int i = 0; i < fragmentCount; ++i) {
                Fragment fragment = new Fragment(input);
                this.FRAGMENTS.add(fragment);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            ctx.popContext();
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        if (null != this.SCRIPT) {
            this.SCRIPT.write(output);
        }
        if (null != this.FILENAME) {
            output.writeUTF(this.FILENAME);
        }
        output.writeShort(this.FRAGMENTS.size());
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 3;
        sum += null != this.SCRIPT ? this.SCRIPT.calculateSize() : 0;
        sum += null != this.FILENAME ? 2 + this.FILENAME.length() : 0;
        return sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        if (null != this.SCRIPT) {
            return String.format("Perk: %s (%d, %d frags)", this.SCRIPT.NAME, this.UNKNOWN, this.FRAGMENTS.size());
        }
        if (null != this.FILENAME) {
            return String.format("Perk: %s (%d, %d frags)", this.FILENAME, this.UNKNOWN, this.FRAGMENTS.size());
        }
        return String.format("Perk: (%d, %d frags)", this.UNKNOWN, this.FRAGMENTS.size());
    }

    public class Fragment
    implements Entry {
        private final int INDEX;
        private final short UNKNOWN1;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.INDEX = input.readUnsignedShort();
            this.UNKNOWN1 = input.readShort();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.INDEX);
            output.writeShort(this.UNKNOWN1);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 9 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }
    }
}

