/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentQust
extends FragmentBase {
    private final byte UNKNOWN;
    private final String FILENAME;
    private final Script SCRIPT;
    private final List<Fragment> FRAGMENTS;
    private final List<Alias> ALIASES;

    public FragmentQust(LittleEndianInput input, ESPContext ctx) throws IOException {
        try {
            this.UNKNOWN = input.readByte();
            int fragmentCount = input.readUnsignedShort();
            if (ctx.GAME.isFO4()) {
                ctx.pushContext("FragmentQust");
                this.FILENAME = null;
                this.SCRIPT = new Script(input, ctx);
            } else {
                this.FILENAME = input.readUTF();
                this.SCRIPT = null;
                ctx.pushContext("FragmentQust:" + this.FILENAME);
            }
            this.FRAGMENTS = new LinkedList<Fragment>();
            this.ALIASES = new LinkedList<Alias>();
            for (int i = 0; i < fragmentCount; ++i) {
                Fragment fragment = new Fragment(input, ctx);
                this.FRAGMENTS.add(fragment);
            }
            int aliasCount = input.readUnsignedShort();
            for (int i = 0; i < aliasCount; ++i) {
                Alias alias = new Alias(input, ctx);
                this.ALIASES.add(alias);
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            ctx.popContext();
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeShort(this.FRAGMENTS.size());
        if (null != this.FILENAME) {
            output.writeUTF(this.FILENAME);
        }
        if (null != this.SCRIPT) {
            this.SCRIPT.write(output);
        }
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
        output.writeShort(this.ALIASES.size());
        for (Alias alias : this.ALIASES) {
            alias.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 5;
        sum += null != this.FILENAME ? 2 + this.FILENAME.length() : 0;
        sum += null != this.SCRIPT ? this.SCRIPT.calculateSize() : 0;
        sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.ALIASES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        if (null != this.SCRIPT) {
            return String.format("Quest: %s (%d, %d frags, %d aliases)", this.SCRIPT.NAME, this.UNKNOWN, this.FRAGMENTS.size(), this.ALIASES.size());
        }
        if (null != this.FILENAME) {
            return String.format("Quest: %s (%d, %d frags, %d aliases)", this.FILENAME, this.UNKNOWN, this.FRAGMENTS.size(), this.ALIASES.size());
        }
        return String.format("Quest: (%d, %d frags, %d aliases)", this.UNKNOWN, this.FRAGMENTS.size(), this.ALIASES.size());
    }

    public class Alias
    implements Entry {
        private final long OBJECT;
        private final short VERSION;
        private final short OBJFORMAT;
        private final List<Script> SCRIPTS;

        public Alias(LittleEndianInput input, ESPContext ctx) throws IOException {
            this.OBJECT = input.readLong();
            this.VERSION = input.readShort();
            this.OBJFORMAT = input.readShort();
            this.SCRIPTS = new LinkedList<Script>();
            int scriptCount = input.readUnsignedShort();
            for (int i = 0; i < scriptCount; ++i) {
                Script script = new Script(input, ctx);
                this.SCRIPTS.add(script);
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeLong(this.OBJECT);
            output.writeShort(this.VERSION);
            output.writeShort(this.OBJFORMAT);
            output.writeShort(this.SCRIPTS.size());
            for (Script script : this.SCRIPTS) {
                script.write(output);
            }
        }

        @Override
        public int calculateSize() {
            int sum = 14;
            return sum += this.SCRIPTS.stream().mapToInt(v -> v.calculateSize()).sum();
        }
    }

    public class Fragment
    implements Entry {
        private final int STAGE;
        private final short UNKNOWN1;
        private final int LOGENTRY;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input, ESPContext ctx) throws IOException {
            this.STAGE = input.readUnsignedShort();
            this.UNKNOWN1 = input.readShort();
            this.LOGENTRY = input.readInt();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.STAGE);
            output.writeShort(this.UNKNOWN1);
            output.writeInt(this.LOGENTRY);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            int sum = 13;
            sum += this.SCRIPTNAME.length();
            return sum += this.FRAGMENTNAME.length();
        }
    }
}

