/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentScen
extends FragmentBase {
    private final byte UNKNOWN;
    private final byte FLAGS;
    private final Script SCRIPT;
    private final String FILENAME;
    private final List<Fragment> FRAGMENTS;
    private final List<Phase> PHASES;

    public FragmentScen(LittleEndianInput input, ESPContext ctx) throws IOException {
        this.UNKNOWN = input.readByte();
        this.FLAGS = input.readByte();
        if (ctx.GAME.isFO4()) {
            ctx.pushContext("FragmentScene");
            this.FILENAME = null;
            this.SCRIPT = new Script(input, ctx);
        } else {
            this.FILENAME = input.readUTF();
            this.SCRIPT = null;
            ctx.pushContext("FragmentScene:" + this.FILENAME);
        }
        this.FRAGMENTS = new LinkedList<Fragment>();
        this.PHASES = new LinkedList<Phase>();
        int flagCount = FragmentBase.NumberOfSetBits(this.FLAGS);
        for (int i = 0; i < flagCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
        int phaseCount = input.readUnsignedShort();
        for (int i = 0; i < phaseCount; ++i) {
            Phase phase = new Phase(input);
            this.PHASES.add(phase);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        output.writeByte(this.FLAGS);
        if (null != this.SCRIPT) {
            this.SCRIPT.write(output);
        }
        if (null != this.FILENAME) {
            output.writeUTF(this.FILENAME);
        }
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
        output.writeShort(this.PHASES.size());
        for (Phase phase : this.PHASES) {
            phase.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 4;
        sum += null != this.SCRIPT ? this.SCRIPT.calculateSize() : 0;
        sum += null != this.FILENAME ? 2 + this.FILENAME.length() : 0;
        sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
        return sum += this.PHASES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        if (null != this.SCRIPT) {
            return String.format("Scene: %s (%d, %d, %d frags, %d phases)", this.SCRIPT.NAME, this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size(), this.PHASES.size());
        }
        if (null != this.FILENAME) {
            return String.format("Scene: %s (%d, %d, %d frags, %d phases)", this.FILENAME, this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size(), this.PHASES.size());
        }
        return String.format("Scene: (%d, %d, %d frags, %d phases)", this.FLAGS, this.UNKNOWN, this.FRAGMENTS.size(), this.PHASES.size());
    }

    public class Phase
    implements Entry {
        private final byte UNKNOWN1;
        private final int PHASE;
        private final byte UNKNOWN2;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Phase(LittleEndianInput input) throws IOException {
            this.UNKNOWN1 = input.readByte();
            this.PHASE = input.readInt();
            this.UNKNOWN2 = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.UNKNOWN1);
            output.writeInt(this.PHASE);
            output.writeByte(this.UNKNOWN2);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 10 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }

        public String toString() {
            return String.format("Phase %d.%d.%d %s[%s]", this.PHASE, this.UNKNOWN1, this.UNKNOWN2, this.SCRIPTNAME, this.FRAGMENTNAME);
        }
    }

    public class Fragment
    implements Entry {
        private final byte UNKNOWN;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.UNKNOWN = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.UNKNOWN);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 5 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }

        public String toString() {
            return String.format("Frag %d %s[%s]", this.UNKNOWN, this.SCRIPTNAME, this.FRAGMENTNAME);
        }
    }
}

