/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.FragmentBase;
import restringer.esp.Script;

public class FragmentTerm
extends FragmentBase {
    private final byte UNKNOWN;
    private final Script SCRIPT;
    private final List<Fragment> FRAGMENTS;

    public FragmentTerm(LittleEndianInput input, ESPContext ctx) throws IOException {
        this.UNKNOWN = input.readByte();
        this.SCRIPT = new Script(input, ctx);
        int fragCount = input.readShort();
        this.FRAGMENTS = new ArrayList<Fragment>(fragCount);
        for (int i = 0; i < fragCount; ++i) {
            Fragment fragment = new Fragment(input);
            this.FRAGMENTS.add(fragment);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeByte(this.UNKNOWN);
        this.SCRIPT.write(output);
        output.writeShort(this.FRAGMENTS.size());
        for (Fragment fragment : this.FRAGMENTS) {
            fragment.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 3;
        sum += this.SCRIPT.calculateSize();
        return sum += this.FRAGMENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public String toString() {
        return String.format("Term: %s (%d, %d fragments)", this.SCRIPT.NAME, this.UNKNOWN, this.FRAGMENTS.size());
    }

    public class Fragment
    implements Entry {
        private final int INDEX;
        private final byte UNKNOWN;
        private final IString SCRIPTNAME;
        private final IString FRAGMENTNAME;

        public Fragment(LittleEndianInput input) throws IOException {
            this.INDEX = input.readInt();
            this.UNKNOWN = input.readByte();
            this.SCRIPTNAME = IString.get(input.readUTF());
            this.FRAGMENTNAME = IString.get(input.readUTF());
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.INDEX);
            output.writeByte(this.UNKNOWN);
            output.writeUTF(this.SCRIPTNAME.toString());
            output.writeUTF(this.FRAGMENTNAME.toString());
        }

        @Override
        public int calculateSize() {
            return 9 + this.SCRIPTNAME.length() + this.FRAGMENTNAME.length();
        }

        public String toString() {
            return String.format("%d: %s [%s] (%d)", this.INDEX, this.SCRIPTNAME, this.FRAGMENTNAME, this.UNKNOWN);
        }
    }
}

