/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.PropertyData;

public final class Property
implements Entry {
    private final IString NAME;
    private final byte TYPE;
    private final byte STATUS;
    private final PropertyData DATA;

    public Property(LittleEndianInput input, ESPContext ctx) throws IOException {
        this.NAME = IString.get(input.readUTF());
        ctx.pushContext("prop:" + this.NAME);
        this.TYPE = input.readByte();
        this.STATUS = input.readByte();
        try {
            this.DATA = PropertyData.readPropertyData(this.TYPE, input, ctx);
        }
        catch (IOException ex) {
            throw new IOException("Error data for reading property " + this.NAME, ex);
        }
        finally {
            ctx.popContext();
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeUTF(this.NAME.toString());
        output.writeByte(this.TYPE);
        output.writeByte(this.STATUS);
        this.DATA.write(output);
    }

    @Override
    public int calculateSize() {
        int sum = 4 + this.NAME.length() + this.DATA.calculateSize();
        return sum;
    }

    public String toString() {
        return String.format("%s: %d (%02x): %s", this.NAME, this.TYPE, this.STATUS, this.DATA);
    }
}

