/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.Property;

public abstract class PropertyData
implements Entry {
    public static PropertyData readPropertyData(byte type, LittleEndianInput input, ESPContext ctx) throws IOException {
        assert (input.available() > 0);
        switch (type) {
            case 0: {
                return new NullData(input);
            }
            case 1: {
                return new ObjectData(input);
            }
            case 2: {
                return new StringData(input);
            }
            case 3: {
                return new IntData(input);
            }
            case 4: {
                return new FloatData(input);
            }
            case 5: {
                return new BoolData(input);
            }
            case 6: {
                return new VarData(input);
            }
            case 7: {
                return new StructData(input, ctx);
            }
            case 11: {
                return new ArrayData<ObjectData>(input, () -> new ObjectData(input));
            }
            case 12: {
                return new ArrayData<StringData>(input, () -> new StringData(input));
            }
            case 13: {
                return new ArrayData<IntData>(input, () -> new IntData(input));
            }
            case 14: {
                return new ArrayData<FloatData>(input, () -> new FloatData(input));
            }
            case 15: {
                return new ArrayData<BoolData>(input, () -> new BoolData(input));
            }
            case 16: {
                return new ArrayData<VarData>(input, () -> new VarData(input));
            }
            case 17: {
                return new ArrayData<StructData>(input, () -> new StructData(input, ctx));
            }
        }
        throw new IOException(String.format("Invalid property type: %d", type));
    }

    public static class ArrayData<T extends PropertyData>
    extends PropertyData {
        private final List<T> MEMBERS;

        protected ArrayData(LittleEndianInput input, MemberReader<T> reader) throws IOException {
            int memberCount = input.readInt();
            this.MEMBERS = new ArrayList<T>(memberCount);
            for (int i = 0; i < memberCount; ++i) {
                T member = reader.get();
                this.MEMBERS.add(member);
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.MEMBERS.size());
            for (PropertyData t : this.MEMBERS) {
                t.write(output);
            }
        }

        @Override
        public int calculateSize() {
            int sum = 4;
            return sum += this.MEMBERS.stream().mapToInt(t -> t.calculateSize()).sum();
        }

        public String toString() {
            return this.MEMBERS.stream().map(v -> v.toString()).collect(Collectors.joining(", ", "[", "]"));
        }

        @FunctionalInterface
        public static interface MemberReader<S extends PropertyData> {
            public S get() throws IOException;
        }
    }

    public static class StructData
    extends PropertyData {
        private final List<Property> MEMBERS;

        public StructData(LittleEndianInput input, ESPContext ctx) throws IOException {
            int memberCount = input.readInt();
            this.MEMBERS = new ArrayList<Property>(memberCount);
            for (int i = 0; i < memberCount; ++i) {
                Property p = new Property(input, ctx);
                this.MEMBERS.add(p);
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.MEMBERS.size());
            for (Property p : this.MEMBERS) {
                p.write(output);
            }
        }

        @Override
        public int calculateSize() {
            return 4 + this.MEMBERS.stream().mapToInt(v -> v.calculateSize()).sum();
        }

        public String toString() {
            return this.MEMBERS.stream().map(v -> v.toString()).collect(Collectors.joining("; ", "{", "}"));
        }
    }

    public static class VarData
    extends PropertyData {
        private final int DATA;

        public VarData(LittleEndianInput input) throws IOException {
            this.DATA = input.readInt();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 4;
        }

        public String toString() {
            return String.format("VAR: %s", this.DATA);
        }
    }

    public static class BoolData
    extends PropertyData {
        private final boolean DATA;

        public BoolData(LittleEndianInput input) throws IOException {
            this.DATA = input.readBoolean();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeBoolean(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 1;
        }

        public String toString() {
            return Boolean.toString(this.DATA);
        }
    }

    public static class FloatData
    extends PropertyData {
        private final float DATA;

        public FloatData(LittleEndianInput input) throws IOException {
            this.DATA = input.readFloat();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeFloat(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 4;
        }

        public String toString() {
            return Float.toString(this.DATA);
        }
    }

    public static class IntData
    extends PropertyData {
        private final int DATA;

        public IntData(LittleEndianInput input) throws IOException {
            this.DATA = input.readInt();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 4;
        }

        public String toString() {
            return Integer.toString(this.DATA);
        }
    }

    public static class StringData
    extends PropertyData {
        private final String DATA;

        public StringData(LittleEndianInput input) throws IOException {
            this.DATA = input.readUTF();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeUTF(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 2 + this.DATA.length();
        }

        public String toString() {
            return this.DATA;
        }
    }

    public static class ObjectData
    extends PropertyData {
        private final long DATA;

        public ObjectData(LittleEndianInput input) throws IOException {
            this.DATA = input.readLong();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeLong(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 8;
        }

        public String toString() {
            return String.format("%08x", this.DATA);
        }
    }

    public static class NullData
    extends PropertyData {
        public NullData(LittleEndianInput input) throws IOException {
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
        }

        @Override
        public int calculateSize() {
            return 0;
        }

        public String toString() {
            return "NULL";
        }
    }
}

