/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import restringer.BoundedLittleEndianInput;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.Field;
import restringer.esp.FieldBasic;
import restringer.esp.FieldEDID;
import restringer.esp.FieldFull;
import restringer.esp.FieldName;
import restringer.esp.FieldVMAD;
import restringer.esp.FieldXXXX;
import restringer.esp.RecordBasic;
import restringer.esp.RecordCode;
import restringer.esp.RecordCompressed;
import restringer.esp.RecordGrup;
import restringer.ess.papyrus.EID;

public abstract class Record
implements Entry {
    public static final List<Field> readFields(RecordCode parentCode, LittleEndianInput input, ESPContext ctx) throws IOException {
        LinkedList<Field> FIELDS = new LinkedList<Field>();
        while (input.available() > 0) {
            List<Field> fieldsRead = Record.readField(parentCode, input, ctx);
            FIELDS.addAll(fieldsRead);
        }
        return FIELDS;
    }

    public static final List<Field> readField(RecordCode parentCode, LittleEndianInput input, ESPContext ctx) throws IOException {
        return Record.readFieldAux(parentCode, input, 0, ctx);
    }

    private static List<Field> readFieldAux(RecordCode parentCode, LittleEndianInput input, int bigSize, ESPContext ctx) throws IOException {
        assert (input.available() > 0);
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        IString CODE = IString.get(new String(CODEBYTES));
        ctx.pushContext(CODE);
        boolean BIG = bigSize > 0;
        int DATASIZE = input.readUnsignedShort();
        int ACTUALSIZE = BIG ? bigSize : DATASIZE;
        BoundedLittleEndianInput FIELDINPUT = new BoundedLittleEndianInput(input, ACTUALSIZE);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (CODE.equals(IString.get("XXXX"))) {
            FieldXXXX xxxx = new FieldXXXX(CODE, FIELDINPUT);
            List<Field> fieldsRead = Record.readFieldAux(parentCode, input, xxxx.getData(), ctx);
            fields.add(xxxx);
            fields.addAll(fieldsRead);
        } else if (CODE.equals(IString.get("VMAD"))) {
            FieldVMAD field = new FieldVMAD(parentCode, CODE, FIELDINPUT, BIG, ctx);
            fields.add(field);
        } else if (CODE.equals(IString.get("EDID"))) {
            FieldEDID field = new FieldEDID(CODE, FIELDINPUT, ACTUALSIZE, BIG, ctx);
            fields.add(field);
        } else if (CODE.equals(IString.get("FULL"))) {
            FieldFull field = new FieldFull(CODE, FIELDINPUT, ACTUALSIZE, BIG, ctx);
            fields.add(field);
        } else if (CODE.equals(IString.get("NAME")) && (parentCode == RecordCode.ACHR || parentCode == RecordCode.REFR)) {
            FieldName field = new FieldName(CODE, FIELDINPUT, ACTUALSIZE, BIG, ctx);
            fields.add(field);
        } else {
            FieldBasic field = new FieldBasic(CODE, FIELDINPUT, ACTUALSIZE, BIG, ctx);
            fields.add(field);
        }
        ctx.popContext();
        return fields;
    }

    public abstract RecordCode getCode();

    public static Record readRecord(LittleEndianInput input, ESPContext ctx) throws IOException {
        if (input.available() < 24) {
            throw new IOException();
        }
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        String CODESTRING = new String(CODEBYTES);
        RecordCode CODE = RecordCode.valueOf(CODESTRING);
        int DATASIZE = input.readInt();
        if (CODE == RecordCode.GRUP) {
            byte[] HEADER = new byte[16];
            input.readFully(HEADER);
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE - 24);
            return new RecordGrup(CODE, HEADER, RECORDINPUT, ctx);
        }
        Header HEADER = new Header(input, ctx);
        BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE);
        if (HEADER.isCompressed()) {
            return new RecordCompressed(CODE, HEADER, RECORDINPUT, ctx);
        }
        return new RecordBasic(CODE, HEADER, RECORDINPUT, ctx);
    }

    public static void skimRecord(LittleEndianInput input, ESPContext ctx) throws IOException {
        if (input.available() < 24) {
            throw new IOException();
        }
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        String CODESTRING = new String(CODEBYTES);
        RecordCode CODE = RecordCode.valueOf(CODESTRING);
        int DATASIZE = input.readInt();
        if (CODE == RecordCode.GRUP) {
            byte[] HEADER = new byte[16];
            input.readFully(HEADER);
            LittleEndianInputStream headerStream = LittleEndianInputStream.wrap(HEADER);
            int PREFIX = headerStream.readInt();
            int TYPE2 = headerStream.readInt();
            switch (TYPE2) {
                case 0: {
                    ctx.pushContext(new String(HEADER, 0, 4));
                    break;
                }
                case 4: 
                case 5: {
                    int X = TYPE2 == 4 || TYPE2 == 5 ? PREFIX & 0xFFFF : -1;
                    int Y = TYPE2 == 4 || TYPE2 == 5 ? PREFIX >>> 4 : -1;
                    ctx.pushContext(X + ", " + Y);
                    break;
                }
                case 2: {
                    ctx.pushContext("Block " + PREFIX);
                    break;
                }
                case 3: {
                    ctx.pushContext("SubBlock " + PREFIX);
                    break;
                }
                default: {
                    ctx.pushContext(EID.pad8(PREFIX));
                }
            }
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE - 24);
            RecordGrup.skimGRUP(CODE, HEADER, RECORDINPUT, ctx);
            ctx.popContext();
        } else {
            Header HEADER = new Header(input, ctx);
            ctx.pushContext(EID.pad8(HEADER.ID));
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE);
            if (HEADER.isCompressed()) {
                RecordCompressed.skimRecord(CODE, HEADER, RECORDINPUT, ctx);
            } else {
                RecordBasic.skimRecord(CODE, HEADER, RECORDINPUT, ctx);
            }
            ctx.popContext();
        }
    }

    public static class Header
    implements Entry {
        public final int FLAGS;
        public final int ID;
        public final int REVISION;
        public final short VERSION;
        public final short UNKNOWN;

        public Header(LittleEndianInput input, ESPContext ctx) throws IOException {
            int newID;
            this.FLAGS = input.readInt();
            int id = input.readInt();
            this.ID = newID = null == ctx ? id : ctx.TES4.remapFormID(id);
            this.REVISION = input.readInt();
            this.VERSION = input.readShort();
            this.UNKNOWN = input.readShort();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.FLAGS);
            output.writeInt(this.ID);
            output.writeInt(this.REVISION);
            output.writeShort(this.VERSION);
            output.writeShort(this.UNKNOWN);
        }

        @Override
        public int calculateSize() {
            return 16;
        }

        public boolean isCompressed() {
            return (this.FLAGS & 0x40000) != 0;
        }

        public boolean isLocalized() {
            return (this.FLAGS & 0x80) != 0;
        }
    }
}

