/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Record;
import restringer.esp.RecordCode;

public class RecordGrup
extends Record {
    private final RecordCode CODE;
    private final byte[] HEADER;
    private final List<Record> RECORDS;

    static void skimGRUP(RecordCode code, byte[] headerData, LittleEndianInput input, ESPContext ctx) throws IOException {
        while (input.available() > 0) {
            Record.skimRecord(input, ctx);
        }
    }

    public RecordGrup(RecordCode code, byte[] headerData, LittleEndianInput input, ESPContext ctx) throws IOException {
        this.CODE = code;
        this.HEADER = (byte[])headerData.clone();
        this.RECORDS = new LinkedList<Record>();
        while (input.available() > 0) {
            Record record = Record.readRecord(input, ctx);
            this.RECORDS.add(record);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.toString().getBytes());
        output.writeInt(this.calculateSize());
        output.write(this.HEADER);
        for (Record record : this.RECORDS) {
            record.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 24;
        return sum += this.RECORDS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    @Override
    public RecordCode getCode() {
        return this.CODE;
    }

    public String toString() {
        return this.getCode().toString();
    }
}

