/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPContext;
import restringer.esp.Entry;
import restringer.esp.Property;

public class Script
implements Entry {
    public final IString NAME;
    private final byte STATUS;
    final List<Property> PROPERTIES;

    public Script(LittleEndianInput input, ESPContext ctx) throws IOException {
        this.NAME = IString.get(input.readUTF());
        if (this.NAME.isEmpty()) {
            this.PROPERTIES = null;
            this.STATUS = 0;
            return;
        }
        ctx.pushContext("script:" + this.NAME);
        this.STATUS = input.readByte();
        try {
            int propertyCount = input.readUnsignedShort();
            this.PROPERTIES = new ArrayList<Property>(propertyCount);
            for (int i = 0; i < propertyCount; ++i) {
                Property prop = new Property(input, ctx);
                this.PROPERTIES.add(prop);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading script " + this.NAME, ex);
        }
        finally {
            ctx.popContext();
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        if (this.NAME.isEmpty()) {
            output.writeUTF(this.NAME.toString());
            return;
        }
        output.writeUTF(this.NAME.toString());
        output.writeByte(this.STATUS);
        output.writeShort(this.PROPERTIES.size());
        for (Property prop : this.PROPERTIES) {
            prop.write(output);
        }
    }

    @Override
    public int calculateSize() {
        if (this.NAME.isEmpty()) {
            return 2;
        }
        int sum = 5 + this.NAME.length();
        return sum += this.PROPERTIES.stream().mapToInt(v -> v.calculateSize()).sum();
    }
}

