/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ChangeFormACHR;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormDefault;
import restringer.ess.ChangeFormFLST;
import restringer.ess.ChangeFormNPC;
import restringer.ess.ChangeFormRefr;
import restringer.ess.ESS;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.Flags;
import restringer.ess.Linkable;
import restringer.ess.RefID;
import restringer.ess.papyrus.ScriptInstance;

public final class ChangeForm
implements Element,
AnalyzableElement,
Linkable {
    private final RefID REFID;
    private final Flags.Int CHANGEFLAGS;
    private final int TYPEFIELD;
    private final Type TYPE;
    private final byte VERSION;
    private int length1;
    private int length2;
    private boolean compressed;
    private final ChangeFormData BODY;
    private final Collection<ScriptInstance> HOLDERS;
    private static final Logger LOG = Logger.getLogger(ChangeForm.class.getCanonicalName());

    public ChangeForm(LittleEndianInput input, ESSContext ctx) throws IOException {
        byte[] DATA;
        boolean compressedForm;
        Objects.requireNonNull(input);
        this.HOLDERS = new ArrayList<ScriptInstance>(1);
        this.REFID = new RefID(input);
        this.CHANGEFLAGS = Flags.readIntFlags(input);
        this.TYPEFIELD = input.readUnsignedByte();
        this.VERSION = input.readByte();
        int typeIdx = this.TYPEFIELD & 0x3F;
        if (typeIdx < 0 || typeIdx >= Type.VALUES.length) {
            throw new IOException("Invalid changeform type index: " + typeIdx);
        }
        this.TYPE = Type.VALUES[typeIdx];
        switch (this.getDataLength()) {
            case INT8: {
                this.length1 = input.readUnsignedByte();
                this.length2 = input.readUnsignedByte();
                break;
            }
            case INT16: {
                this.length1 = input.readUnsignedShort();
                this.length2 = input.readUnsignedShort();
                break;
            }
            case INT32: {
                this.length1 = input.readInt();
                this.length2 = input.readInt();
                break;
            }
            default: {
                throw new IOException("Invalid type.");
            }
        }
        byte[] BUF = new byte[this.length1];
        int BYTES_READ = input.read(BUF);
        assert (BYTES_READ == this.length1);
        boolean bl = compressedForm = this.length2 > 0;
        if (!compressedForm) {
            DATA = BUF;
        } else {
            byte[] DECOMPRESSED = this.decompress(BUF, this.length2);
            if (null == DECOMPRESSED) {
                this.compressed = false;
                this.BODY = new ChangeFormDefault(BUF);
                LOG.severe("A compressed changeForm contained corrupt data and could not be read.");
                return;
            }
            DATA = DECOMPRESSED;
        }
        switch (this.getType()) {
            case FLST: {
                this.compressed = compressedForm;
                this.BODY = ctx.GAME.isSkyrim() ? new ChangeFormFLST(DATA, this.CHANGEFLAGS) : new ChangeFormDefault(DATA);
                break;
            }
            default: {
                this.compressed = compressedForm;
                this.BODY = new ChangeFormDefault(DATA);
            }
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        this.REFID.write(output);
        this.CHANGEFLAGS.write(output);
        output.writeByte(this.TYPEFIELD);
        output.writeByte(this.VERSION);
        if (this.compressed) {
            assert (this.length2 > 0);
            Deflater DEFLATER = new Deflater();
            ByteArrayOutputStream DEFLATER_BUF = new ByteArrayOutputStream();
            try {
                try (LittleEndianDataOutput OUTPUT = new LittleEndianDataOutput(new DeflaterOutputStream((OutputStream)DEFLATER_BUF, DEFLATER));){
                    this.BODY.write(OUTPUT);
                }
                this.length2 = DEFLATER.getTotalIn();
                this.length1 = DEFLATER.getTotalOut();
                switch (this.getDataLength()) {
                    case INT8: {
                        output.writeByte(this.length1);
                        output.writeByte(this.length2);
                        break;
                    }
                    case INT16: {
                        output.writeShort(this.length1);
                        output.writeShort(this.length2);
                        break;
                    }
                    case INT32: {
                        output.writeInt(this.length1);
                        output.writeInt(this.length2);
                        break;
                    }
                    default: {
                        throw new IOException("Invalid type.");
                    }
                }
                DEFLATER_BUF.writeTo(output);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                DEFLATER.end();
            }
        }
        this.length1 = this.BODY.calculateSize();
        switch (this.getDataLength()) {
            case INT8: {
                output.writeByte(this.length1);
                output.writeByte(this.length2);
                break;
            }
            case INT16: {
                output.writeShort(this.length1);
                output.writeShort(this.length2);
                break;
            }
            case INT32: {
                output.writeInt(this.length1);
                output.writeInt(this.length2);
                break;
            }
            default: {
                throw new IOException("Invalid type.");
            }
        }
        this.BODY.write(output);
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += this.REFID.calculateSize();
        sum += this.CHANGEFLAGS.calculateSize();
        switch (this.getDataLength()) {
            case INT8: {
                sum += 2;
                break;
            }
            case INT16: {
                sum += 4;
                break;
            }
            case INT32: {
                sum += 8;
                break;
            }
            default: {
                return -1;
            }
        }
        if (this.compressed) {
            assert (this.length2 > 0);
            Deflater DEFLATER = new Deflater();
            ByteArrayOutputStream DEFLATER_BUF = new ByteArrayOutputStream();
            try {
                try (LittleEndianDataOutput OUTPUT = new LittleEndianDataOutput(new DeflaterOutputStream((OutputStream)DEFLATER_BUF, DEFLATER, true));){
                    this.BODY.write(OUTPUT);
                }
                int bytesOut = DEFLATER.getTotalOut();
                sum += bytesOut;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                DEFLATER.end();
            }
        }
        sum += this.BODY.calculateSize();
        return sum;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.REFID.addNames(analysis);
        this.BODY.addNames(analysis);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.REFID.resolveRefs(ess, owner);
        this.BODY.resolveRefs(ess, owner);
    }

    public RefID getRefID() {
        return this.REFID;
    }

    public ChangeFormData getData() {
        return this.BODY;
    }

    public Type getType() {
        return this.TYPE;
    }

    public LengthSize getDataLength() {
        switch (this.TYPEFIELD >>> 6) {
            case 0: {
                return LengthSize.INT8;
            }
            case 1: {
                return LengthSize.INT16;
            }
            case 2: {
                return LengthSize.INT32;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String toHTML() {
        return this.REFID.toHTML();
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        BUF.append((Object)this.TYPE);
        if (null != this.REFID.getPlugin()) {
            BUF.append(" (").append(this.REFID.getPlugin()).append(")");
        }
        BUF.append(" ").append(this.REFID.toString());
        BUF.append(" ").append(this.BODY.toString());
        return BUF.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        ChangeFormData body = this.BODY;
        if (body instanceof ChangeFormDefault) {
            ChangeFormDefault DEF = (ChangeFormDefault)body;
            LittleEndianInputStream INPUT = LittleEndianInputStream.debug(DEF.getBuffer());
            try {
                switch (this.TYPE) {
                    case REFR: {
                        body = new ChangeFormRefr(INPUT, this.CHANGEFLAGS, this.REFID, analysis, save);
                        break;
                    }
                    case ACHR: {
                        body = new ChangeFormACHR(INPUT, this.CHANGEFLAGS, this.REFID, analysis, save);
                        break;
                    }
                    case NPC_: {
                        body = new ChangeFormNPC(INPUT, this.CHANGEFLAGS);
                        break;
                    }
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            if (null != analysis) {
                body.addNames(analysis);
            }
        }
        BUILDER.append("<html><h3>CHANGEFORM</h3>");
        BUILDER.append(String.format("<p>RefID: %s</p>", this.REFID));
        BUILDER.append(String.format("<p style=\"display:inline-table;\">ChangeFlags: %s</p>", this.CHANGEFLAGS.toHTML()));
        BUILDER.append("<p>");
        BUILDER.append(String.format("DataLength: %s<br/>", new Object[]{this.getDataLength()}));
        BUILDER.append(String.format("Type: %s<br/>", new Object[]{this.getType()}));
        BUILDER.append(String.format("Version: %d<br/>", this.VERSION));
        if (this.length2 > 0) {
            BUILDER.append(String.format("Length: %d bytes (%d bytes uncompressed)<br/>", this.length1, this.length2));
        } else {
            BUILDER.append(String.format("Length: %d bytes<br/>", this.length1));
        }
        BUILDER.append("</p>");
        if (this.HOLDERS.isEmpty()) {
            BUILDER.append("<p>No attached instances.</p>");
        } else {
            BUILDER.append(String.format("<p>%d attached instances:</p><ul>", this.HOLDERS.size()));
            this.HOLDERS.forEach(owner -> {
                if (owner instanceof Linkable) {
                    BUILDER.append(String.format("<li>%s - %s", owner.getClass().getSimpleName(), owner.toHTML()));
                } else {
                    BUILDER.append(String.format("<li>%s - %s", owner.getClass().getSimpleName(), owner));
                }
            });
            BUILDER.append("</ul>");
        }
        BUILDER.append(body.getInfo(analysis, save));
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return this.BODY.matches(analysis, mod) && this.HOLDERS.stream().anyMatch(v -> v.matches(analysis, mod));
    }

    public void addRefHolder(ScriptInstance newHolder) {
        Objects.requireNonNull(newHolder);
        this.HOLDERS.add(newHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decompress(byte[] buf, int length) {
        Inflater INFLATER = new Inflater();
        INFLATER.setInput(buf);
        try {
            byte[] DECOMPRESSED = new byte[length];
            int INFLATED_BYTES = INFLATER.inflate(DECOMPRESSED);
            assert (INFLATER.finished());
            assert (INFLATED_BYTES == length);
            byte[] byArray = DECOMPRESSED;
            return byArray;
        }
        catch (DataFormatException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            INFLATER.end();
        }
    }

    public boolean identical(ChangeForm other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.BODY, other.BODY);
    }

    public static enum Type {
        REFR(0, 63),
        ACHR(1, 64),
        PMIS(2, 65),
        PGRE(3, 67),
        PBEA(4, 68),
        PFLA(5, 69),
        CELL(6, 62),
        INFO(7, 78),
        QUST(8, 79),
        NPC_(9, 45),
        ACTI(10, 25),
        TACT(11, 26),
        ARMO(12, 27),
        BOOK(13, 28),
        CONT(14, 29),
        DOOR(15, 30),
        INGR(16, 31),
        LIGH(17, 32),
        MISC(18, 33),
        APPA(19, 34),
        STAT(20, 35),
        MSTT(21, 37),
        FURN(22, 42),
        WEAP(23, 43),
        AMMO(24, 44),
        KEYM(25, 47),
        ALCH(26, 48),
        IDLM(27, 49),
        NOTE(28, 50),
        ECZN(29, 105),
        CLAS(30, 10),
        FACT(31, 11),
        PACK(32, 81),
        NAVM(33, 75),
        WOOP(34, 120),
        MGEF(35, 19),
        SMQN(36, 115),
        SCEN(37, 124),
        LCTN(38, 106),
        RELA(39, 123),
        PHZD(40, 72),
        PBAR(41, 71),
        PCON(42, 70),
        FLST(43, 93),
        LVLN(44, 46),
        LVLI(45, 55),
        LVSP(46, 84),
        PARW(47, 66),
        ENCH(48, 22),
        UNKNOWN(49, -1);

        public final byte CODE;
        public final byte FULL;
        private static final Type[] VALUES;

        private Type(int code, int full) {
            this.CODE = (byte)code;
            this.FULL = (byte)full;
        }

        static {
            VALUES = Type.values();
        }
    }

    public static enum LengthSize {
        INT8,
        INT16,
        INT32;

    }
}

