/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormExtraData;
import restringer.ess.ChangeFormFlags;
import restringer.ess.ChangeFormInitialData;
import restringer.ess.ChangeFormInventoryItem;
import restringer.ess.ESS;
import restringer.ess.Flags;
import restringer.ess.GeneralElement;
import restringer.ess.RefID;

public class ChangeFormACHR
extends GeneralElement
implements ChangeFormData {
    private final ChangeFormFlags CHANGEFORMFLAGS;
    static final int CHANGE_FORM_FLAGS = ChangeFormACHR.log2(1);
    static final int CHANGE_REFR_MOVE = ChangeFormACHR.log2(2);
    static final int CHANGE_REFR_HAVOK_MOVE = ChangeFormACHR.log2(4);
    static final int CHANGE_REFR_CELL_CHANGED = ChangeFormACHR.log2(8);
    static final int CHANGE_REFR_SCALE = ChangeFormACHR.log2(16);
    static final int CHANGE_REFR_INVENTORY = ChangeFormACHR.log2(32);
    static final int CHANGE_REFR_EXTRA_OWNERSHIP = ChangeFormACHR.log2(64);
    static final int CHANGE_REFR_BASEOBJECT = ChangeFormACHR.log2(128);
    static final int CHANGE_REFR_PROMOTED = ChangeFormACHR.log2(0x2000000);
    static final int CHANGE_REFR_EXTRA_ACTIVATING = ChangeFormACHR.log2(0x4000000);
    static final int CHANGE_REFR_LEVELED_INVENTORY = ChangeFormACHR.log2(0x8000000);
    static final int CHANGE_REFR_ANIMATION = ChangeFormACHR.log2(0x10000000);
    static final int CHANGE_REFR_EXTRA_ENCOUNTER_ZONE = ChangeFormACHR.log2(0x20000000);
    static final int CHANGE_REFR_EXTRA_CREATED_ONLY = ChangeFormACHR.log2(0x40000000);
    static final int CHANGE_REFR_EXTRA_GAME_ONLY = ChangeFormACHR.log2(Integer.MIN_VALUE);
    static final int CHANGE_OBJECT_EXTRA_ITEM_DATA = ChangeFormACHR.log2(1024);
    static final int CHANGE_OBJECT_EXTRA_AMMO = ChangeFormACHR.log2(2048);
    static final int CHANGE_OBJECT_EXTRA_LOCK = ChangeFormACHR.log2(4096);
    static final int CHANGE_DOOR_EXTRA_TELEPORT = ChangeFormACHR.log2(131072);
    static final int CHANGE_OBJECT_EMPTY = ChangeFormACHR.log2(0x200000);
    static final int CHANGE_OBJECT_OPEN_DEFAULT_STATE = ChangeFormACHR.log2(0x400000);
    static final int CHANGE_OBJECT_OPEN_STATE = ChangeFormACHR.log2(0x800000);

    public ChangeFormACHR(LittleEndianInput input, Flags.Int flags, RefID refid, Analysis analysis, ESS ess) throws IOException {
        Objects.requireNonNull(input);
        int initialType = refid.getType() == RefID.Type.CREATED ? 5 : (flags.getFlag(CHANGE_REFR_PROMOTED) || flags.getFlag(CHANGE_REFR_CELL_CHANGED) ? 6 : (flags.getFlag(CHANGE_REFR_HAVOK_MOVE) || flags.getFlag(CHANGE_REFR_MOVE) ? 4 : 0));
        super.readElement(input, "Initial", in -> new ChangeFormInitialData(in, initialType));
        if (flags.getFlag(CHANGE_REFR_HAVOK_MOVE)) {
            this.readBytesVS(input, "HavokData").toByteArray();
        }
        this.CHANGEFORMFLAGS = flags.getFlag(CHANGE_FORM_FLAGS) ? super.readElement(input, "ChangeFormFlags", in -> new ChangeFormFlags(in)) : null;
        if (flags.getFlag(CHANGE_REFR_BASEOBJECT)) {
            super.readRefID(input, "BaseObject");
        }
        if (flags.getFlag(CHANGE_REFR_SCALE)) {
            super.readFloat(input, "scale");
        }
        if (flags.getFlag(CHANGE_REFR_EXTRA_OWNERSHIP) || flags.getFlag(CHANGE_OBJECT_EXTRA_LOCK) || flags.getFlag(CHANGE_REFR_EXTRA_ENCOUNTER_ZONE) || flags.getFlag(CHANGE_REFR_EXTRA_GAME_ONLY) || flags.getFlag(CHANGE_OBJECT_EXTRA_AMMO) || flags.getFlag(CHANGE_DOOR_EXTRA_TELEPORT) || flags.getFlag(CHANGE_REFR_PROMOTED) || flags.getFlag(CHANGE_REFR_EXTRA_ACTIVATING) || flags.getFlag(CHANGE_OBJECT_EXTRA_ITEM_DATA)) {
            super.readElement(input, "ExtraData", in -> new ChangeFormExtraData(in));
        }
        if (flags.getFlag(CHANGE_REFR_INVENTORY) || flags.getFlag(CHANGE_REFR_LEVELED_INVENTORY)) {
            super.readVSElemArray(input, "Inventory", in -> new ChangeFormInventoryItem(in));
        }
        if (flags.getFlag(CHANGE_REFR_ANIMATION)) {
            super.readBytesVS(input, "Animations");
        }
    }

    public ChangeFormFlags getRefID() {
        return this.CHANGEFORMFLAGS;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return false;
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<hr/><p>NPC:</p>");
        return BUILDER.toString();
    }

    private static int log2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }
}

