/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.Profile;
import restringer.ess.ChangeFormData;
import restringer.ess.ESS;
import restringer.ess.Element;

public final class ChangeFormDefault
implements ChangeFormData {
    private final byte[] BUFFER;

    public ChangeFormDefault(byte[] buf) {
        Objects.requireNonNull(buf);
        this.BUFFER = buf;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.write(this.BUFFER);
    }

    @Override
    public int calculateSize() {
        return this.BUFFER.length;
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<hr/><p>RAW DATA:</p><code><pre>");
        for (int i = 0; i < this.BUFFER.length; ++i) {
            if (i > 0 && i % 16 == 0) {
                BUILDER.append('\n');
            }
            byte B = this.BUFFER[i];
            BUILDER.append(String.format("%02x ", B));
        }
        BUILDER.append("</pre></code>");
        return BUILDER.toString();
    }

    public String toString() {
        return "";
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return false;
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Arrays.hashCode(this.BUFFER);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeFormDefault other = (ChangeFormDefault)obj;
        return Arrays.equals(this.BUFFER, other.BUFFER);
    }

    byte[] getBuffer() {
        return Arrays.copyOf(this.BUFFER, this.BUFFER.length);
    }
}

