/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.Profile;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormFlags;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Flags;
import restringer.ess.RefID;

public final class ChangeFormFLST
implements ChangeFormData {
    private final ChangeFormFlags FLAGS;
    private final List<RefID> FORMS;

    public ChangeFormFLST(byte[] buf, Flags.Int flags) throws IOException {
        this(LittleEndianInputStream.debug(buf), flags);
    }

    private ChangeFormFLST(LittleEndianInput input, Flags.Int flags) throws IOException {
        Objects.requireNonNull(input);
        this.FLAGS = flags.getFlag(1) ? new ChangeFormFlags(input) : null;
        if (flags.getFlag(31)) {
            int formCount = input.readInt();
            this.FORMS = new ArrayList<RefID>(formCount);
            for (int i = 0; i < formCount; ++i) {
                RefID REF = new RefID(input);
                this.FORMS.add(REF);
            }
        } else {
            this.FORMS = null;
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        if (null != this.FLAGS) {
            this.FLAGS.write(output);
        }
        if (null != this.FORMS) {
            output.writeInt(this.FORMS.size());
            for (RefID ref : this.FORMS) {
                ref.write(output);
            }
        }
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        if (null != this.FLAGS) {
            sum += this.FLAGS.calculateSize();
        }
        if (null != this.FORMS) {
            sum += 4;
            sum += this.FORMS.stream().mapToInt(v -> v.calculateSize()).sum();
        }
        return sum;
    }

    public ChangeFormFlags getRefID() {
        return this.FLAGS;
    }

    public int cleanse() {
        if (null == this.FORMS) {
            return 0;
        }
        int size = this.FORMS.size();
        this.FORMS.removeIf(v -> v.equals(RefID.NONE));
        return size - this.FORMS.size();
    }

    public boolean containsNullrefs() {
        return this.FORMS.contains(RefID.NONE);
    }

    public String toString() {
        if (null == this.FORMS) {
            return "";
        }
        if (this.containsNullrefs()) {
            return "(" + this.FORMS.size() + " refs, contains nullrefs)";
        }
        return "(" + this.FORMS.size() + " refs)";
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.FLAGS);
        hash = 41 * hash + Objects.hashCode(this.FORMS);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeFormFLST other = (ChangeFormFLST)obj;
        return Objects.equals(this.FLAGS, other.FLAGS) && Objects.equals(this.FORMS, other.FORMS);
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<hr/><p>FORMLIST:</p>");
        if (null != this.FLAGS) {
            BUILDER.append(String.format("<p>ChangeFormFlags: %s</p>", this.FLAGS));
        }
        if (null != this.FORMS) {
            BUILDER.append(String.format("<p>List size: %d</p><ol start=0>", this.FORMS.size()));
            this.FORMS.forEach(refid -> {
                if (save.getChangeForms().containsKey(refid)) {
                    BUILDER.append(String.format("<li>%s", refid.toHTML()));
                } else {
                    BUILDER.append(String.format("<li>%s", refid));
                }
            });
            BUILDER.append("</ol>");
        }
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return false;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.FORMS.forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.FORMS.forEach(v -> v.resolveRefs(ess, owner));
    }
}

