/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormExtraData;
import restringer.ess.ChangeFormFlags;
import restringer.ess.ChangeFormInitialData;
import restringer.ess.ChangeFormInventoryItem;
import restringer.ess.ESS;
import restringer.ess.Flags;
import restringer.ess.GeneralElement;
import restringer.ess.RefID;

public class ChangeFormRefr
extends GeneralElement
implements ChangeFormData {
    static final int CHANGE_FORM_FLAGS = ChangeFormRefr.log2(1);
    static final int CHANGE_REFR_MOVE = ChangeFormRefr.log2(2);
    static final int CHANGE_REFR_HAVOK_MOVE = ChangeFormRefr.log2(4);
    static final int CHANGE_REFR_CELL_CHANGED = ChangeFormRefr.log2(8);
    static final int CHANGE_REFR_SCALE = ChangeFormRefr.log2(16);
    static final int CHANGE_REFR_INVENTORY = ChangeFormRefr.log2(32);
    static final int CHANGE_REFR_EXTRA_OWNERSHIP = ChangeFormRefr.log2(64);
    static final int CHANGE_REFR_BASEOBJECT = ChangeFormRefr.log2(128);
    static final int CHANGE_REFR_PROMOTED = ChangeFormRefr.log2(0x2000000);
    static final int CHANGE_REFR_EXTRA_ACTIVATING = ChangeFormRefr.log2(0x4000000);
    static final int CHANGE_REFR_LEVELED_INVENTORY = ChangeFormRefr.log2(0x8000000);
    static final int CHANGE_REFR_ANIMATION = ChangeFormRefr.log2(0x10000000);
    static final int CHANGE_REFR_EXTRA_ENCOUNTER_ZONE = ChangeFormRefr.log2(0x20000000);
    static final int CHANGE_REFR_EXTRA_CREATED_ONLY = ChangeFormRefr.log2(0x40000000);
    static final int CHANGE_REFR_EXTRA_GAME_ONLY = ChangeFormRefr.log2(Integer.MIN_VALUE);
    static final int CHANGE_OBJECT_EXTRA_ITEM_DATA = ChangeFormRefr.log2(1024);
    static final int CHANGE_OBJECT_EXTRA_AMMO = ChangeFormRefr.log2(2048);
    static final int CHANGE_OBJECT_EXTRA_LOCK = ChangeFormRefr.log2(4096);
    static final int CHANGE_DOOR_EXTRA_TELEPORT = ChangeFormRefr.log2(131072);
    static final int CHANGE_OBJECT_EMPTY = ChangeFormRefr.log2(0x200000);
    static final int CHANGE_OBJECT_OPEN_DEFAULT_STATE = ChangeFormRefr.log2(0x400000);
    static final int CHANGE_OBJECT_OPEN_STATE = ChangeFormRefr.log2(0x800000);

    public ChangeFormRefr(LittleEndianInput input, Flags.Int flags, RefID refid, Analysis analysis, ESS ess) throws IOException {
        Objects.requireNonNull(input);
        int initialType = refid.getType() == RefID.Type.CREATED ? 5 : (flags.getFlag(CHANGE_REFR_PROMOTED) || flags.getFlag(CHANGE_REFR_CELL_CHANGED) ? 6 : (flags.getFlag(CHANGE_REFR_HAVOK_MOVE) || flags.getFlag(CHANGE_REFR_MOVE) ? 4 : 0));
        super.readElement(input, "INITIAL", in -> new ChangeFormInitialData(in, initialType));
        if (flags.getFlag(CHANGE_REFR_HAVOK_MOVE)) {
            super.readBytesVS(input, "HAVOK");
        }
        if (flags.getFlag(CHANGE_FORM_FLAGS)) {
            super.readElement(input, "CHANGEFORMFLAGS", in -> new ChangeFormFlags(in));
        }
        if (flags.getFlag(CHANGE_REFR_BASEOBJECT)) {
            super.readRefID(input, "BASE_OBJECT");
        }
        if (flags.getFlag(CHANGE_REFR_SCALE)) {
            super.readFloat(input, "SCALE");
        }
        if (flags.getFlag(CHANGE_REFR_EXTRA_OWNERSHIP) || flags.getFlag(CHANGE_OBJECT_EXTRA_LOCK) || flags.getFlag(CHANGE_REFR_EXTRA_ENCOUNTER_ZONE) || flags.getFlag(CHANGE_REFR_EXTRA_GAME_ONLY) || flags.getFlag(CHANGE_OBJECT_EXTRA_AMMO) || flags.getFlag(CHANGE_DOOR_EXTRA_TELEPORT) || flags.getFlag(CHANGE_REFR_PROMOTED) || flags.getFlag(CHANGE_REFR_EXTRA_ACTIVATING) || flags.getFlag(CHANGE_OBJECT_EXTRA_ITEM_DATA)) {
            super.readElement(input, "EXTRADATA", in -> new ChangeFormExtraData(in));
        }
        if (flags.getFlag(CHANGE_REFR_INVENTORY) || flags.getFlag(CHANGE_REFR_LEVELED_INVENTORY)) {
            super.readVSElemArray(input, "INVENTORY", in -> new ChangeFormInventoryItem(in));
        }
        if (flags.getFlag(CHANGE_REFR_ANIMATION)) {
            super.readBytesVS(input, "ANIMATIONS");
        }
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<hr/><p>NPC:</p>");
        super.getValues().forEach((key, val) -> BUILDER.append("<p>").append((String)key).append(": ").append(val).append('\n'));
        BUILDER.append(super.toString());
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return false;
    }

    private static int log2(int n) {
        return 31 - Integer.numberOfLeadingZeros(n);
    }
}

