/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import restringer.Analysis;
import restringer.Game;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.Profile;
import restringer.Timer;
import restringer.ess.ChangeForm;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormFLST;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.GlobalData;
import restringer.ess.Header;
import restringer.ess.Plugin;
import restringer.ess.PluginInfo;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.Papyrus;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.SuspendedStack;
import restringer.gui.FilterTreeModel;
import restringer.gui.ProgressModel;

public final class ESS
implements Element {
    private final Header HEADER;
    private final byte FORMVERSION;
    private final String VERSION_STRING;
    private final PluginInfo PLUGINS;
    private final FileLocationTable FLT;
    private final List<GlobalData> TABLE1;
    private final List<GlobalData> TABLE2;
    private final List<ChangeForm> CHANGEFORMS;
    private final Map<RefID, ChangeForm> CHANGEFORMS_MAP;
    private final List<GlobalData> TABLE3;
    private final int[] FORMIDARRAY;
    private final int[] VISITEDWORLDSPACEARRAY;
    private final byte[] UNKNOWN3;
    private final byte[] COSAVE;
    final File ORIGINAL_FILE;
    private final Long DIGEST;
    private final Papyrus PAPYRUS;
    private final Timer TIMER;
    private ProgressModel rangeModel;
    private static final Logger LOG = Logger.getLogger(ESS.class.getCanonicalName());
    private static File prevSaveFile = null;
    public static final Predicate<Element> THREAD = v -> v instanceof ActiveScript;
    public static final Predicate<Element> OWNABLE = v -> v instanceof ActiveScript || v instanceof StackFrame || v instanceof ArrayInfo;
    public static final Predicate<Element> DELETABLE = v -> v instanceof Script || v instanceof ScriptInstance || v instanceof Reference || v instanceof ArrayInfo || v instanceof ActiveScript || v instanceof ChangeForm || v instanceof SuspendedStack;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result readESS(File saveFile, ProgressModel model) throws IOException {
        Objects.requireNonNull(saveFile);
        model = model == null ? new ProgressModel() : model;
        model.setValueIsAdjusting(true);
        model.setMinimum(0);
        model.setMaximum(50682);
        model.setValue(0);
        model.setValueIsAdjusting(false);
        Timer TIMER = Timer.startNew("reading savefile");
        Game GAME = Game.matchFilename(saveFile.getName());
        if (null == GAME) {
            throw new IOException("Filename extension not recognized.");
        }
        String COSAVE_FILENAME = saveFile.getName().replaceAll("ess$", GAME.SCRIPTEXT);
        File COSAVE_FILE = new File(saveFile.getParent(), COSAVE_FILENAME);
        if (COSAVE_FILE.exists()) {
            try (LittleEndianInputStream input = LittleEndianInputStream.openD(saveFile);){
                byte[] cosave = Files.readAllBytes(COSAVE_FILE.toPath());
                ESS ess = new ESS(input, saveFile, cosave, model);
                Result result = new Result(ess, saveFile, COSAVE_FILE, null, TIMER);
                return result;
            }
        }
        LittleEndianInputStream input = LittleEndianInputStream.openD(saveFile);
        Throwable throwable = null;
        try {
            ESS ess = new ESS(input, saveFile, null, model);
            Result result = new Result(ess, saveFile, null, null, TIMER);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            prevSaveFile = saveFile;
        }
    }

    public static Result writeESS(ESS ess, File saveFile, ProgressModel model) throws IOException {
        Objects.requireNonNull(ess);
        Objects.requireNonNull(saveFile);
        Objects.requireNonNull(model);
        model.setValueIsAdjusting(true);
        model.setMinimum(0);
        model.setMaximum(50682);
        model.setValue(0);
        model.setValueIsAdjusting(false);
        Timer TIMER = Timer.startNew("writing savefile");
        Game GAME = ess.getHeader().GAME;
        boolean TESTMODE = false;
        File backup = null;
        if (saveFile.exists()) {
            backup = ESS.makeBackupFile(saveFile);
        }
        if (ess.COSAVE != null) {
            String COSAVE_FILENAME = saveFile.getName().replaceAll(GAME.EXT + "$", GAME.SCRIPTEXT);
            File COSAVE_FILE = new File(saveFile.getParent(), COSAVE_FILENAME);
            if (COSAVE_FILE.exists()) {
                ESS.makeBackupFile(COSAVE_FILE);
            }
            Files.write(COSAVE_FILE.toPath(), ess.COSAVE, new OpenOption[0]);
            try (LittleEndianDataOutput output = LittleEndianDataOutput.open(saveFile);){
                ess.rangeModel = model;
                ess.write(output);
            }
            return new Result(ess, saveFile, COSAVE_FILE, backup, TIMER);
        }
        try (LittleEndianDataOutput output = LittleEndianDataOutput.open(saveFile);){
            ess.rangeModel = model;
            ess.write(output);
        }
        return new Result(ess, saveFile, null, backup, TIMER);
    }

    private ESS(LittleEndianInputStream input, File saveFile, byte[] cosave, ProgressModel model) throws IOException {
        GlobalData DATA;
        LittleEndianInputStream INPUT;
        Objects.requireNonNull(input);
        Objects.requireNonNull(model);
        this.rangeModel = Objects.requireNonNull(model);
        int i = -1;
        this.TIMER = new Timer("Timer");
        this.TIMER.start();
        LOG.info("Reading savegame.");
        this.HEADER = new Header(input);
        Game game = this.HEADER.GAME;
        LOG.fine("Reading savegame: read header.");
        if (game.isSSE()) {
            int ORIGINAL_LEN = input.readInt();
            int COMPRESSED_LEN = input.readInt();
            byte[] ORIGINAL = new byte[ORIGINAL_LEN];
            byte[] COMPRESSED = new byte[COMPRESSED_LEN];
            input.read(COMPRESSED);
            LZ4Factory LZ4FACTORY = LZ4Factory.safeInstance();
            LZ4SafeDecompressor LZ4DECOMP = LZ4FACTORY.safeDecompressor();
            LZ4DECOMP.decompress(COMPRESSED, ORIGINAL);
            INPUT = LittleEndianInputStream.wrap(ORIGINAL);
        } else {
            INPUT = input;
        }
        this.FORMVERSION = INPUT.readByte();
        switch (game) {
            case SKYRIM_LE: {
                assert (this.FORMVERSION == 74 || this.FORMVERSION == 73) : "Invalid formVersion: " + this.FORMVERSION;
                this.VERSION_STRING = null;
                break;
            }
            case SKYRIM_SE: {
                assert (this.FORMVERSION == 77) : "Invalid formVersion: " + this.FORMVERSION;
                this.VERSION_STRING = null;
                break;
            }
            case FALLOUT4: {
                assert (this.FORMVERSION == 67) : "Invalid formVersion: " + this.FORMVERSION;
                this.VERSION_STRING = INPUT.readWString();
                System.out.println(this.VERSION_STRING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized game.");
            }
        }
        ESSContext CTX = new ESSContext(this.HEADER, this.FORMVERSION);
        int pluginInfoSize = INPUT.readInt();
        this.PLUGINS = new PluginInfo(INPUT);
        assert (pluginInfoSize == this.PLUGINS.calculateSize());
        LOG.fine("Reading savegame: read plugin table.");
        this.FLT = new FileLocationTable(INPUT, CTX.GAME);
        this.TABLE1 = new ArrayList<GlobalData>(this.FLT.TABLE1COUNT);
        this.TABLE2 = new ArrayList<GlobalData>(this.FLT.TABLE2COUNT);
        this.TABLE3 = new ArrayList<GlobalData>(this.FLT.TABLE3COUNT);
        this.CHANGEFORMS = new ArrayList<ChangeForm>(this.FLT.changeFormCount);
        this.CHANGEFORMS_MAP = new LinkedHashMap<RefID, ChangeForm>(this.FLT.changeFormCount);
        LOG.fine("Reading savegame: read file location table.");
        try {
            for (i = 0; i < this.FLT.TABLE1COUNT; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (0 <= DATA.getType() && DATA.getType() <= 100) : "Invalid type for Table1: " + DATA.getType();
                this.TABLE1.add(DATA);
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
                LOG.fine("Reading savegame: read global data table 1.");
            }
            LOG.fine("Reading savegame: read GlobalDataTable #1.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #1.", i, this.FLT.TABLE1COUNT), ex);
        }
        try {
            for (i = 0; i < this.FLT.TABLE2COUNT; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (100 <= DATA.getType() && DATA.getType() < 1000) : "Invalid type for Table2: " + DATA.getType();
                this.TABLE2.add(DATA);
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
            }
            LOG.fine("Reading savegame: read GlobalDataTable #2.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #2.", i, this.FLT.TABLE2COUNT), ex);
        }
        this.rangeModel.setValue(22);
        try {
            for (i = 0; i < this.FLT.changeFormCount; ++i) {
                ChangeForm FORM = new ChangeForm(INPUT, CTX);
                this.CHANGEFORMS.add(FORM);
                this.CHANGEFORMS_MAP.put(FORM.getRefID(), FORM);
            }
            LOG.fine("Reading savegame: read changeform table.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d ChangeForm definitions.", i, this.FLT.changeFormCount), ex);
        }
        this.rangeModel.setValue(820);
        try {
            for (i = 0; i < this.FLT.TABLE3COUNT; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (1000 <= DATA.getType() && DATA.getType() <= 1100) : "Invalid type for Table3: " + DATA.getType();
                this.TABLE3.add(DATA);
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
            }
            LOG.fine("Reading savegame: read GlobalDataTable #3.");
        }
        catch (IOException ex) {
            if (i == 1) {
                throw ex;
            }
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #3.", i, this.FLT.TABLE3COUNT), ex);
        }
        this.rangeModel.setValue(4207);
        Papyrus p = this.TABLE3.get(1).getPapyrus();
        int formIDCount = INPUT.readInt();
        this.FORMIDARRAY = new int[formIDCount];
        for (i = 0; i < formIDCount; ++i) {
            this.FORMIDARRAY[i] = INPUT.readInt();
        }
        LOG.fine("Reading savegame: read formid array.");
        int worldspaceIDCount = INPUT.readInt();
        this.VISITEDWORLDSPACEARRAY = new int[worldspaceIDCount];
        for (i = 0; i < worldspaceIDCount; ++i) {
            this.VISITEDWORLDSPACEARRAY[i] = INPUT.readInt();
        }
        LOG.fine("Reading savegame: read visited worldspace array.");
        byte[] BUF = new byte[8192];
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        while (INPUT.available() > 0) {
            int read = INPUT.read(BUF);
            BAOS.write(BUF, 0, read);
        }
        this.UNKNOWN3 = BAOS.toByteArray();
        LOG.fine("Reading savegame: read unknown block.");
        this.rangeModel.setValue(4326);
        assert (this.TABLE3.get(1).getType() == 1001);
        this.PAPYRUS = this.TABLE3.get(1).getPapyrus();
        LOG.fine("Papyrus block is ready.");
        this.resolveRefs();
        LOG.fine("Reading savegame: resolved Papyrus references.");
        this.rangeModel.setValue(15349);
        this.COSAVE = (byte[])(null == cosave ? null : cosave);
        float size = (float)this.calculateSize() / 1048576.0f;
        this.ORIGINAL_FILE = saveFile;
        this.DIGEST = input.getDigest();
        this.TIMER.stop();
        LOG.info(String.format("Savegame read: %.1f mb in %s.", Float.valueOf(size), this.TIMER.getFormattedTime()));
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        Objects.requireNonNull(this.rangeModel);
        LOG.info("Writing savegame.");
        this.TIMER.restart();
        Game game = this.HEADER.GAME;
        this.HEADER.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + 16 + this.HEADER.calculateSize());
        LOG.fine("Writing savegame: wrote header.");
        if (game == Game.SKYRIM_SE) {
            ByteArrayOutputStream BAOS = new ByteArrayOutputStream(this.calculateSize() / 2);
            try (LittleEndianDataOutput output2 = LittleEndianDataOutput.wrap(BAOS);){
                this.writeBody(output2);
            }
            byte[] ORIGINAL = BAOS.toByteArray();
            int ORIGINAL_LEN = ORIGINAL.length;
            LZ4Factory LZ4FACTORY = LZ4Factory.fastestInstance();
            LZ4Compressor LZ4COMP = LZ4FACTORY.fastCompressor();
            byte[] COMPRESSED = LZ4COMP.compress(ORIGINAL);
            int COMPRESSED_LEN = COMPRESSED.length;
            output.writeInt(ORIGINAL_LEN);
            output.writeInt(COMPRESSED_LEN);
            output.write(COMPRESSED);
        } else {
            this.writeBody(output);
        }
    }

    private void writeBody(LittleEndianDataOutput output) throws IOException {
        output.write(this.FORMVERSION);
        if (null != this.VERSION_STRING) {
            output.writeWString(this.VERSION_STRING);
        }
        output.writeInt(this.PLUGINS.calculateSize());
        this.PLUGINS.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + 5 + this.PLUGINS.calculateSize());
        LOG.fine("Writing savegame: wrote plugin table.");
        this.FLT.rebuild(this);
        this.FLT.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + this.FLT.calculateSize());
        LOG.fine("Writing savegame: rebuilt and wrote file location table.");
        for (GlobalData data : this.TABLE1) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE1.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 1.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #1.");
        for (GlobalData data : this.TABLE2) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE2.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 2.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #2.");
        for (ChangeForm form : this.CHANGEFORMS) {
            try {
                form.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + form.calculateSize());
            }
            catch (IOException ex) {
                int idx = this.CHANGEFORMS.indexOf(form);
                throw new IOException("Error writing ChangeForm " + idx + " / " + this.CHANGEFORMS.size() + ".", ex);
            }
        }
        LOG.fine("Writing savegame: wrote changeform table.");
        for (GlobalData data : this.TABLE3) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE3.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 3.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #3.");
        output.writeInt(this.FORMIDARRAY.length);
        for (Object formID : (Object)this.FORMIDARRAY) {
            output.writeInt((int)formID);
        }
        this.rangeModel.setValue(this.rangeModel.getValue() + 4 + 4 * this.FORMIDARRAY.length);
        LOG.fine("Writing savegame: wrote formid array.");
        output.writeInt(this.VISITEDWORLDSPACEARRAY.length);
        for (Object formID : (Object)this.VISITEDWORLDSPACEARRAY) {
            output.writeInt((int)formID);
        }
        this.rangeModel.setValue(this.rangeModel.getValue() + 4 + 4 * this.VISITEDWORLDSPACEARRAY.length);
        LOG.fine("Writing savegame: wrote visited worldspace array.");
        output.write(this.UNKNOWN3);
        this.rangeModel.setValue(this.rangeModel.getValue() + this.UNKNOWN3.length);
        LOG.fine("Writing savegame: wrote unknown block.");
        float size = (float)this.calculateSize() / 1048576.0f;
        this.TIMER.stop();
        LOG.info(String.format("Savegame written: %.1f mb in %s.", Float.valueOf(size), this.TIMER.getFormattedTime()));
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        sum += this.HEADER.calculateSize();
        if (null != this.VERSION_STRING) {
            sum += this.VERSION_STRING.length() + 2;
        }
        sum += this.PLUGINS.calculateSize();
        sum += this.FLT.calculateSize();
        sum += this.TABLE1.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.TABLE2.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.CHANGEFORMS.stream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.TABLE3.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += 4 * this.FORMIDARRAY.length;
        sum += 4;
        sum += 4 * this.VISITEDWORLDSPACEARRAY.length;
        return sum += this.UNKNOWN3.length;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.HEADER.addNames(analysis);
        this.FLT.addNames(analysis);
        this.PLUGINS.addNames(analysis);
        this.TABLE1.forEach(v -> v.addNames(analysis));
        this.TABLE2.forEach(v -> v.addNames(analysis));
        this.TABLE3.forEach(v -> v.addNames(analysis));
        this.CHANGEFORMS.forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.resolveRefs();
    }

    public void resolveRefs() {
        this.HEADER.resolveRefs(this, null);
        this.FLT.resolveRefs(this, null);
        this.PLUGINS.getPlugins().forEach(v -> v.resolveRefs(this, null));
        this.TABLE1.forEach(v -> v.resolveRefs(this, null));
        this.TABLE2.forEach(v -> v.resolveRefs(this, null));
        this.TABLE3.forEach(v -> v.resolveRefs(this, null));
        this.CHANGEFORMS.forEach(v -> v.resolveRefs(this, null));
    }

    public Papyrus getPapyrus() {
        return this.PAPYRUS;
    }

    public Long getDigest() {
        return this.DIGEST;
    }

    public File getOriginalFile() {
        return this.ORIGINAL_FILE;
    }

    public Map<RefID, ChangeForm> getChangeForms() {
        return this.CHANGEFORMS_MAP;
    }

    public int[] getFormIDs() {
        return this.FORMIDARRAY;
    }

    public PluginInfo getPluginInfo() {
        return this.PLUGINS;
    }

    public int resetHavok() {
        for (ChangeForm changeForm : this.CHANGEFORMS) {
        }
        return 0;
    }

    public int[] cleanseFormLists() {
        int entries = 0;
        int forms = 0;
        for (ChangeForm form : this.CHANGEFORMS) {
            ChangeFormFLST flst;
            int removed;
            ChangeFormData data = form.getData();
            if (!(data instanceof ChangeFormFLST) || (removed = (flst = (ChangeFormFLST)data).cleanse()) <= 0) continue;
            entries += removed;
            ++forms;
        }
        return new int[]{entries, forms};
    }

    public int removeNonexistentCreated() {
        this.PAPYRUS.getInstances().values().stream().map(v -> v.getRefID()).forEach(ref -> {
            assert (this.CHANGEFORMS_MAP.containsKey(ref) == (ref.getForm() != null));
        });
        Set NONEXISTENT = this.PAPYRUS.getInstances().values().stream().filter(v -> v.getRefID().isNonexistentCreated()).collect(Collectors.toSet());
        return this.getPapyrus().removeElements(NONEXISTENT);
    }

    public int removePluginInstances(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<ScriptInstance> INSTANCES = plugin.getInstances();
        return this.PAPYRUS.removeElements(INSTANCES);
    }

    public int removePluginForms(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<ChangeForm> FORMS = plugin.getForms();
        return this.removeElements(FORMS);
    }

    public int removeElements(Set<? extends Element> elements) {
        assert (null != elements);
        assert (!elements.contains(null));
        Set PE = elements.stream().filter(v -> v instanceof PapyrusElement).map(v -> (PapyrusElement)v).collect(Collectors.toSet());
        LinkedList ELEMENTS = new LinkedList(elements.stream().filter(v -> !(v instanceof PapyrusElement)).map(v -> (PapyrusElement)v).collect(Collectors.toSet()));
        int count = this.getPapyrus().removeElements(PE);
        while (!ELEMENTS.isEmpty()) {
            Element ELEMENT = (Element)ELEMENTS.pop();
            if (ELEMENT instanceof ChangeForm) {
                ChangeForm FORM = (ChangeForm)ELEMENT;
                if (!this.CHANGEFORMS.contains(FORM)) continue;
                this.CHANGEFORMS.remove(FORM);
                this.CHANGEFORMS_MAP.remove(FORM.getRefID());
                ++count;
                continue;
            }
            System.err.println("ESS.removeElements: can't delete this element: " + ELEMENT);
        }
        return count;
    }

    public FilterTreeModel createTreeModel() {
        FilterTreeModel.Node structsNode;
        FilterTreeModel.Node structDefNode;
        this.TIMER.restart();
        FilterTreeModel MODEL = new FilterTreeModel();
        Papyrus papyrus = this.getPapyrus();
        boolean FO4 = this.HEADER.GAME.isFO4();
        TreeMap<Character, ArrayList> stringDictionary = new TreeMap<Character, ArrayList>();
        int stringProtoSize = papyrus.getStringTable().size() / 50;
        papyrus.getStringTable().forEach(string -> {
            if (string.length() > 0) {
                char firstChar = Character.toUpperCase(string.charAt(0));
                if (Character.isLetter(firstChar)) {
                    List entry = stringDictionary.computeIfAbsent(Character.valueOf(firstChar), ch -> new ArrayList(stringProtoSize));
                    entry.add(string);
                } else {
                    List entry = stringDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(stringProtoSize));
                    entry.add(string);
                }
            } else {
                List entry = stringDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(stringProtoSize));
                entry.add(string);
            }
        });
        ArrayList<FilterTreeModel.Node> stringNodes = new ArrayList<FilterTreeModel.Node>(stringDictionary.size());
        stringDictionary.forEach((ch, list) -> stringNodes.add(MODEL.elementContainer(Character.toString(ch.charValue()), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying strings took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(16493);
        TreeMap<Character, ArrayList> instanceDictionary = new TreeMap<Character, ArrayList>();
        int instanceProtoSize = papyrus.getInstances().size() / 30;
        papyrus.getInstances().values().forEach(instance -> {
            char firstChar = Character.toUpperCase(instance.toString().charAt(0));
            if (Character.isLetter(firstChar)) {
                List entry = instanceDictionary.computeIfAbsent(Character.valueOf(firstChar), ch -> new ArrayList(instanceProtoSize));
                entry.add(instance);
            } else {
                List entry = instanceDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(instanceProtoSize));
                entry.add(instance);
            }
        });
        ArrayList<FilterTreeModel.Node> instanceNodes = new ArrayList<FilterTreeModel.Node>(instanceDictionary.size());
        instanceDictionary.forEach((ch, list) -> instanceNodes.add(MODEL.elementContainer(Character.toString(ch.charValue()), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying instances took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(45821);
        ArrayList<FilterTreeModel.Node> activeNodes = new ArrayList<FilterTreeModel.Node>(papyrus.getActiveScripts().size());
        papyrus.getActiveScripts().values().forEach(active -> activeNodes.add(MODEL.node((Element)active, active.getData().getStackFrames())));
        this.TIMER.stop();
        LOG.info(String.format("Making activeescript nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        List<FilterTreeModel.Node> funcNodes = papyrus.getFunctionMessages().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        this.TIMER.stop();
        LOG.info(String.format("Making function message nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        List<FilterTreeModel.Node> stackNodes1 = papyrus.getSuspendedStacks1().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        List<FilterTreeModel.Node> stackNodes2 = papyrus.getSuspendedStacks2().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        this.TIMER.stop();
        LOG.info(String.format("Making suspended stack nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(45831);
        TreeMap<ChangeForm.Type, ArrayList> formDictionary = new TreeMap<ChangeForm.Type, ArrayList>();
        int formProtoSize = this.getChangeForms().size() / 40;
        this.getChangeForms().values().forEach(form -> {
            ChangeForm.Type CODE = form.getType();
            List entry = formDictionary.computeIfAbsent(CODE, c -> new ArrayList(instanceProtoSize));
            entry.add(form);
        });
        ArrayList<FilterTreeModel.Node> formNodes = new ArrayList<FilterTreeModel.Node>(formDictionary.size());
        formDictionary.forEach((type, list) -> formNodes.add(MODEL.elementContainer(type.toString(), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying changeforms took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.TIMER.stop();
        LOG.info(String.format("Making queued unbind nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        FilterTreeModel.Node pluginsNode = MODEL.elementContainer("Plugins", this.getPluginInfo().getPlugins());
        FilterTreeModel.Node stringsNode = MODEL.nodeContainer("Strings", stringNodes);
        FilterTreeModel.Node scriptsNode = MODEL.elementContainer("Scripts", papyrus.getScripts().values());
        FilterTreeModel.Node instancesNode = MODEL.nodeContainer("Script Instances", instanceNodes);
        FilterTreeModel.Node referencesNode = MODEL.elementContainer("References", papyrus.getReferences().values());
        FilterTreeModel.Node arraysNode = MODEL.elementContainer("Arrays", papyrus.getArrays().values());
        FilterTreeModel.Node activeNode = MODEL.nodeContainer("Active Scripts", activeNodes);
        FilterTreeModel.Node funcNode = MODEL.nodeContainer("Function Messages", funcNodes);
        FilterTreeModel.Node stack1Node = MODEL.nodeContainer("Suspended Stacks 1", stackNodes1);
        FilterTreeModel.Node stack2Node = MODEL.nodeContainer("Suspended Stacks 2", stackNodes2);
        FilterTreeModel.Node formsNode = MODEL.nodeContainer("ChangeForms", formNodes);
        FilterTreeModel.Node unbindsNode = MODEL.elementContainer("QueuedUnbinds", papyrus.getUnbinds());
        if (FO4) {
            structDefNode = MODEL.elementContainer("StructDefs", papyrus.getStructDefs().values());
            structsNode = MODEL.elementContainer("Structs", papyrus.getStructs().values());
            structDefNode.sort();
            structsNode.sort();
        } else {
            structDefNode = null;
            structsNode = null;
        }
        this.TIMER.stop();
        LOG.info(String.format("Making toplevel folder nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(46670);
        stringNodes.forEach(n -> n.sort());
        instanceNodes.forEach(n -> n.sort());
        stringsNode.sort();
        instancesNode.sort();
        scriptsNode.sort();
        formsNode.sort();
        this.TIMER.stop();
        LOG.info(String.format("Sorting took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(50681);
        ArrayList<FilterTreeModel.Node> topLevel = new ArrayList<FilterTreeModel.Node>(14);
        topLevel.add(pluginsNode);
        topLevel.add(stringsNode);
        topLevel.add(scriptsNode);
        topLevel.add(instancesNode);
        if (FO4) {
            topLevel.add(structDefNode);
            topLevel.add(structsNode);
        }
        topLevel.add(referencesNode);
        topLevel.add(arraysNode);
        topLevel.add(activeNode);
        topLevel.add(funcNode);
        topLevel.add(stack1Node);
        topLevel.add(stack2Node);
        topLevel.add(formsNode);
        topLevel.add(unbindsNode);
        FilterTreeModel.Node root = MODEL.root(this, topLevel);
        MODEL.setRoot(root);
        this.TIMER.stop();
        LOG.info(String.format("Making the model %s.", this.TIMER.getFormattedTime()));
        this.rangeModel.setValue(50682);
        return MODEL;
    }

    public Element broadSpectrumMatch(int id) {
        RefID ref = new RefID(id);
        if (this.CHANGEFORMS_MAP.containsKey(ref)) {
            return this.CHANGEFORMS_MAP.get(ref);
        }
        return this.PAPYRUS.broadSpectrumMatch(EID.make4byte(id));
    }

    public Header getHeader() {
        return this.HEADER;
    }

    public String getInfo(Profile.Analysis analysis) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append(String.format("<html><body><h1>%s SAVEFILE</h1>", new Object[]{this.HEADER.GAME}));
        String race = this.HEADER.RACEID.toString().replace("Race", "");
        String name = this.HEADER.NAME.toString();
        int level = this.HEADER.LEVEL;
        String gender = this.HEADER.SEX == 0 ? "male" : "female";
        String location = this.HEADER.LOCATION.toString();
        String gameDate = this.HEADER.GAMEDATE.toString();
        float xp = this.HEADER.CURRENT_XP;
        float nexp = this.HEADER.NEEDED_XP + this.HEADER.CURRENT_XP;
        long time = this.HEADER.FILETIME;
        long millis = time / 10000L - 11644473600000L;
        Date DATE = new Date(millis);
        BUILDER.append(String.format("<h3>%s the level %s %s %s, in %s on %s (%1.0f/%1.0f xp).<br/>", name, level, race, gender, location, gameDate, Float.valueOf(xp), Float.valueOf(nexp)));
        BUILDER.append(String.format("Save number %d, created on %s.</h3>", this.HEADER.SAVENUMBER, DATE));
        BUILDER.append("<hr/>");
        BUILDER.append("</body></html>");
        return BUILDER.toString();
    }

    public String toString() {
        return this.ORIGINAL_FILE.getName();
    }

    private static void compareESS(File orig, File copy) throws IOException {
        try (LittleEndianInputStream IN1 = LittleEndianInputStream.openD(orig);
             LittleEndianInputStream IN2 = LittleEndianInputStream.openD(copy);){
            GlobalData DATA2;
            GlobalData DATA1;
            LittleEndianInputStream DEC2;
            LittleEndianInputStream DEC1;
            Header HEADER1 = new Header(IN1);
            Header HEADER2 = new Header(IN2);
            Game game = HEADER1.GAME;
            if (game.isSSE()) {
                DEC1 = LittleEndianInputStream.wrapD(new LZ4BlockInputStream(IN1));
                DEC2 = LittleEndianInputStream.wrapD(new LZ4BlockInputStream(IN2));
            } else {
                DEC1 = IN1;
                DEC2 = IN2;
            }
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            System.out.printf("pos1 = %d, pos2 = %d, dig1 = %08x, dig2 = %08x\n", DEC1.available(), DEC2.available(), DEC1.getDigest(), DEC2.getDigest());
            byte FORMVERSION1 = DEC1.readByte();
            byte FORMVERSION2 = DEC2.readByte();
            assert (FORMVERSION1 == FORMVERSION2);
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            switch (game) {
                case SKYRIM_LE: {
                    assert (FORMVERSION1 == 74 || FORMVERSION1 == 73) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 74 || FORMVERSION2 == 73) : "Invalid formVersion: " + FORMVERSION2;
                    break;
                }
                case SKYRIM_SE: {
                    assert (FORMVERSION1 == 77) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 77) : "Invalid formVersion: " + FORMVERSION2;
                    break;
                }
                case FALLOUT4: {
                    assert (FORMVERSION1 == 67) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 67) : "Invalid formVersion: " + FORMVERSION2;
                    String UNKNOWN_STRING1 = DEC1.readWString();
                    String UNKNOWN_STRING2 = DEC2.readWString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized game.");
                }
            }
            ESSContext CTX1 = new ESSContext(HEADER1, FORMVERSION1);
            ESSContext CTX2 = new ESSContext(HEADER2, FORMVERSION2);
            int pluginInfoSize1 = DEC1.readInt();
            int pluginInfoSize2 = DEC2.readInt();
            assert (pluginInfoSize1 == pluginInfoSize2);
            PluginInfo PLUGINS1 = new PluginInfo(DEC1);
            PluginInfo PLUGINS2 = new PluginInfo(DEC2);
            assert (Objects.equals(PLUGINS1, PLUGINS2));
            assert (pluginInfoSize1 == PLUGINS1.calculateSize());
            assert (pluginInfoSize2 == PLUGINS2.calculateSize());
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            FileLocationTable FLT1 = new FileLocationTable(DEC1, CTX1.GAME);
            FileLocationTable FLT2 = new FileLocationTable(DEC2, CTX2.GAME);
            assert (Objects.equals(FLT1, FLT2));
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            ArrayList<GlobalData> TABLE11 = new ArrayList<GlobalData>(FLT1.TABLE1COUNT);
            ArrayList<GlobalData> TABLE21 = new ArrayList<GlobalData>(FLT1.TABLE2COUNT);
            ArrayList<GlobalData> TABLE31 = new ArrayList<GlobalData>(FLT1.TABLE3COUNT);
            ArrayList<GlobalData> TABLE12 = new ArrayList<GlobalData>(FLT2.TABLE1COUNT);
            ArrayList<GlobalData> TABLE22 = new ArrayList<GlobalData>(FLT2.TABLE2COUNT);
            ArrayList<GlobalData> TABLE32 = new ArrayList<GlobalData>(FLT2.TABLE3COUNT);
            ArrayList<ChangeForm> CHANGEFORMS1 = new ArrayList<ChangeForm>(FLT1.changeFormCount);
            ArrayList<ChangeForm> CHANGEFORMS2 = new ArrayList<ChangeForm>(FLT2.changeFormCount);
            LinkedHashMap<RefID, ChangeForm> CHANGEFORMS_MAP1 = new LinkedHashMap<RefID, ChangeForm>(FLT1.changeFormCount);
            LinkedHashMap<RefID, ChangeForm> CHANGEFORMS_MAP2 = new LinkedHashMap<RefID, ChangeForm>(FLT2.changeFormCount);
            int i = 0;
            try {
                for (i = 0; i < FLT1.TABLE1COUNT; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE11.add(DATA1);
                    TABLE12.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                }
                assert (TABLE11.equals(TABLE12));
                LOG.fine("Reading savegame: read GlobalDataTable #1.");
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #1.", i, FLT1.TABLE1COUNT), ex);
            }
            try {
                for (i = 0; i < FLT1.TABLE2COUNT; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE21.add(DATA1);
                    TABLE22.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                }
                assert (TABLE21.equals(TABLE22));
                LOG.fine("Reading savegame: read GlobalDataTable #2.");
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #2.", i, FLT1.TABLE2COUNT), ex);
            }
            try {
                for (i = 0; i < FLT1.changeFormCount; ++i) {
                    ChangeForm FORM1 = new ChangeForm(DEC1, CTX1);
                    ChangeForm FORM2 = new ChangeForm(DEC2, CTX2);
                    CHANGEFORMS1.add(FORM1);
                    CHANGEFORMS2.add(FORM2);
                    assert (FORM1.identical(FORM2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                    CHANGEFORMS_MAP1.put(FORM1.getRefID(), FORM1);
                    CHANGEFORMS_MAP2.put(FORM2.getRefID(), FORM2);
                }
                LOG.fine("Reading savegame: read changeform table.");
            }
            catch (IOException | AssertionError ex) {
                throw new IOException(String.format("Error; read %d/%d ChangeForm definitions.", i, FLT1.changeFormCount), (Throwable)ex);
            }
            try {
                for (i = 0; i < FLT1.TABLE3COUNT; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE31.add(DATA1);
                    TABLE32.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2)) : "Data mismatch on table 1." + DATA1.getType();
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                    LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA1.getType());
                }
                assert (TABLE31.equals(TABLE32));
                LOG.fine("Reading savegame: read GlobalDataTable #3.");
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #3.", i, FLT1.TABLE3COUNT), ex);
            }
            Papyrus P1 = ((GlobalData)TABLE31.get(1)).getPapyrus();
            Papyrus P2 = ((GlobalData)TABLE32.get(1)).getPapyrus();
            int formIDCount1 = DEC1.readInt();
            int formIDCount2 = DEC2.readInt();
            assert (formIDCount1 == formIDCount2);
            int[] FORMIDARRAY1 = new int[formIDCount1];
            int[] FORMIDARRAY2 = new int[formIDCount2];
            System.out.printf("pos1 = %d, pos2 = %d, dig1 = %08x, dig2 = %08x\n", DEC1.available(), DEC2.available(), DEC1.getDigest(), DEC2.getDigest());
            for (i = 0; i < formIDCount1; ++i) {
                FORMIDARRAY1[i] = DEC1.readInt();
                FORMIDARRAY2[i] = DEC2.readInt();
            }
            assert (Arrays.equals(FORMIDARRAY1, FORMIDARRAY2));
            LOG.fine("Reading savegame: read formid array.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            int worldspaceIDCount1 = DEC1.readInt();
            int worldspaceIDCount2 = DEC2.readInt();
            assert (worldspaceIDCount1 == worldspaceIDCount2);
            int[] VISITEDWORLDSPACEARRAY1 = new int[worldspaceIDCount1];
            int[] VISITEDWORLDSPACEARRAY2 = new int[worldspaceIDCount2];
            for (i = 0; i < worldspaceIDCount1; ++i) {
                VISITEDWORLDSPACEARRAY1[i] = DEC1.readInt();
                VISITEDWORLDSPACEARRAY2[i] = DEC2.readInt();
            }
            assert (Arrays.equals(VISITEDWORLDSPACEARRAY1, VISITEDWORLDSPACEARRAY2));
            LOG.fine("Reading savegame: read visited worldspace array.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            byte[] BUF = new byte[8192];
            ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
            assert (DEC1.available() == DEC2.available());
            while (DEC1.available() > 0) {
                int read1 = DEC1.read(BUF);
                int read2 = DEC2.read(BUF);
                assert (read1 == read2);
                BAOS.write(BUF, 0, read1);
                BAOS.write(BUF, 0, read2);
            }
            byte[] UNKNOWN31 = BAOS.toByteArray();
            byte[] UNKNOWN32 = BAOS.toByteArray();
            assert (Arrays.equals(UNKNOWN31, UNKNOWN32));
            LOG.fine("Reading savegame: read unknown block.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
        }
        System.out.println("STILL IN TESTING MODE");
        throw new IllegalStateException("Write was successfull, but we are still in testing mode!!!");
    }

    /*
     * Exception decompiling
     */
    private static File makeBackupFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final class Result {
        public final ESS ESS;
        public final Game GAME;
        public final File SAVE_FILE;
        public final File COSAVE_FILE;
        public final File BACKUP_FILE;
        public final double TIME_S;
        public final double SIZE_MB;

        public Result(ESS ess, File save, File cosaveFile, File backup, Timer timer) {
            this.ESS = Objects.requireNonNull(ess);
            this.GAME = ess.getHeader().GAME;
            this.SAVE_FILE = Objects.requireNonNull(save);
            this.COSAVE_FILE = cosaveFile;
            this.BACKUP_FILE = backup;
            this.TIME_S = (double)timer.getElapsed() / 1.0E9;
            this.SIZE_MB = (double)save.length() / 1048576.0;
        }
    }

    public static final class FileLocationTable
    implements Element {
        int t1size;
        int t2size;
        int t3size;
        int formIDArrayCountOffset;
        int unknownTable3Offset;
        int table1Offset;
        int table2Offset;
        int changeFormsOffset;
        int table3Offset;
        final int TABLE1COUNT;
        final int TABLE2COUNT;
        final int TABLE3COUNT;
        int changeFormCount;
        final int[] UNUSED;
        final Game GAME;

        public FileLocationTable(LittleEndianInput input, Game game) throws IOException {
            assert (null != input);
            this.GAME = Objects.requireNonNull(game);
            this.formIDArrayCountOffset = input.readInt();
            this.unknownTable3Offset = input.readInt();
            this.table1Offset = input.readInt();
            this.table2Offset = input.readInt();
            this.changeFormsOffset = input.readInt();
            this.table3Offset = input.readInt();
            this.TABLE1COUNT = input.readInt();
            this.TABLE2COUNT = input.readInt();
            int count = input.readInt();
            this.TABLE3COUNT = this.GAME.isSkyrim() ? count + 1 : count;
            this.changeFormCount = input.readInt();
            this.UNUSED = new int[15];
            for (int i = 0; i < 15; ++i) {
                this.UNUSED[i] = input.readInt();
            }
            this.t1size = this.table2Offset - this.table1Offset;
            this.t2size = this.changeFormsOffset - this.table2Offset;
            this.t3size = this.table3Offset - this.changeFormsOffset;
        }

        public void rebuild(ESS ess) {
            int table1Size = ess.TABLE1.stream().mapToInt(v -> v.calculateSize()).sum();
            int table2Size = ess.TABLE2.stream().mapToInt(v -> v.calculateSize()).sum();
            int table3Size = ess.TABLE3.stream().mapToInt(v -> v.calculateSize()).sum();
            int changeFormsSize = ess.CHANGEFORMS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
            this.table1Offset = 0;
            this.table1Offset += ess.HEADER.calculateSize();
            this.table1Offset += 5;
            this.table1Offset += ess.PLUGINS.calculateSize();
            this.table1Offset += this.calculateSize();
            if (null != ess.VERSION_STRING) {
                this.table1Offset += ess.VERSION_STRING.length() + 2;
            }
            this.table2Offset = this.table1Offset + table1Size;
            this.changeFormCount = ess.CHANGEFORMS.size();
            this.changeFormsOffset = this.table2Offset + table2Size;
            this.table3Offset = this.changeFormsOffset + changeFormsSize;
            this.formIDArrayCountOffset = this.table3Offset + table3Size;
            this.unknownTable3Offset = 0;
            this.unknownTable3Offset += this.formIDArrayCountOffset;
            this.unknownTable3Offset += 4 + 4 * ess.FORMIDARRAY.length;
            this.unknownTable3Offset += 4 + 4 * ess.VISITEDWORLDSPACEARRAY.length;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            assert (null != output);
            output.writeInt(this.formIDArrayCountOffset);
            output.writeInt(this.unknownTable3Offset);
            output.writeInt(this.table1Offset);
            output.writeInt(this.table2Offset);
            output.writeInt(this.changeFormsOffset);
            output.writeInt(this.table3Offset);
            output.writeInt(this.TABLE1COUNT);
            output.writeInt(this.TABLE2COUNT);
            output.writeInt(this.GAME.isSkyrim() ? this.TABLE3COUNT - 1 : this.TABLE3COUNT);
            output.writeInt(this.changeFormCount);
            for (int i = 0; i < 15; ++i) {
                output.writeInt(this.UNUSED[i]);
            }
        }

        @Override
        public int calculateSize() {
            return 100;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + this.formIDArrayCountOffset;
            hash = 73 * hash + this.unknownTable3Offset;
            hash = 73 * hash + this.table1Offset;
            hash = 73 * hash + this.table2Offset;
            hash = 73 * hash + this.changeFormsOffset;
            hash = 73 * hash + this.table3Offset;
            hash = 73 * hash + this.TABLE1COUNT;
            hash = 73 * hash + this.TABLE2COUNT;
            hash = 73 * hash + this.TABLE3COUNT;
            hash = 73 * hash + this.changeFormCount;
            hash = 73 * hash + Arrays.hashCode(this.UNUSED);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileLocationTable other = (FileLocationTable)obj;
            if (this.formIDArrayCountOffset != other.formIDArrayCountOffset) {
                return false;
            }
            if (this.unknownTable3Offset != other.unknownTable3Offset) {
                return false;
            }
            if (this.table1Offset != other.table1Offset) {
                return false;
            }
            if (this.table2Offset != other.table2Offset) {
                return false;
            }
            if (this.changeFormsOffset != other.changeFormsOffset) {
                return false;
            }
            if (this.table3Offset != other.table3Offset) {
                return false;
            }
            if (this.TABLE1COUNT != other.TABLE1COUNT) {
                return false;
            }
            if (this.TABLE2COUNT != other.TABLE2COUNT) {
                return false;
            }
            if (this.TABLE3COUNT != other.TABLE3COUNT) {
                return false;
            }
            if (this.changeFormCount != other.changeFormCount) {
                return false;
            }
            return Arrays.equals(this.UNUSED, other.UNUSED);
        }

        @Override
        public void addNames(Analysis analysis) {
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
        }
    }
}

