/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import it.unimi.dsi.fastutil.bytes.AbstractByteList;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.floats.AbstractFloatList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.AbstractShortList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.RefID;
import restringer.ess.VSVal;

public class GeneralElement
implements Element {
    private final Map<String, Object> DATA = new Object2ObjectLinkedOpenHashMap<String, Object>();
    private static final Set<Class> SUPPORTED = new ObjectOpenHashSet<Class>(Arrays.asList(Element.class, Byte.class, Short.class, Integer.class, Float.class, String.class, ByteArrayList.class, ShortArrayList.class, IntArrayList.class, FloatArrayList.class, ObjectArrayList.class));

    public final SortedMap<String, Object> getValues() {
        return new Object2ObjectLinkedOpenHashMap<String, Object>(this.DATA);
    }

    public final boolean hasVal(String name) {
        Objects.requireNonNull(name);
        return this.DATA.containsKey(name);
    }

    public final Object getVal(String name) {
        Objects.requireNonNull(name);
        return this.DATA.get(name);
    }

    public final Element getElement(String name) {
        Objects.requireNonNull(name);
        Object val = this.DATA.get(name);
        if (null != val && val instanceof Element) {
            return (Element)val;
        }
        return null;
    }

    public final byte readByte(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        byte val = input.readByte();
        return this.addValue(name, val);
    }

    public final short readShort(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        short val = input.readShort();
        return this.addValue(name, val);
    }

    public final int readInt(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        int val = input.readInt();
        return this.addValue(name, val);
    }

    public final long readLong(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        long val = input.readLong();
        return this.addValue(name, val);
    }

    public final float readFloat(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        float val = input.readFloat();
        return this.addValue(name, Float.valueOf(val)).floatValue();
    }

    public final String readZString(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        String val = input.readZString(256);
        return this.addValue(name, val);
    }

    public final <T extends Element> T readElement(LittleEndianInput input, String name, ElementReader<T> reader) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        T element = reader.read(input);
        return (T)((Element)this.addValue(name, element));
    }

    public final RefID readRefID(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        RefID ref = new RefID(input);
        return this.addValue(name, ref);
    }

    public final VSVal readVSVal(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal val = new VSVal(input);
        return this.addValue(name, val);
    }

    public final ByteArrayList readBytes(LittleEndianInput input, String name, int size) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        assert (0 < size);
        assert (size <= 256);
        ByteArrayList val = new ByteArrayList(size);
        for (int i = 0; i < size; ++i) {
            val.add(input.readByte());
        }
        return this.addValue(name, val);
    }

    public final ShortArrayList readShorts(LittleEndianInput input, String name, int size) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        assert (0 < size);
        assert (size <= 256);
        ShortArrayList val = new ShortArrayList(size);
        for (int i = 0; i < size; ++i) {
            val.add(input.readShort());
        }
        return this.addValue(name, val);
    }

    public final IntArrayList readInts(LittleEndianInput input, String name, int size) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        assert (0 < size);
        assert (size <= 256);
        IntArrayList val = new IntArrayList(size);
        for (int i = 0; i < size; ++i) {
            val.add(input.readInt());
        }
        return this.addValue(name, val);
    }

    public final LongArrayList readLongs(LittleEndianInput input, String name, int size) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        assert (0 < size);
        assert (size <= 256);
        LongArrayList val = new LongArrayList(size);
        for (int i = 0; i < size; ++i) {
            val.add(input.readLong());
        }
        return this.addValue(name, val);
    }

    public final FloatArrayList readFloats(LittleEndianInput input, String name, int size) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        assert (0 < size);
        assert (size <= 256);
        FloatArrayList val = new FloatArrayList(size);
        for (int i = 0; i < size; ++i) {
            val.add(input.readFloat());
        }
        return this.addValue(name, val);
    }

    public final ByteArrayList readBytesVS(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        return this.readBytes(input, name, COUNT.getValue());
    }

    public final ShortArrayList readShortsVS(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        return this.readShorts(input, name, COUNT.getValue());
    }

    public final IntArrayList readIntsVS(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        return this.readInts(input, name, COUNT.getValue());
    }

    public final LongArrayList readLongsVS(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        return this.readLongs(input, name, COUNT.getValue());
    }

    public final FloatArrayList readFloatsVS(LittleEndianInput input, String name) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        return this.readFloats(input, name, COUNT.getValue());
    }

    public final <T extends Element> ObjectArrayList<T> readVSElemArray(LittleEndianInput input, String name, ElementReader<T> reader) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(reader);
        Objects.requireNonNull(name);
        VSVal COUNT = this.readVSVal(input, name + "_COUNT");
        assert (0 <= COUNT.getValue());
        ObjectArrayList<T> val = new ObjectArrayList<T>(COUNT.getValue());
        for (int i = 0; i < COUNT.getValue(); ++i) {
            T e = reader.read(input);
            val.add(e);
        }
        return this.addValue(name, val);
    }

    private <T> T addValue(String name, T val) {
        if (!SUPPORTED.stream().anyMatch(type -> type.isInstance(val))) {
            throw new IllegalStateException(String.format("Invalid type for %s: %s", name, val.getClass()));
        }
        this.DATA.put(name, val);
        return val;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        for (Object v : this.DATA.values()) {
            ObjectIterator<Byte> objectIterator;
            AbstractCollection ARR;
            if (Element.class.isInstance(v)) {
                output.writeESSElement((Element)v);
                continue;
            }
            if (v.getClass() == Byte.class) {
                output.writeByte(((Byte)v).byteValue());
                continue;
            }
            if (v.getClass() == Short.class) {
                output.writeShort(((Short)v).shortValue());
                continue;
            }
            if (v.getClass() == Integer.class) {
                output.writeInt((Integer)v);
                continue;
            }
            if (v.getClass() == Float.class) {
                output.writeFloat(((Float)v).floatValue());
                continue;
            }
            if (v.getClass() == String.class) {
                output.writeZString((String)v);
                continue;
            }
            if (v.getClass() == ByteArrayList.class) {
                ARR = (ByteArrayList)v;
                objectIterator = ((AbstractByteList)ARR).iterator();
                while (objectIterator.hasNext()) {
                    byte b = (Byte)objectIterator.next();
                    output.writeByte(b);
                }
                continue;
            }
            if (v.getClass() == ShortArrayList.class) {
                ARR = (ShortArrayList)v;
                objectIterator = ((AbstractShortList)ARR).iterator();
                while (objectIterator.hasNext()) {
                    short s = (Short)objectIterator.next();
                    output.writeShort(s);
                }
                continue;
            }
            if (v.getClass() == IntArrayList.class) {
                ARR = (IntArrayList)v;
                objectIterator = ((AbstractIntList)ARR).iterator();
                while (objectIterator.hasNext()) {
                    int i = (Integer)objectIterator.next();
                    output.writeInt(i);
                }
                continue;
            }
            if (v.getClass() == FloatArrayList.class) {
                ARR = (FloatArrayList)v;
                objectIterator = ((AbstractFloatList)ARR).iterator();
                while (objectIterator.hasNext()) {
                    float f = ((Float)objectIterator.next()).floatValue();
                    output.writeFloat(f);
                }
                continue;
            }
            if (v.getClass() == ObjectArrayList.class) {
                ARR = (ObjectArrayList)v;
                for (Element e : ARR) {
                    output.writeESSElement(e);
                }
                continue;
            }
            throw new IllegalStateException("Unknown element: " + v.getClass());
        }
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        for (Object v : this.DATA.values()) {
            if (Element.class.isInstance(v)) {
                sum += ((Element)v).calculateSize();
                continue;
            }
            if (v.getClass() == Byte.class) {
                ++sum;
                continue;
            }
            if (v.getClass() == Short.class) {
                sum += 2;
                continue;
            }
            if (v.getClass() == Integer.class) {
                sum += 4;
                continue;
            }
            if (v.getClass() == Float.class) {
                sum += 4;
                continue;
            }
            if (v.getClass() == String.class) {
                sum += 1 + ((String)v).getBytes().length;
                continue;
            }
            if (v.getClass() == ByteArrayList.class) {
                sum += 1 * ((ByteArrayList)v).size();
                continue;
            }
            if (v.getClass() == ShortArrayList.class) {
                sum += 2 * ((ShortArrayList)v).size();
                continue;
            }
            if (v.getClass() == IntArrayList.class) {
                sum += 4 * ((IntArrayList)v).size();
                continue;
            }
            if (v.getClass() == FloatArrayList.class) {
                sum += 4 * ((FloatArrayList)v).size();
                continue;
            }
            if (v.getClass() == ObjectArrayList.class) {
                ObjectArrayList ARR = (ObjectArrayList)v;
                sum += ARR.stream().mapToInt(w -> w.calculateSize()).sum();
                continue;
            }
            throw new IllegalStateException("Unknown element: " + v.getClass());
        }
        return sum;
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.DATA.values().stream().filter(v -> v instanceof Element).map(v -> (Element)v).forEach(v -> v.resolveRefs(ess, owner));
    }

    @Override
    public void addNames(Analysis analysis) {
        this.DATA.values().stream().filter(v -> v instanceof Element).map(v -> (Element)v).forEach(v -> v.addNames(analysis));
    }

    public String toString() {
        return this.DATA.keySet().stream().map(n -> String.format("%s=%s", n, this.getVal((String)n))).collect(Collectors.joining(", ", "[", "]"));
    }

    @FunctionalInterface
    public static interface ElementReader<T extends Element> {
        public T read(LittleEndianInput var1) throws IOException;
    }
}

