/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.DefaultGlobalDataBlock;
import restringer.ess.ESS;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.GlobalDataBlock;
import restringer.ess.papyrus.Papyrus;

public final class GlobalData
implements Element {
    private final int TYPE;
    private final GlobalDataBlock BLOCK;

    public GlobalData(LittleEndianInput input, ESSContext ctx) throws IOException {
        assert (null != input);
        this.TYPE = input.readInt();
        int size = input.readInt();
        byte[] DATA = new byte[size];
        int read = input.read(DATA);
        if (read != size) {
            throw new IOException(String.format("The block size should be %d, but only %d bytes could be read.", size, read));
        }
        if (this.TYPE == 1001) {
            Papyrus papyrus;
            try {
                papyrus = new Papyrus(DATA, ctx, false);
            }
            catch (IOException ex) {
                if (ctx.GAME.isSLE()) {
                    papyrus = new Papyrus(DATA, ctx, true);
                }
                throw ex;
            }
            this.BLOCK = papyrus;
        } else {
            this.BLOCK = new DefaultGlobalDataBlock(DATA);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeInt(this.TYPE);
        output.writeInt(this.BLOCK.calculateSize());
        this.BLOCK.write(output);
    }

    @Override
    public int calculateSize() {
        return 8 + this.BLOCK.calculateSize();
    }

    public int getType() {
        return this.TYPE;
    }

    public GlobalDataBlock getDataBlock() {
        return this.BLOCK;
    }

    public Papyrus getPapyrus() throws IOException {
        if (this.TYPE != 1001 || !(this.BLOCK instanceof Papyrus)) {
            throw new IllegalStateException("Not a papyrus block.");
        }
        return (Papyrus)this.BLOCK;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.BLOCK.addNames(analysis);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.BLOCK.resolveRefs(ess, owner);
    }

    public String toString() {
        return super.toString() + ": type " + Integer.toString(this.TYPE);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.BLOCK);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalData other = (GlobalData)obj;
        return Objects.equals(this.BLOCK, other.BLOCK);
    }
}

