/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ChangeForm;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.ScriptInstance;

public final class Plugin
implements Element,
AnalyzableElement,
Linkable,
Comparable<Plugin> {
    public static Plugin PROTOTYPE = new Plugin("Unofficial Skyrim Legendary Edition Patch");
    public final String NAME;
    public final int INDEX;
    private final Set<ScriptInstance> INSTANCES;
    private final Set<ChangeForm> FORMS;

    public Plugin(LittleEndianInput input, int index) throws IOException {
        Objects.requireNonNull(input);
        this.NAME = input.readWString();
        this.INDEX = index;
        this.INSTANCES = new ObjectRBTreeSet<ScriptInstance>((f1, f2) -> f1.getID().compareTo(f2.getID()));
        this.FORMS = new ObjectRBTreeSet<ChangeForm>((f1, f2) -> f1.getRefID().compareTo(f2.getRefID()));
    }

    private Plugin(String name) {
        this.NAME = name;
        this.INDEX = -1;
        this.INSTANCES = null;
        this.FORMS = null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeWString(this.NAME);
    }

    @Override
    public int calculateSize() {
        return 2 + this.NAME.getBytes(StandardCharsets.ISO_8859_1).length;
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"plugin://%s\">%s</a>", this.NAME, this.toString());
    }

    public String toString() {
        return String.format("%02x: %s", this.INDEX, this.NAME);
    }

    public Set<ScriptInstance> getInstances() {
        return this.INSTANCES;
    }

    public Set<ChangeForm> getForms() {
        return this.FORMS;
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html><h3>PLUGIN</h3>");
        BUILDER.append("<p>Name: ").append(this.NAME).append("</p>");
        BUILDER.append("<p>Index: ").append(this.INDEX).append("</p>");
        int numForms = this.FORMS.size();
        int numInstances = this.INSTANCES.size();
        if (null != analysis) {
            ArrayList PROVIDERS = new ArrayList();
            Predicate<String> espFilter = esp -> esp.equalsIgnoreCase(this.NAME);
            analysis.ESPS.forEach((mod, esps) -> esps.stream().filter(espFilter).forEach(esp -> PROVIDERS.add(mod)));
            if (!PROVIDERS.isEmpty()) {
                String probableProvider = (String)PROVIDERS.get(PROVIDERS.size() - 1);
                Predicate<SortedSet> modFilter = e -> e.contains(probableProvider);
                int numScripts = (int)analysis.SCRIPT_ORIGINS.values().stream().filter(modFilter).count();
                BUILDER.append(String.format("<p>%d scripts.</p>", numScripts));
                BUILDER.append(String.format("<p>The plugin probably came from mod \"%s\".</p>", probableProvider));
                if (PROVIDERS.size() > 1) {
                    BUILDER.append("<p>Full list of providers:</p><ul>");
                    PROVIDERS.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                    BUILDER.append("</ul>");
                }
            }
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        Predicate<String> filter = esp -> esp.equalsIgnoreCase(this.NAME);
        ArrayList PROVIDERS = new ArrayList();
        analysis.ESPS.forEach((m, esps) -> esps.stream().filter(filter).forEach(esp -> PROVIDERS.add(m)));
        return PROVIDERS.contains(mod);
    }

    @Override
    public int compareTo(Plugin o) {
        if (null == o) {
            return 1;
        }
        return Objects.compare(this.NAME, o.NAME, String::compareToIgnoreCase);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode(this.NAME.toLowerCase());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Plugin other = (Plugin)obj;
        return this.NAME.equalsIgnoreCase(other.NAME);
    }
}

