/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ChangeForm;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.Plugin;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.ScriptInstance;

public final class RefID
implements Element,
Linkable,
Comparable<RefID> {
    public static RefID NONE = new RefID(0);
    private final int DATA;
    private int formID;
    private Plugin plugin;
    private ChangeForm form;
    private String name;
    private static final String[] ZEROES = RefID.makeZeroes();

    public RefID(LittleEndianInput input) throws IOException {
        assert (null != input);
        int val = 0;
        val += input.readUnsignedByte();
        val <<= 8;
        val += input.readUnsignedByte();
        val <<= 8;
        this.DATA = val += input.readUnsignedByte();
        this.formID = 0;
        this.plugin = null;
        this.form = null;
        this.name = null;
    }

    public RefID(int newData) {
        this.DATA = newData;
        this.formID = 0;
        this.plugin = null;
        this.form = null;
        this.name = null;
    }

    public RefID(EID newData) {
        this.DATA = (int)newData.longValue();
        this.formID = 0;
        this.plugin = null;
        this.form = null;
        this.name = null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeByte(this.DATA >> 16);
        output.writeByte(this.DATA >> 8);
        output.writeByte(this.DATA);
    }

    @Override
    public int calculateSize() {
        return 3;
    }

    public Type getType() {
        int index = 3 & this.DATA >>> 22;
        switch (index) {
            case 0: {
                return Type.FORMIDX;
            }
            case 1: {
                return Type.DEFAULT;
            }
            case 2: {
                return Type.CREATED;
            }
        }
        return Type.UNKNOWN;
    }

    public int getValue() {
        return this.DATA & 0x3FFFFF;
    }

    public int getFormID() {
        return this.formID;
    }

    public ChangeForm getForm() {
        return this.form;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNonexistentCreated() {
        return this.getType() == Type.CREATED && null == this.form;
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        Objects.requireNonNull(ess);
        this.form = ess.getChangeForms().get(this);
        if (null != this.form && null != owner && owner instanceof ScriptInstance) {
            this.form.addRefHolder((ScriptInstance)owner);
        }
        switch (this.getType()) {
            case FORMIDX: {
                int index = this.getValue() - 1;
                if (index < 0 || index >= ess.getFormIDs().length) break;
                this.formID = ess.getFormIDs()[index];
                int pluginIndex = this.formID >>> 24;
                this.plugin = ess.getPluginInfo().getPlugins().get(pluginIndex);
                break;
            }
            case DEFAULT: {
                this.plugin = ess.getPluginInfo().getPlugins().get(0);
                break;
            }
            case CREATED: {
                break;
            }
        }
        if (null != this.plugin) {
            if (owner instanceof ChangeForm) {
                this.plugin.getForms().add((ChangeForm)owner);
            } else if (owner instanceof ScriptInstance) {
                this.plugin.getInstances().add((ScriptInstance)owner);
            }
        }
    }

    @Override
    public void addNames(Analysis analysis) {
        switch (this.getType()) {
            case FORMIDX: {
                int id = this.getFormID();
                this.name = analysis.getName(id);
                break;
            }
            case DEFAULT: {
                int id = this.getValue();
                this.name = analysis.getName(id);
                break;
            }
        }
    }

    public String toString() {
        String namePart;
        String string = namePart = this.name != null ? " " + this.name : "";
        if (this.DATA == 0) {
            return "00000000";
        }
        if (this.getType() == Type.FORMIDX && this.name != null) {
            return "FormIDX-" + RefID.zeroPad8(this.getFormID()) + " (" + this.name + ")";
        }
        if (this.getType() == Type.FORMIDX) {
            return "FormIDX-" + RefID.zeroPad8(this.getFormID());
        }
        if (this.name != null) {
            return (Object)((Object)this.getType()) + "-" + RefID.zeroPad6(this.getValue()) + " (" + this.name + ")";
        }
        return (Object)((Object)this.getType()) + "-" + RefID.zeroPad6(this.getValue());
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"refid://%08x\">%s</a>", this.DATA, this.toString());
    }

    @Override
    public int compareTo(RefID other) {
        Objects.requireNonNull(other);
        return Integer.compareUnsigned(this.DATA, other.DATA);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.DATA;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefID other = (RefID)obj;
        return this.DATA == other.DATA;
    }

    private static String zeroPad8(int val) {
        String hex = Integer.toHexString(val);
        int length = hex.length();
        assert (length <= ZEROES.length);
        return ZEROES[8 - length] + hex;
    }

    private static String zeroPad6(int val) {
        String hex = Long.toHexString(val);
        int length = hex.length();
        assert (length < ZEROES.length);
        return ZEROES[6 - length] + hex;
    }

    private static String[] makeZeroes() {
        String[] zeroes = new String[16];
        zeroes[0] = "";
        for (int i = 1; i < zeroes.length; ++i) {
            zeroes[i] = zeroes[i - 1] + "0";
        }
        return zeroes;
    }

    public static enum Type {
        FORMIDX,
        DEFAULT,
        CREATED,
        UNKNOWN;

    }
}

