/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.ActiveScriptMap;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.InstanceMap;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.ReferenceMap;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Unknown4;
import restringer.ess.papyrus.Variable;

public final class ActiveScriptData
implements PapyrusElement,
HasID {
    private final EID ID;
    private final byte MAJORVERSION;
    private final byte MINORVERSION;
    private final Variable UNKNOWN;
    private final byte FLAG;
    private final byte UNKNOWNBYTE;
    private final int UNKNOWN2;
    private final byte UNKNOWN3;
    private final Unknown4 UNKNOWN4;
    private final EID ATTACHED;
    private final List<StackFrame> STACKFRAMES;
    private final byte UNKNOWN5;

    public ActiveScriptData(LittleEndianInput input, ScriptMap scripts, ActiveScriptMap actives, InstanceMap instances, ReferenceMap refs, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        this.ID = EID.read4byte(input);
        if (!actives.containsKey(this.ID)) {
            throw new IOException("Invalid ID on ActiveScriptData.");
        }
        this.MAJORVERSION = input.readByte();
        this.MINORVERSION = input.readByte();
        assert (this.MINORVERSION >= 1 && this.MINORVERSION <= 2) : "Wrong minor version = " + this.MINORVERSION;
        this.UNKNOWN = Variable.read(input, ctx);
        this.FLAG = input.readByte();
        this.UNKNOWNBYTE = input.readByte();
        this.UNKNOWN2 = (this.FLAG & 1) == 1 ? input.readInt() : 0;
        this.UNKNOWN3 = input.readByte();
        switch (this.UNKNOWN3) {
            case 1: 
            case 2: 
            case 3: {
                this.UNKNOWN4 = new Unknown4(input, this.UNKNOWN3, ctx);
                break;
            }
            default: {
                this.UNKNOWN4 = null;
            }
        }
        this.ATTACHED = ctx.GAME.isFO4() && (null == this.UNKNOWN4 || !this.UNKNOWN4.STRING.equals("TerminalRunResults")) ? EID.read8byte(input) : null;
        int stackFrameCount = input.readInt();
        this.STACKFRAMES = new ArrayList<StackFrame>(stackFrameCount);
        for (int i = 0; i < stackFrameCount; ++i) {
            try {
                StackFrame frame = new StackFrame(input, scripts, ctx);
                this.STACKFRAMES.add(frame);
                continue;
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with StackFrame Data. Processed %d/%d.", i, stackFrameCount), ex);
            }
        }
        this.UNKNOWN5 = stackFrameCount != 0 ? input.readByte() : (byte)0;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeESSElement(this.ID);
        output.writeByte(this.MAJORVERSION);
        output.writeByte(this.MINORVERSION);
        output.writeESSElement(this.UNKNOWN);
        output.writeByte(this.FLAG);
        output.writeByte(this.UNKNOWNBYTE);
        if ((this.FLAG & 1) == 1) {
            output.writeInt(this.UNKNOWN2);
        }
        output.writeByte(this.UNKNOWN3);
        if (null != this.UNKNOWN4) {
            output.writeESSElement(this.UNKNOWN4);
        }
        if (null != this.ATTACHED) {
            output.writeESSElement(this.ATTACHED);
        }
        output.writeInt(this.STACKFRAMES.size());
        for (StackFrame frame : this.STACKFRAMES) {
            output.writeESSElement(frame);
        }
        if (!this.STACKFRAMES.isEmpty()) {
            output.writeByte(this.UNKNOWN5);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += this.ID.calculateSize();
        sum += this.UNKNOWN.calculateSize();
        sum += 2;
        sum += (this.FLAG & 1) == 1 ? 4 : 0;
        sum += 5;
        sum += null == this.ATTACHED ? 0 : this.ATTACHED.calculateSize();
        sum += null == this.UNKNOWN4 ? 0 : this.UNKNOWN4.calculateSize();
        sum += this.STACKFRAMES.isEmpty() ? 0 : 1;
        return sum += this.STACKFRAMES.stream().mapToInt(frame -> frame.calculateSize()).sum();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public byte getMajorVersion() {
        return this.MAJORVERSION;
    }

    public int getMinorVersion() {
        return this.MINORVERSION;
    }

    public int getFlag() {
        return this.FLAG;
    }

    public Variable getUnknownVar() {
        return this.UNKNOWN;
    }

    public Unknown4 getUnknown4() {
        return this.UNKNOWN4;
    }

    public byte getUnknownByte() {
        return this.UNKNOWNBYTE;
    }

    public int getUnknown2() {
        return this.UNKNOWN2;
    }

    public byte getUnknown3() {
        return this.UNKNOWN3;
    }

    public byte getUnknown5() {
        return this.UNKNOWN5;
    }

    public EID getAttached() {
        return this.ATTACHED;
    }

    public List<StackFrame> getStackFrames() {
        return this.STACKFRAMES;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.UNKNOWN.addNames(analysis);
        if (null != this.UNKNOWN4) {
            this.UNKNOWN4.addNames(analysis);
        }
        this.STACKFRAMES.forEach(frame -> frame.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.UNKNOWN.resolveRefs(ess, owner);
        if (null != this.UNKNOWN4) {
            this.UNKNOWN4.resolveRefs(ess, owner);
        }
        this.STACKFRAMES.forEach(frame -> frame.resolveRefs(ess, owner));
    }
}

