/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.Definition;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.TString;

public abstract class GameElement
implements AnalyzableElement,
Linkable,
PapyrusElement,
HasID {
    private final EID ID;
    private final TString DEFINITION_NAME;
    private final Definition DEFINITION;

    public GameElement(LittleEndianInput input, Map<IString, ? extends Definition> defs, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(defs);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
        this.DEFINITION_NAME = ctx.STRINGS.read(input);
        this.DEFINITION = defs.getOrDefault(this.DEFINITION_NAME, null);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        output.writeESSElement(this.DEFINITION_NAME);
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        sum += this.ID.calculateSize();
        return sum += this.DEFINITION_NAME.calculateSize();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public TString getDefinitionName() {
        return this.DEFINITION_NAME;
    }

    public Definition getDefinition() {
        return this.DEFINITION;
    }

    public boolean isUndefined() {
        if (null == this.DEFINITION) {
            return !Script.IMPLICITSCRIPTS.contains(this.DEFINITION_NAME);
        }
        return this.DEFINITION.isUndefined();
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.DEFINITION_NAME.addRefHolder(this);
        if (null != this.DEFINITION) {
            this.DEFINITION.incrementInstanceCount();
        }
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        SortedSet<String> OWNERS = analysis.SCRIPT_ORIGINS.get(this.DEFINITION_NAME);
        if (null == OWNERS) {
            return false;
        }
        return OWNERS.contains(mod);
    }
}

