/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.ess.ESS;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.GlobalDataBlock;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ActiveScriptData;
import restringer.ess.papyrus.ActiveScriptMap;
import restringer.ess.papyrus.ArrayData;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.ArrayMap;
import restringer.ess.papyrus.Definition;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.FunctionMessage;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.InstanceMap;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.QueuedUnbind;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.ReferenceData;
import restringer.ess.papyrus.ReferenceMap;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptData;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.StringTable;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.StructData;
import restringer.ess.papyrus.StructDef;
import restringer.ess.papyrus.StructDefMap;
import restringer.ess.papyrus.StructMap;
import restringer.ess.papyrus.SuspendedStack;

public final class Papyrus
implements PapyrusElement,
GlobalDataBlock {
    private final short HEADER;
    private final int PAPYRUS_RUNTIME;
    private final short SAVE_FILE_VERSION;
    private final int UNK1;
    private final int UNK2;
    private final StringTable STRINGS;
    private final ScriptMap SCRIPTS;
    private final StructDefMap STRUCTDEFS;
    private final InstanceMap INSTANCES;
    private final ReferenceMap REFERENCES;
    private final StructMap STRUCTS;
    private final ArrayMap ARRAYS;
    private final ActiveScriptMap ACTIVESCRIPTS;
    private final List<FunctionMessage> FUNCTIONMESSAGES;
    private final List<SuspendedStack> SUSPENDEDSTACKS1;
    private final List<SuspendedStack> SUSPENDEDSTACKS2;
    private final List<EID> UNKS;
    private final List<QueuedUnbind> UNBINDS;
    private final byte[] OTHERDATA;
    private final byte[] ORIGINAL_DATA;

    public Papyrus(byte[] buffer, ESSContext essCTX, boolean applySTBCorrection) throws IOException {
        Objects.requireNonNull(buffer);
        this.ORIGINAL_DATA = buffer;
        if (buffer.length < 20) {
            throw new IOException("The Papyrus block is missing. This can happen if Skyrim is running too many mods or too many scripts.\nUnfortunately, there is literally nothing I can do to help you with this.");
        }
        try (LittleEndianInputStream input = LittleEndianInputStream.wrap(buffer);){
            EID id;
            HasID data;
            int referenceCount;
            int instanceCount;
            PapyrusContext CTX;
            int i;
            int sum;
            block98: {
                int scriptCount;
                sum = 0;
                i = 0;
                this.HEADER = input.readShort();
                sum += 2;
                this.STRINGS = new StringTable(input, essCTX.GAME, applySTBCorrection);
                assert ((sum += this.STRINGS.calculateSize()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                CTX = new PapyrusContext(essCTX, this.STRINGS);
                if (CTX.GAME.isFO4()) {
                    scriptCount = input.readInt();
                    this.SCRIPTS = new ScriptMap(scriptCount);
                    int structDefCount = input.readInt();
                    this.STRUCTDEFS = new StructDefMap(structDefCount);
                    try {
                        for (i = 0; i < scriptCount; ++i) {
                            Script script = new Script(input, CTX);
                            this.SCRIPTS.put(script.getName(), script);
                        }
                        sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
                    }
                    catch (IOException ex) {
                        throw new IOException(String.format("Problem with Scripts. Processed %d/%d.", i, scriptCount), ex);
                    }
                    try {
                        for (i = 0; i < structDefCount; ++i) {
                            StructDef struct = new StructDef(input, CTX);
                            this.STRUCTDEFS.put(struct.getName(), struct);
                        }
                    }
                    catch (IOException ex) {
                        throw new IOException(String.format("Problem with StructDefs. Processed %d/%d.", i, structDefCount), ex);
                    }
                    assert ((sum += 4 + this.STRUCTDEFS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                } else {
                    scriptCount = input.readInt();
                    this.SCRIPTS = new ScriptMap(scriptCount);
                    this.STRUCTDEFS = null;
                    try {
                        for (i = 0; i < scriptCount; ++i) {
                            Script script = new Script(input, CTX);
                            this.SCRIPTS.put(script.getName(), script);
                        }
                        assert ((sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                    }
                    catch (IOException | AssertionError ex) {
                        throw new IOException(String.format("Problem with Scripts. Processed %d/%d.", i, scriptCount), (Throwable)ex);
                    }
                }
                instanceCount = input.readInt();
                this.INSTANCES = new InstanceMap(instanceCount);
                try {
                    for (i = 0; i < instanceCount; ++i) {
                        ScriptInstance instance = new ScriptInstance((LittleEndianInput)input, this.SCRIPTS, CTX);
                        this.INSTANCES.put(instance.getID(), instance);
                    }
                    assert ((sum += 4 + this.INSTANCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                }
                catch (IOException | AssertionError ex) {
                    throw new IOException(String.format("Problem with Script Instances. Processed %d/%d.", i, instanceCount), (Throwable)ex);
                }
                referenceCount = input.readInt();
                this.REFERENCES = new ReferenceMap(referenceCount);
                try {
                    for (i = 0; i < referenceCount; ++i) {
                        Reference reference = new Reference((LittleEndianInput)input, this.SCRIPTS, CTX);
                        this.REFERENCES.put(reference.getID(), reference);
                    }
                    assert ((sum += 4 + this.REFERENCES.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                }
                catch (IOException ex) {
                    throw new IOException(String.format("Problem with References. Processed %d/%d.", i, referenceCount), ex);
                }
                if (CTX.GAME.isFO4()) {
                    int structCount = input.readInt();
                    this.STRUCTS = new StructMap(structCount);
                    try {
                        for (i = 0; i < structCount; ++i) {
                            Struct struct = new Struct((LittleEndianInput)input, this.STRUCTDEFS, CTX);
                            this.STRUCTS.put(struct.getID(), struct);
                        }
                        assert ((sum += 4 + this.STRUCTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                        break block98;
                    }
                    catch (IOException ex) {
                        throw new IOException(String.format("Problem with Struct Instances. Processed %d/%d.", i, structCount), ex);
                    }
                }
                this.STRUCTS = null;
            }
            int arrayCount = input.readInt();
            this.ARRAYS = new ArrayMap(arrayCount);
            try {
                for (i = 0; i < arrayCount; ++i) {
                    ArrayInfo info = new ArrayInfo(input, CTX);
                    this.ARRAYS.put(info.getID(), info);
                }
                assert ((sum += 4 + this.ARRAYS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with Arrays. Processed %d/%d.", i, arrayCount), ex);
            }
            this.PAPYRUS_RUNTIME = input.readInt();
            assert ((sum += 4) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            int activeScriptCount = input.readInt();
            this.ACTIVESCRIPTS = new ActiveScriptMap(activeScriptCount);
            try {
                for (i = 0; i < activeScriptCount; ++i) {
                    ActiveScript active = new ActiveScript(input, CTX);
                    this.ACTIVESCRIPTS.put(active.getID(), active);
                }
                assert ((sum += 4 + this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with ActiveScripts. Processed %d/%d.", i, activeScriptCount), ex);
            }
            try {
                for (i = 0; i < instanceCount; ++i) {
                    data = new ScriptData(input, CTX);
                    ScriptInstance instance = (ScriptInstance)this.INSTANCES.get(((ScriptData)data).getID());
                    instance.setData((ScriptData)data);
                }
                assert ((sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Problem with Script Instance Data. Processed %d/%d.", i, instanceCount), ex);
            }
            try {
                for (i = 0; i < referenceCount; ++i) {
                    data = new ReferenceData(input, CTX);
                    Reference ref = (Reference)this.REFERENCES.get(((ReferenceData)data).getID());
                    ref.setData((ReferenceData)data);
                }
                assert ((sum += this.REFERENCES.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Problem with Reference Data. Processed %d/%d.", i, referenceCount), ex);
            }
            if (CTX.GAME.isFO4()) {
                int structCount = this.STRUCTS.size();
                try {
                    for (i = 0; i < structCount; ++i) {
                        StructData data2 = new StructData(input, this.STRUCTS, CTX);
                        Struct struct = (Struct)this.STRUCTS.get(data2.getID());
                        struct.setData(data2);
                    }
                    assert ((sum += this.STRUCTS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
                }
                catch (Error | Exception ex) {
                    throw new IOException(String.format("Problem with Struct Data. Processed %d/%d.", i, structCount), ex);
                }
            }
            try {
                for (i = 0; i < arrayCount; ++i) {
                    ArrayData data3 = new ArrayData(input, this.ARRAYS, CTX);
                    ArrayInfo array = (ArrayInfo)this.ARRAYS.get(data3.getID());
                    array.setData(data3);
                }
                assert ((sum += this.ARRAYS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Problem with Array Data. Processed %d/%d.", i, arrayCount), ex);
            }
            try {
                for (i = 0; i < activeScriptCount; ++i) {
                    if (i == 67030) {
                        boolean ex = false;
                    }
                    ActiveScriptData data4 = new ActiveScriptData(input, this.SCRIPTS, this.ACTIVESCRIPTS, this.INSTANCES, this.REFERENCES, CTX);
                    ActiveScript script = (ActiveScript)this.ACTIVESCRIPTS.get(data4.getID());
                    script.setData(data4);
                }
                assert ((sum += this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException | Error ex) {
                throw new IOException(String.format("Problem with ActiveScript Data. Processed %d/%d.", i, activeScriptCount), ex);
            }
            int functionMessageCount = input.readInt();
            this.FUNCTIONMESSAGES = new ArrayList<FunctionMessage>(functionMessageCount);
            try {
                for (i = 0; i < functionMessageCount; ++i) {
                    FunctionMessage message = new FunctionMessage(input, this.SCRIPTS, CTX);
                    this.FUNCTIONMESSAGES.add(message);
                }
                assert ((sum += 4 + this.FUNCTIONMESSAGES.stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with Function Messages. Processed %d/%d.", i, functionMessageCount), ex);
            }
            int stack1Count = input.readInt();
            this.SUSPENDEDSTACKS1 = new ArrayList<SuspendedStack>(stack1Count);
            try {
                for (i = 0; i < stack1Count; ++i) {
                    SuspendedStack stack = new SuspendedStack(input, this.SCRIPTS, CTX);
                    this.SUSPENDEDSTACKS1.add(stack);
                }
                assert ((sum += 4 + this.SUSPENDEDSTACKS1.stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with Suspended Stacks (list 1). Processed %d/%d.", i, stack1Count), ex);
            }
            int stack2Count = input.readInt();
            this.SUSPENDEDSTACKS2 = new ArrayList<SuspendedStack>(stack2Count);
            try {
                for (i = 0; i < stack2Count; ++i) {
                    SuspendedStack stack = new SuspendedStack(input, this.SCRIPTS, CTX);
                    this.SUSPENDEDSTACKS2.add(stack);
                }
                assert ((sum += 4 + this.SUSPENDEDSTACKS2.stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            }
            catch (IOException ex) {
                throw new IOException(String.format("Problem with Suspended Stacks (list 2). Processed %d/%d.", i, stack2Count), ex);
            }
            this.UNK1 = input.readInt();
            this.UNK2 = this.UNK1 == 0 ? 0 : input.readInt();
            assert ((sum += this.UNK1 == 0 ? 4 : 8) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            int unknownCount = input.readInt();
            this.UNKS = new ArrayList<EID>(unknownCount);
            if (CTX.GAME.isID64()) {
                for (i = 0; i < unknownCount; ++i) {
                    id = EID.read8byte(input);
                    this.UNKS.add(id);
                }
            } else {
                for (i = 0; i < unknownCount; ++i) {
                    id = EID.read4byte(input);
                    this.UNKS.add(id);
                }
            }
            assert ((sum += 4 + this.UNKS.parallelStream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            int queuedUnbindCount = input.readInt();
            this.UNBINDS = new ArrayList<QueuedUnbind>(queuedUnbindCount);
            for (i = 0; i < queuedUnbindCount; ++i) {
                QueuedUnbind unbind = new QueuedUnbind(input, this.INSTANCES, CTX);
                this.UNBINDS.add(unbind);
            }
            assert ((sum += 4 + this.UNBINDS.stream().mapToInt(v -> v.calculateSize()).sum()) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            this.SAVE_FILE_VERSION = input.readShort();
            assert ((sum += 2) == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            int remaining = input.available();
            this.OTHERDATA = new byte[remaining];
            int read = input.read(this.OTHERDATA);
            sum += this.OTHERDATA.length;
            assert (read == remaining);
            assert (sum == input.getPosition()) : String.format("sum=%d, pos=%d", sum, input.getPosition());
            assert (sum == this.calculateSize()) : String.format("Summed = %d, calculated = %d", sum, this.calculateSize());
            assert (sum == buffer.length) : String.format("Summed = %d, buffer length = %d", sum, buffer.length);
        }
        catch (OutOfMemoryError ex) {
            throw new IOException("Out of memory while reading the Papyrus section.", ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output = new LittleEndianDataOutput(output);
        int sum = 0;
        assert (null != output);
        output.writeShort(this.HEADER);
        assert ((sum += 2) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        this.STRINGS.write(output);
        assert ((sum += this.STRINGS.calculateSize()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        if (this.STRUCTDEFS != null) {
            output.writeInt(this.SCRIPTS.size());
            output.writeInt(this.STRUCTDEFS.size());
            for (PapyrusElement script : this.SCRIPTS.values()) {
                ((Script)script).write(output);
            }
            for (PapyrusElement struct : this.STRUCTDEFS.values()) {
                ((StructDef)struct).write(output);
            }
            sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
            assert ((sum += 4 + this.STRUCTDEFS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        } else {
            output.writeInt(this.SCRIPTS.size());
            for (PapyrusElement script : this.SCRIPTS.values()) {
                ((Script)script).write(output);
            }
            assert ((sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        }
        output.writeInt(this.INSTANCES.size());
        for (ScriptInstance instance : this.INSTANCES.values()) {
            instance.write(output);
        }
        assert ((sum += 4 + this.INSTANCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.REFERENCES.size());
        for (Reference ref : this.REFERENCES.values()) {
            ref.write(output);
        }
        assert ((sum += 4 + this.REFERENCES.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        if (null != this.STRUCTS) {
            output.writeInt(this.STRUCTS.size());
            for (PapyrusElement struct : this.STRUCTS.values()) {
                ((Struct)struct).write(output);
            }
            assert ((sum += 4 + this.STRUCTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        }
        output.writeInt(this.ARRAYS.size());
        for (ArrayInfo info : this.ARRAYS.values()) {
            info.write(output);
        }
        assert ((sum += 4 + this.ARRAYS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.PAPYRUS_RUNTIME);
        assert ((sum += 4) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.ACTIVESCRIPTS.size());
        for (PapyrusElement script : this.ACTIVESCRIPTS.values()) {
            ((ActiveScript)script).write(output);
        }
        assert ((sum += 4 + this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        for (ScriptInstance instance : this.INSTANCES.values()) {
            ScriptData data = instance.getData();
            data.write(output);
        }
        assert ((sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        for (Reference ref : this.REFERENCES.values()) {
            ref.getData().write(output);
        }
        assert ((sum += this.REFERENCES.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        if (null != this.STRUCTS) {
            for (PapyrusElement struct : this.STRUCTS.values()) {
                ((Struct)struct).getData().write(output);
            }
            assert ((sum += this.STRUCTS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        }
        for (ArrayInfo info : this.ARRAYS.values()) {
            info.getData().write(output);
        }
        assert ((sum += this.ARRAYS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        for (PapyrusElement script : this.ACTIVESCRIPTS.values()) {
            ((ActiveScript)script).getData().write(output);
        }
        assert ((sum += this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.FUNCTIONMESSAGES.size());
        for (FunctionMessage message : this.FUNCTIONMESSAGES) {
            message.write(output);
        }
        assert ((sum += 4 + this.FUNCTIONMESSAGES.stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.SUSPENDEDSTACKS1.size());
        for (SuspendedStack stack : this.SUSPENDEDSTACKS1) {
            stack.write(output);
        }
        assert ((sum += 4 + this.SUSPENDEDSTACKS1.stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.SUSPENDEDSTACKS2.size());
        for (SuspendedStack stack : this.SUSPENDEDSTACKS2) {
            stack.write(output);
        }
        assert ((sum += 4 + this.SUSPENDEDSTACKS2.stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.UNK1);
        if (this.UNK1 != 0) {
            output.writeInt(this.UNK2);
        }
        assert ((sum += this.UNK1 == 0 ? 4 : 8) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.UNKS.size());
        for (EID id : this.UNKS) {
            output.writeESSElement(id);
        }
        assert ((sum += 4 + this.UNKS.parallelStream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeInt(this.UNBINDS.size());
        for (QueuedUnbind unbind : this.UNBINDS) {
            unbind.write(output);
        }
        assert ((sum += 4 + this.UNBINDS.stream().mapToInt(v -> v.calculateSize()).sum()) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.writeShort(this.SAVE_FILE_VERSION);
        assert ((sum += 2) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        output.write(this.OTHERDATA);
        assert ((sum += this.OTHERDATA.length) == output.getPosition()) : String.format("sum=%d, pos=%d", sum, output.getPosition());
        assert (sum == this.calculateSize()) : String.format("Summed = %d, calculated = %d", sum, this.calculateSize());
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += this.STRINGS.calculateSize();
        sum += 4;
        sum += this.SCRIPTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        if (null != this.STRUCTDEFS) {
            sum += 4;
            sum += this.STRUCTDEFS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        }
        sum += 4;
        sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.REFERENCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        if (null != this.STRUCTS) {
            sum += 4;
            sum += this.STRUCTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
            sum += this.STRUCTS.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        }
        sum += 4;
        sum += this.ARRAYS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += 4;
        sum += this.ACTIVESCRIPTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.REFERENCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.ARRAYS.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.ACTIVESCRIPTS.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += 4;
        sum += this.FUNCTIONMESSAGES.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.SUSPENDEDSTACKS1.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.SUSPENDEDSTACKS2.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.UNK1 == 0 ? 4 : 8;
        sum += 4 + this.UNKS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.UNBINDS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 2;
        return sum += this.OTHERDATA.length;
    }

    public StringTable getStringTable() {
        return this.STRINGS;
    }

    public ScriptMap getScripts() {
        return this.SCRIPTS;
    }

    public StructDefMap getStructDefs() {
        if (null == this.STRUCTDEFS) {
            return new StructDefMap(0);
        }
        return this.STRUCTDEFS;
    }

    public InstanceMap getInstances() {
        return this.INSTANCES;
    }

    public ReferenceMap getReferences() {
        return this.REFERENCES;
    }

    public StructMap getStructs() {
        if (null == this.STRUCTS) {
            return new StructMap(0);
        }
        return this.STRUCTS;
    }

    public ArrayMap getArrays() {
        return this.ARRAYS;
    }

    public ActiveScriptMap getActiveScripts() {
        return this.ACTIVESCRIPTS;
    }

    public List<FunctionMessage> getFunctionMessages() {
        return this.FUNCTIONMESSAGES;
    }

    public List<SuspendedStack> getSuspendedStacks1() {
        return this.SUSPENDEDSTACKS1;
    }

    public List<SuspendedStack> getSuspendedStacks2() {
        return this.SUSPENDEDSTACKS2;
    }

    public List<QueuedUnbind> getUnbinds() {
        return this.UNBINDS;
    }

    public int countUnattachedInstances() {
        return (int)this.INSTANCES.values().stream().filter(v -> v.isUnattached()).count();
    }

    public int[] countUndefinedElements() {
        int count = 0;
        int threads = 0;
        count = (int)((long)count + this.getScripts().values().stream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.getInstances().values().parallelStream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.getReferences().values().stream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.getStructDefs().values().stream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.getStructs().values().stream().filter(v -> v.isUndefined()).count());
        threads = (int)((long)threads + this.getActiveScripts().values().stream().filter(v -> v.isUndefined() && !v.isTerminated()).count());
        return new int[]{count, threads};
    }

    public int cleanUnattachedInstances() {
        Set UNATTACHED = this.getInstances().values().stream().filter(v -> v.isUnattached()).collect(Collectors.toSet());
        return this.removeElements(UNATTACHED);
    }

    public int[] cleanUndefinedElements() {
        int[] COUNTS = this.countUndefinedElements();
        int count = 0;
        count += this.removeElements(this.getScripts().values().stream().filter(v -> v.isUndefined()).collect(Collectors.toSet()));
        count += this.removeElements(this.getStructDefs().values().stream().filter(v -> v.isUndefined()).collect(Collectors.toSet()));
        count += this.removeElements(this.getInstances().values().stream().filter(v -> v.isUndefined()).collect(Collectors.toSet()));
        count += this.removeElements(this.getReferences().values().stream().filter(v -> v.isUndefined()).collect(Collectors.toSet()));
        this.getActiveScripts().values().stream().filter(v -> v.isUndefined() && !v.isTerminated()).forEach(v -> v.zero());
        assert (COUNTS[0] <= (count += this.removeElements(this.getStructs().values().stream().filter(v -> v.isUndefined()).collect(Collectors.toSet()))));
        COUNTS[0] = count;
        return COUNTS;
    }

    public int removeElements(Set<? extends PapyrusElement> elements) {
        assert (null != elements);
        assert (!elements.contains(null));
        LinkedList<? extends PapyrusElement> ELEMENTS = new LinkedList<PapyrusElement>(elements);
        int count = 0;
        while (!ELEMENTS.isEmpty()) {
            Definition DEF;
            PapyrusElement ELEMENT = ELEMENTS.pop();
            if (ELEMENT instanceof Script) {
                DEF = (Script)ELEMENT;
                if (!this.getScripts().containsKey(((Script)DEF).getName())) continue;
                ++count;
                this.getScripts().remove(((Script)DEF).getName());
                ELEMENTS.addAll(this.getInstances().values().parallelStream().filter(arg_0 -> Papyrus.lambda$removeElements$68((Script)DEF, arg_0)).collect(Collectors.toSet()));
                continue;
            }
            if (ELEMENT instanceof StructDef) {
                DEF = (StructDef)ELEMENT;
                if (!this.getStructDefs().containsKey(((StructDef)DEF).getName())) continue;
                ++count;
                this.getStructDefs().remove(((StructDef)DEF).getName());
                ELEMENTS.addAll(this.getStructs().values().parallelStream().filter(arg_0 -> Papyrus.lambda$removeElements$69((StructDef)DEF, arg_0)).collect(Collectors.toSet()));
                continue;
            }
            if (ELEMENT instanceof ScriptInstance) {
                ScriptInstance INSTANCE = (ScriptInstance)ELEMENT;
                if (!this.getInstances().containsKey(INSTANCE.getID())) continue;
                this.getInstances().remove(INSTANCE.getID());
                ++count;
                continue;
            }
            if (ELEMENT instanceof Struct) {
                Struct STRUCT = (Struct)ELEMENT;
                if (!this.getStructs().containsKey(STRUCT.getID())) continue;
                this.getStructs().remove(STRUCT.getID());
                ++count;
                continue;
            }
            if (ELEMENT instanceof Reference) {
                Reference REF = (Reference)ELEMENT;
                if (!this.getReferences().containsKey(REF.getID())) continue;
                this.getReferences().remove(REF.getID());
                ++count;
                continue;
            }
            if (ELEMENT instanceof ArrayInfo) {
                ArrayInfo ARRAY = (ArrayInfo)ELEMENT;
                if (!this.getArrays().containsKey(ARRAY.getID())) continue;
                this.getArrays().remove(ARRAY.getID());
                ++count;
                continue;
            }
            if (ELEMENT instanceof ActiveScript) {
                ActiveScript ACTIVE = (ActiveScript)ELEMENT;
                if (!this.getActiveScripts().containsKey(ACTIVE.getID())) continue;
                this.getActiveScripts().remove(ACTIVE.getID());
                ++count;
                continue;
            }
            if (ELEMENT instanceof SuspendedStack) {
                SuspendedStack STACK = (SuspendedStack)ELEMENT;
                if (this.getSuspendedStacks1().contains(STACK)) {
                    this.getSuspendedStacks1().remove(STACK);
                    ++count;
                    continue;
                }
                if (!this.getSuspendedStacks2().contains(STACK)) continue;
                this.getSuspendedStacks2().remove(STACK);
                ++count;
                continue;
            }
            System.err.println("Papyrus.removeElements: can't delete this element: " + ELEMENT);
        }
        return count;
    }

    public String toString() {
        return "Papyrus-" + super.toString();
    }

    @Override
    public void addNames(Analysis analysis) {
        this.getInstances().values().forEach(v -> v.addNames(analysis));
        this.getStructs().values().forEach(v -> v.addNames(analysis));
        this.getReferences().values().forEach(v -> v.addNames(analysis));
        this.getActiveScripts().values().forEach(v -> v.addNames(analysis));
        this.getArrays().values().forEach(v -> v.addNames(analysis));
        this.getSuspendedStacks1().forEach(v -> v.addNames(analysis));
        this.getSuspendedStacks2().forEach(v -> v.addNames(analysis));
        this.getFunctionMessages().forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.getArrays().values().forEach(array -> array.resolveRefs(ess, null));
        this.getScripts().values().forEach(script -> script.resolveRefs(ess, null));
        this.getInstances().values().forEach(instance -> instance.resolveRefs(ess, null));
        this.getStructDefs().values().forEach(def -> def.resolveRefs(ess, null));
        this.getStructs().values().forEach(struct -> struct.resolveRefs(ess, null));
        this.getReferences().values().forEach(ref -> ref.resolveRefs(ess, null));
        this.getActiveScripts().values().forEach(script -> script.resolveRefs(ess, null));
        this.getSuspendedStacks1().forEach(stack -> stack.resolveRefs(ess, null));
        this.getSuspendedStacks2().forEach(stack -> stack.resolveRefs(ess, null));
        this.getFunctionMessages().forEach(msg -> msg.resolveRefs(ess, null));
    }

    public PapyrusElement broadSpectrumMatch(EID id) {
        if (this.getInstances().containsKey(id)) {
            return (PapyrusElement)this.getInstances().get(id);
        }
        if (this.getReferences().containsKey(id)) {
            return (PapyrusElement)this.getReferences().get(id);
        }
        if (this.getArrays().containsKey(id)) {
            return (PapyrusElement)this.getArrays().get(id);
        }
        if (this.getActiveScripts().containsKey(id)) {
            return (PapyrusElement)this.getActiveScripts().get(id);
        }
        if (this.getStructs().containsKey(id)) {
            return (PapyrusElement)this.getStructs().get(id);
        }
        Optional<FunctionMessage> msg = this.getFunctionMessages().stream().filter(v -> v.getID().equals(id)).findAny();
        if (msg.isPresent()) {
            return msg.get();
        }
        Optional<SuspendedStack> susp1 = this.getSuspendedStacks1().stream().filter(v -> v.getID().equals(id)).findAny();
        if (susp1.isPresent()) {
            return susp1.get();
        }
        Optional<SuspendedStack> susp2 = this.getSuspendedStacks2().stream().filter(v -> v.getID().equals(id)).findAny();
        if (susp2.isPresent()) {
            return susp2.get();
        }
        Optional<QueuedUnbind> qu = this.getUnbinds().stream().filter(v -> v.getID().equals(id)).findAny();
        if (qu.isPresent()) {
            return qu.get();
        }
        return null;
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Arrays.hashCode(this.ORIGINAL_DATA);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Papyrus other = (Papyrus)obj;
        for (int i = 0; i < this.ORIGINAL_DATA.length; ++i) {
            if (this.ORIGINAL_DATA[i] == other.ORIGINAL_DATA[i]) continue;
            return false;
        }
        return Arrays.equals(this.ORIGINAL_DATA, other.ORIGINAL_DATA);
    }

    private static /* synthetic */ boolean lambda$removeElements$69(StructDef DEF, Struct v) {
        return v.getStructDef() == DEF;
    }

    private static /* synthetic */ boolean lambda$removeElements$68(Script DEF, ScriptInstance v) {
        return v.getDefinition() == DEF;
    }
}

