/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedSet;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.InstanceMap;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.ScriptInstance;

public final class QueuedUnbind
implements PapyrusElement,
AnalyzableElement,
Linkable,
HasID {
    private final EID ID;
    private final int UNKNOWN;
    private final ScriptInstance INSTANCE;

    public QueuedUnbind(LittleEndianInput input, InstanceMap instances, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(instances);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
        this.UNKNOWN = input.readInt();
        this.INSTANCE = (ScriptInstance)instances.get(this.ID);
        assert (null != this.INSTANCE);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeESSElement(this.ID);
        output.writeInt(this.UNKNOWN);
    }

    @Override
    public int calculateSize() {
        return 4 + this.ID.calculateSize();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public int getUnknown() {
        return this.UNKNOWN;
    }

    public ScriptInstance getScriptInstance() {
        return this.INSTANCE;
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        SortedSet providers;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.INSTANCE && null != this.INSTANCE.getScript()) {
            BUILDER.append(String.format("<html><h3>QUEUED UNBIND of %s</h3>", this.INSTANCE.getScript().toHTML()));
        } else if (null != this.INSTANCE) {
            BUILDER.append(String.format("<html><h3>QUEUED UNBIND of %s</h3>", this.INSTANCE.getScriptName()));
        } else {
            BUILDER.append(String.format("<html><h3>QUEUED UNBIND of %s</h3>", this.ID));
        }
        if (null == this.INSTANCE) {
            BUILDER.append(String.format("<p>Instance: %s</p>", this.ID));
        } else {
            BUILDER.append(String.format("<p>Instance: %s</p>", this.INSTANCE.toHTML()));
        }
        BUILDER.append(String.format("<p>Unknown: %s</p>", EID.pad8(this.UNKNOWN)));
        Element UNK = save.broadSpectrumMatch(this.UNKNOWN);
        if (null != UNK) {
            BUILDER.append("<p>Potential match for UNKNOWN found using general search:<br/>");
            if (UNK instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNK)).toHTML());
            } else {
                BUILDER.append(UNK.toString());
            }
            BUILDER.append("</p>");
        }
        if (null != analysis && null != (providers = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.INSTANCE.getScriptName()))) {
            String probablyProvider = (String)providers.last();
            BUILDER.append(String.format("The queued unbinding probably came from mod \"%s\".\n\n", probablyProvider));
            if (providers.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                providers.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return this.INSTANCE.matches(analysis, mod);
    }

    public boolean isUndefined() {
        return this.INSTANCE.isUndefined();
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"%s\">%s</a>", this.ID, this.toString());
    }

    public String toString() {
        if (null == this.INSTANCE) {
            return this.ID + ": " + EID.pad8(this.UNKNOWN) + " (MISSING INSTANCE)";
        }
        return this.ID + ": " + EID.pad8(this.UNKNOWN) + " (" + this.INSTANCE.getScriptName() + ")";
    }
}

