/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.ReferenceData;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.TString;

public final class Reference
extends GameElement {
    private ReferenceData data;

    public Reference(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        super(input, scripts, ctx);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        super.write(output);
    }

    @Override
    public int calculateSize() {
        return super.calculateSize();
    }

    public ReferenceData getData() {
        return this.data;
    }

    public void setData(ReferenceData newData) {
        this.data = newData;
    }

    public TString getScriptName() {
        return super.getDefinitionName();
    }

    public Script getScript() {
        assert (super.getDefinition() instanceof Script);
        return (Script)super.getDefinition();
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"reference://%s\">%s</a>", this.getID(), this.toString());
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        if (this.isUndefined()) {
            BUF.append("#").append(this.getScriptName()).append("# ");
        } else {
            BUF.append(this.getScriptName()).append(": ");
        }
        BUF.append("(").append(this.getID()).append(")");
        return BUF.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        Element UNKNOWN2;
        SortedSet providers;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.getScript()) {
            BUILDER.append(String.format("<html><h3>REFERENCE of %s</h3>", this.getScript().toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>REFERENCE of %s</h3>", this.getScriptName()));
        }
        if (null != analysis && null != (providers = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.getScriptName()))) {
            String probablyProvider = (String)providers.last();
            BUILDER.append(String.format("<p>This script probably came from \"%s\".</p>", probablyProvider));
            if (providers.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                providers.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append(String.format("<p>ID: %s</p>", this.getID()));
        BUILDER.append(String.format("<p>Type2: %s</p>", this.data.getType()));
        BUILDER.append(String.format("<p>Unknown1: %08x</p>", this.data.getUnknown1()));
        BUILDER.append(String.format("<p>Unknown2: %08x</p>", this.data.getUnknown2()));
        Element UNKNOWN1 = save.broadSpectrumMatch(this.getData().getUnknown1());
        if (null != UNKNOWN1) {
            BUILDER.append("<p>Potential match for unknown1 found using general search:<br/>");
            if (UNKNOWN1 instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNKNOWN1)).toHTML());
            } else {
                BUILDER.append(UNKNOWN1.toString());
            }
            BUILDER.append("</p>");
        }
        if (null != (UNKNOWN2 = save.broadSpectrumMatch(this.getData().getUnknown2()))) {
            BUILDER.append("<p>Potential match for unknown2 found using general search:<br/>");
            if (UNKNOWN2 instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNKNOWN2)).toHTML());
            } else {
                BUILDER.append(UNKNOWN2.toString());
            }
            BUILDER.append("</p>");
        }
        List<ScriptInstance> REFERRING_INSTANCES = save.getPapyrus().getInstances().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<Reference> REFERRING_REFS = save.getPapyrus().getReferences().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ArrayInfo> REFERRING_ARRAYS = save.getPapyrus().getArrays().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ActiveScript> REFERRING_THREADS = save.getPapyrus().getActiveScripts().values().stream().filter(t -> t.getData().getStackFrames().stream().anyMatch(s -> s.getOwner().hasRef(this.getID()))).collect(Collectors.toList());
        List<Struct> REFERRING_STRUCTS = save.getPapyrus().getStructs().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        BUILDER.append(String.format("<p>There are %d threads with stackframes attached to this reference.</p>", REFERRING_THREADS.size()));
        if (0 < REFERRING_THREADS.size() && REFERRING_THREADS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_THREADS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d instances holding refs to this reference.</p>", REFERRING_INSTANCES.size()));
        if (0 < REFERRING_INSTANCES.size() && REFERRING_INSTANCES.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_INSTANCES.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d references holding refs to this reference.</p>", REFERRING_REFS.size()));
        if (0 < REFERRING_REFS.size() && REFERRING_REFS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_REFS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d arrays holding refs to this reference.</p>", REFERRING_ARRAYS.size()));
        if (0 < REFERRING_ARRAYS.size() && REFERRING_ARRAYS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_ARRAYS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d struct holding refs to this reference.</p>", REFERRING_STRUCTS.size()));
        if (0 < REFERRING_STRUCTS.size() && REFERRING_STRUCTS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_STRUCTS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public void addNames(Analysis analysis) {
        assert (null != this.data);
        this.data.addNames(analysis);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        super.resolveRefs(ess, owner);
        this.data.resolveRefs(ess, this);
    }
}

