/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class ReferenceData
implements PapyrusElement,
HasID {
    private final EID ID;
    private final byte FLAG;
    private final TString TYPE;
    private final int UNKNOWN1;
    private final int UNKNOWN2;
    private final List<Variable> MEMBERS;

    public ReferenceData(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
        this.FLAG = input.readByte();
        this.TYPE = ctx.STRINGS.read(input);
        this.UNKNOWN1 = input.readInt();
        this.UNKNOWN2 = (this.FLAG & 4) != 0 ? input.readInt() : 0;
        int memberCount = input.readInt();
        this.MEMBERS = new ArrayList<Variable>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            Variable var = Variable.read(input, ctx);
            this.MEMBERS.add(var);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeESSElement(this.ID);
        output.writeByte(this.FLAG);
        output.writeESSElement(this.TYPE);
        output.writeInt(this.UNKNOWN1);
        if ((this.FLAG & 4) != 0) {
            output.writeInt(this.UNKNOWN2);
        }
        output.writeInt(this.MEMBERS.size());
        for (Variable var : this.MEMBERS) {
            output.writeESSElement(var);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 9;
        sum += this.ID.calculateSize();
        sum += (this.FLAG & 4) != 0 ? 4 : 0;
        sum += this.TYPE.calculateSize();
        return sum += this.MEMBERS.parallelStream().mapToInt(var -> var.calculateSize()).sum();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public TString getType() {
        return this.TYPE;
    }

    public List<Variable> getMembers() {
        return this.MEMBERS;
    }

    public int getUnknown1() {
        return this.UNKNOWN1;
    }

    public int getUnknown2() {
        return this.UNKNOWN2;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.MEMBERS.stream().forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.MEMBERS.forEach(var -> var.resolveRefs(ess, owner));
        this.TYPE.addRefHolder(owner);
    }
}

