/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianRAF;
import restringer.Profile;
import restringer.bsa.BSAParser;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.Definition;
import restringer.ess.papyrus.MemberDesc;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.TString;
import restringer.pex.AssemblyLevel;
import restringer.pex.PexFile;

public final class Script
extends Definition {
    private static final IString[] IMPLICITSCRIPTS_ARR = new IString[]{IString.get("Alias"), IString.get("Form"), IString.get("ActiveMagicEffect"), IString.get("Utility"), IString.get("Debug"), IString.get("Game"), IString.get("Math"), IString.get("Input"), IString.get("SKSE"), IString.get("StringUtil"), IString.get("UI"), IString.get("ModEvent")};
    static final List<IString> IMPLICITSCRIPTS = Arrays.asList(IMPLICITSCRIPTS_ARR);
    private final TString NAME;
    private final TString TYPE;
    private final List<MemberDesc> MEMBERS;
    private Script parent;

    public Script(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.NAME = ctx.STRINGS.read(input);
        this.TYPE = ctx.STRINGS.read(input);
        int memberCount = input.readInt();
        this.MEMBERS = new ArrayList<MemberDesc>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            MemberDesc member = new MemberDesc(input, ctx);
            this.MEMBERS.add(member);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        this.NAME.write(output);
        this.TYPE.write(output);
        output.writeInt(this.MEMBERS.size());
        for (MemberDesc member : this.MEMBERS) {
            member.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 4;
        sum += this.NAME.calculateSize();
        sum += this.TYPE.calculateSize();
        return sum += this.MEMBERS.stream().mapToInt(member -> member.calculateSize()).sum();
    }

    @Override
    public TString getName() {
        return this.NAME;
    }

    public TString getType() {
        return this.TYPE;
    }

    public List<MemberDesc> getMembers() {
        return Collections.unmodifiableList(this.MEMBERS);
    }

    public List<MemberDesc> getExtendedMembers() {
        if (null != this.parent) {
            List<MemberDesc> EXTENDED = this.parent.getExtendedMembers();
            EXTENDED.addAll(this.MEMBERS);
            return EXTENDED;
        }
        ArrayList<MemberDesc> EXTENDED = new ArrayList<MemberDesc>(this.MEMBERS);
        return EXTENDED;
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.parent = (Script)ess.getPapyrus().getScripts().get(this.TYPE);
        this.MEMBERS.forEach(member -> member.resolveRefs(ess, this));
        this.NAME.addRefHolder(this);
        this.TYPE.addRefHolder(this);
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"script://%s\">%s</a>", this.NAME, this.NAME);
    }

    public String toString() {
        if (this.isUndefined()) {
            return "#" + this.NAME + " (" + this.getInstanceCount() + ")";
        }
        return this.NAME + " (" + this.getInstanceCount() + ")";
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        SortedSet mods;
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html>");
        if (this.TYPE.isEmpty()) {
            BUILDER.append(String.format("<h3>SCRIPT %s</h3>", this.NAME));
        } else if (null != this.parent) {
            BUILDER.append(String.format("<h3>SCRIPT %s extends %s</h3>", this.NAME, this.parent.toHTML()));
        } else {
            BUILDER.append(String.format("<h3>SCRIPT %s extends %s</h3>", this.NAME, this.TYPE));
        }
        if (this.isUndefined()) {
            BUILDER.append("<p>WARNING: SCRIPT MISSING!<br />Selecting \"Remove Undefined Instances\" will delete this.</p>");
        }
        if (null != analysis && null != (mods = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.NAME))) {
            if (mods.size() > 1) {
                BUILDER.append("<p>WARNING: MORE THAN ONE MOD PROVIDES THIS SCRIPT!<br />Exercise caution when editing or deleting this script!</p>");
            }
            String probablyProvider = (String)mods.last();
            BUILDER.append(String.format("<p>This script probably came from \"%s\".</p>", probablyProvider));
            BUILDER.append("<p>Full list of providers:</p>");
            BUILDER.append("<ul>");
            mods.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
            BUILDER.append("</ul>");
        }
        int inheritCount = 0;
        Script p = this.parent;
        while (p != null) {
            inheritCount += p.MEMBERS.size();
            p = p.parent;
        }
        BUILDER.append(String.format("<p>Contains %d member variables, %d were inherited.</p>", this.MEMBERS.size() + inheritCount, inheritCount));
        List<ScriptInstance> INSTANCES = save.getPapyrus().getInstances().values().stream().filter(instance -> instance.getScript() == this).collect(Collectors.toList());
        List<Reference> REFERENCES = save.getPapyrus().getReferences().values().stream().filter(ref -> ref.getScript() == this).collect(Collectors.toList());
        BUILDER.append(String.format("<p>There are %d instances of this script.</p>", INSTANCES.size()));
        if (INSTANCES.size() < 20) {
            BUILDER.append("<ul>");
            INSTANCES.forEach(i -> {
                String s = String.format("<li>%s</a>", i.toHTML());
                BUILDER.append(s);
            });
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d references of this script.</p>", REFERENCES.size()));
        if (REFERENCES.size() < 20) {
            BUILDER.append("<ul>");
            REFERENCES.forEach(i -> {
                String s = String.format("<li>%s</a>", i.toHTML());
                BUILDER.append(s);
            });
            BUILDER.append("</ul>");
        }
        if (null != analysis && analysis.SCRIPTS.containsKey(this.NAME)) {
            File PEXFILE = (File)analysis.SCRIPTS.get(this.NAME);
            File PARENT = PEXFILE.getParentFile();
            BUILDER.append("");
            BUILDER.append(String.format("<hr /><p>Disassembled source code:<br />(from %s)</p>", PEXFILE.getPath()));
            if (PEXFILE.exists() && PEXFILE.canRead()) {
                try {
                    PexFile SCRIPT = PexFile.readScript(PEXFILE);
                    LinkedList<String> CODE = new LinkedList<String>();
                    try {
                        SCRIPT.disassemble(CODE, AssemblyLevel.STRIPPED);
                    }
                    catch (Exception ex) {
                        BUILDER.append("Error disassembling script: ").append(ex.getMessage());
                    }
                    BUILDER.append("<p<code><pre>");
                    CODE.forEach(s -> BUILDER.append((String)s).append('\n'));
                    BUILDER.append("</pre></code></p>");
                }
                catch (RuntimeException ex) {
                    BUILDER.append("<p><em>Error: disassembly failed.</em></p>");
                }
                catch (IOException ex) {
                    BUILDER.append("<p><em>Error: couldn't read the script file.</em></p>");
                }
                catch (Error ex) {
                    BUILDER.append("<p><em>Error: unexpected error while reading script file.</em></p>");
                }
            } else if (PARENT.exists() && PARENT.isFile()) {
                try (LittleEndianRAF input = new LittleEndianRAF(PARENT, "r");){
                    BSAParser BSA = new BSAParser(PARENT.getName(), input);
                    PexFile SCRIPT = BSA.getScript(PEXFILE.getName());
                    LinkedList<String> CODE = new LinkedList<String>();
                    try {
                        SCRIPT.disassemble(CODE, AssemblyLevel.STRIPPED);
                    }
                    catch (Exception ex) {
                        BUILDER.append("Error disassembling script: ").append(ex.getMessage());
                    }
                    BUILDER.append("<p<code><pre>");
                    CODE.forEach(s -> BUILDER.append((String)s).append('\n'));
                    BUILDER.append("</pre></code></p>");
                }
                catch (RuntimeException ex) {
                    BUILDER.append("<p><em>Error: disassembly failed.</em></p>");
                }
                catch (IOException ex) {
                    BUILDER.append("<p><em>Error: couldn't read the script file.</em></p>");
                }
                catch (Error ex) {
                    BUILDER.append("<p><em>Error: unexpected error while reading script file.</em></p>");
                }
            }
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        SortedSet<String> OWNERS = analysis.SCRIPT_ORIGINS.get(this.NAME);
        return null != OWNERS && OWNERS.contains(mod);
    }

    @Override
    public boolean isUndefined() {
        if (null == this.TYPE || this.TYPE.isEmpty()) {
            return !IMPLICITSCRIPTS.contains(this.NAME);
        }
        return false;
    }
}

