/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.Member;
import restringer.ess.papyrus.MemberDesc;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptData;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class ScriptInstance
extends GameElement {
    private final short UNKNOWN2BITS;
    private final short UNKNOWN;
    private final RefID REFID;
    private final byte UNKNOWN_BYTE;
    private final Byte UNKNOWN_FO_BYTE;
    private ScriptData data;

    public ScriptInstance(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        super(input, scripts, ctx);
        this.UNKNOWN2BITS = input.readShort();
        this.UNKNOWN = input.readShort();
        this.REFID = new RefID(input);
        this.UNKNOWN_BYTE = input.readByte();
        this.UNKNOWN_FO_BYTE = ctx.GAME.isFO4() ? ((this.UNKNOWN2BITS & 3) == 3 ? Byte.valueOf(input.readByte()) : null) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        super.write(output);
        output.writeShort(this.UNKNOWN2BITS);
        output.writeShort(this.UNKNOWN);
        output.writeESSElement(this.REFID);
        output.writeByte(this.UNKNOWN_BYTE);
        if (null != this.UNKNOWN_FO_BYTE) {
            output.writeByte(this.UNKNOWN_FO_BYTE.byteValue());
        }
    }

    @Override
    public int calculateSize() {
        int sum = 5;
        sum += super.calculateSize();
        sum += this.REFID.calculateSize();
        if (null != this.UNKNOWN_FO_BYTE) {
            ++sum;
        }
        return sum;
    }

    public RefID getRefID() {
        return this.REFID;
    }

    public short getUnknown() {
        return this.UNKNOWN;
    }

    public boolean isMysteryFlag() {
        return this.UNKNOWN == -1;
    }

    public ScriptData getData() {
        return this.data;
    }

    public void setData(ScriptData newData) {
        this.data = newData;
    }

    public TString getScriptName() {
        return super.getDefinitionName();
    }

    public Script getScript() {
        assert (super.getDefinition() instanceof Script);
        return (Script)super.getDefinition();
    }

    public List<Member> getMembers() {
        if (null == this.getScript()) {
            return null;
        }
        List<MemberDesc> DESCS = this.getScript().getExtendedMembers();
        List<Variable> VARS = this.getData().getMembers();
        assert (DESCS.size() == VARS.size());
        ArrayList<Member> MEMBERS = new ArrayList<Member>(DESCS.size());
        Iterator<MemberDesc> I1 = DESCS.iterator();
        Iterator<Variable> I2 = VARS.iterator();
        while (I1.hasNext() && I2.hasNext()) {
            MemberDesc desc = I1.next();
            Variable var = I2.next();
            MEMBERS.add(new Member(desc, var));
        }
        return MEMBERS;
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"instance://%s\">%s</a>", this.getID(), this.toString());
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        if (this.isUndefined()) {
            BUF.append("#").append(this.getScriptName()).append("#: ");
        } else {
            BUF.append(this.getScriptName()).append(": ");
        }
        if (this.REFID.isNonexistentCreated()) {
            BUF.append(this.isMysteryFlag() ? "@" : "&");
        } else if (this.isMysteryFlag()) {
            BUF.append("*");
        }
        BUF.append("refid=").append(this.REFID).append(" (").append(this.getID()).append(")");
        return BUF.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        boolean mysteryFlag;
        SortedSet PROVIDERS;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.getScript()) {
            BUILDER.append(String.format("<html><h3>INSTANCE of %s</h3>", this.getScript().toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>INSTANCE of %s</h3>", this.getScriptName()));
        }
        Plugin PLUGIN = this.REFID.getPlugin();
        if (PLUGIN != null) {
            BUILDER.append(String.format("<p>This instance is attached to an object from %s.</p>", PLUGIN.toHTML()));
        } else if (this.REFID.getType() == RefID.Type.CREATED) {
            BUILDER.append("<p>This instance was created in-game.</p>");
        }
        if (this.isUndefined()) {
            BUILDER.append("<p><em>WARNING: SCRIPT MISSING!</em><br/>Remove Undefined Instances\" will delete this.</p>");
        }
        if (this.isUnattached()) {
            BUILDER.append("<p><em>WARNING: OBJECT MISSING!</em><br/>Selecting \"Remove Unattached Instances\" will delete this.</p>");
        }
        if (this.REFID.isNonexistentCreated()) {
            BUILDER.append("<p><em>REFID POINTS TO NONEXISTENT CREATED FORM.</em><br/>Remove non-existent form instances\" will delete this. However, some mods create these instances deliberately. </p>");
        }
        if (null != analysis && null != (PROVIDERS = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.getScriptName()))) {
            String probableProvider = (String)PROVIDERS.last();
            BUILDER.append(String.format("<p>The script probably came from mod \"%s\".</p>", probableProvider));
            if (PROVIDERS.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                PROVIDERS.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append(String.format("<p>ID: %s</p>", this.getID()));
        BUILDER.append(String.format("<p>Type: %s</p>", this.data.getType()));
        boolean bl = mysteryFlag = this.UNKNOWN == -1;
        if (save.getChangeForms().containsKey(this.REFID)) {
            BUILDER.append(String.format("<p>RefID%s: %s</p>", mysteryFlag ? "@" : "", this.REFID.toHTML()));
        } else {
            BUILDER.append(String.format("<p>RefID%s: %s</p>", mysteryFlag ? "@" : "", this.REFID.toString()));
        }
        BUILDER.append(String.format("<p>Unknown2bits: %01X</p>", this.UNKNOWN2BITS));
        BUILDER.append(String.format("<p>UnknownShort: %04X</p>", this.UNKNOWN));
        BUILDER.append(String.format("<p>UnknownByte: %02x</p>", this.UNKNOWN_BYTE));
        List<ScriptInstance> REFERRING_INSTANCES = save.getPapyrus().getInstances().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<Reference> REFERRING_REFS = save.getPapyrus().getReferences().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ArrayInfo> REFERRING_ARRAYS = save.getPapyrus().getArrays().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ActiveScript> REFERRING_THREADS = save.getPapyrus().getActiveScripts().values().stream().filter(t -> t.getData().getStackFrames().stream().anyMatch(s -> s.getOwner().hasRef(this.getID()))).collect(Collectors.toList());
        List<Struct> REFERRING_STRUCTS = save.getPapyrus().getStructs().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        BUILDER.append(String.format("<p>There are %d threads with stackframes attached to this instance.</p>", REFERRING_THREADS.size()));
        if (0 < REFERRING_THREADS.size() && REFERRING_THREADS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_THREADS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d instances holding refs to this instance.</p>", REFERRING_INSTANCES.size()));
        if (0 < REFERRING_INSTANCES.size() && REFERRING_INSTANCES.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_INSTANCES.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d references holding refs to this instance.</p>", REFERRING_REFS.size()));
        if (0 < REFERRING_REFS.size() && REFERRING_REFS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_REFS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d arrays holding refs to this instance.</p>", REFERRING_ARRAYS.size()));
        if (0 < REFERRING_ARRAYS.size() && REFERRING_ARRAYS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_ARRAYS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d struct holding refs to this instance.</p>", REFERRING_STRUCTS.size()));
        if (0 < REFERRING_STRUCTS.size() && REFERRING_STRUCTS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_STRUCTS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public void addNames(Analysis analysis) {
        assert (null != this.data);
        this.data.addNames(analysis);
        this.REFID.addNames(analysis);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        super.resolveRefs(ess, owner);
        this.data.resolveRefs(ess, this);
        this.REFID.resolveRefs(ess, this);
    }

    public boolean isUnattached() {
        return this.REFID.equals(RefID.NONE);
    }
}

