/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Flags;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.FunctionLocal;
import restringer.ess.papyrus.FunctionParam;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.MemberDesc;
import restringer.ess.papyrus.OpcodeData;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Parameter;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Type;
import restringer.ess.papyrus.Variable;
import restringer.pex.Opcode;

public final class StackFrame
implements PapyrusElement,
AnalyzableElement {
    private final Flags.Byte FLAG;
    private final Type FN_TYPE;
    private final TString SCRIPTNAME;
    private final Script SCRIPT;
    private final TString BASENAME;
    private final TString EVENT;
    private final TString STATUS;
    private final byte OPCODE_MAJORVERSION;
    private final byte OPCODE_MINORVERSION;
    private final TString RETURNTYPE;
    private final TString FN_DOCSTRING;
    private final Flags.Int FN_USERFLAGS;
    private final Flags.Byte FN_FLAGS;
    private final List<FunctionParam> FN_PARAMS;
    private final List<FunctionLocal> FN_LOCALS;
    private final List<OpcodeData> CODE;
    private final int PTR;
    private final Variable OWNERFIELD;
    private final List<Variable> UNKNOWN2;
    private GameElement owner;
    static final Pattern AUTOVAR_REGEX = Pattern.compile("^::(.+)_var$", 2);

    public StackFrame(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        int i;
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        int variableCount = input.readInt();
        this.UNKNOWN2 = new ArrayList<Variable>(variableCount);
        this.FLAG = new Flags.Byte(input);
        this.FN_TYPE = Type.read(input);
        this.SCRIPTNAME = ctx.STRINGS.read(input);
        this.SCRIPT = scripts.getOrDefault(this.SCRIPTNAME, null);
        this.BASENAME = ctx.STRINGS.read(input);
        this.EVENT = ctx.STRINGS.read(input);
        this.STATUS = !this.FLAG.getFlag(0) && this.FN_TYPE == Type.NULL ? ctx.STRINGS.read(input) : null;
        this.OPCODE_MAJORVERSION = input.readByte();
        this.OPCODE_MINORVERSION = input.readByte();
        this.RETURNTYPE = ctx.STRINGS.read(input);
        this.FN_DOCSTRING = ctx.STRINGS.read(input);
        this.FN_USERFLAGS = new Flags.Int(input);
        this.FN_FLAGS = new Flags.Byte(input);
        int functionParameterCount = input.readUnsignedShort();
        this.FN_PARAMS = new ArrayList<FunctionParam>(functionParameterCount);
        for (int i2 = 0; i2 < functionParameterCount; ++i2) {
            FunctionParam param = new FunctionParam(input, ctx);
            this.FN_PARAMS.add(param);
        }
        int functionLocalCount = input.readUnsignedShort();
        this.FN_LOCALS = new ArrayList<FunctionLocal>(functionLocalCount);
        for (int i3 = 0; i3 < functionLocalCount; ++i3) {
            FunctionLocal local = new FunctionLocal(input, ctx);
            this.FN_LOCALS.add(local);
        }
        int opcodeCount = input.readUnsignedShort();
        this.CODE = new ArrayList<OpcodeData>(opcodeCount);
        for (i = 0; i < opcodeCount; ++i) {
            OpcodeData opcode = new OpcodeData(input, ctx);
            this.CODE.add(opcode);
        }
        this.PTR = input.readInt();
        this.OWNERFIELD = Variable.read(input, ctx);
        for (i = 0; i < variableCount; ++i) {
            Variable var = Variable.read(input, ctx);
            this.UNKNOWN2.add(var);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeInt(this.UNKNOWN2.size());
        output.writeESSElement(this.FLAG);
        this.FN_TYPE.write(output);
        this.SCRIPTNAME.write(output);
        this.BASENAME.write(output);
        this.EVENT.write(output);
        if (null != this.STATUS) {
            this.STATUS.write(output);
        }
        output.writeByte(this.OPCODE_MAJORVERSION);
        output.writeByte(this.OPCODE_MINORVERSION);
        this.RETURNTYPE.write(output);
        this.FN_DOCSTRING.write(output);
        output.writeESSElement(this.FN_USERFLAGS);
        output.writeESSElement(this.FN_FLAGS);
        output.writeShort(this.FN_PARAMS.size());
        for (FunctionParam param : this.FN_PARAMS) {
            param.write(output);
        }
        output.writeShort(this.FN_LOCALS.size());
        for (FunctionLocal local : this.FN_LOCALS) {
            local.write(output);
        }
        output.writeShort(this.CODE.size());
        for (OpcodeData opcode : this.CODE) {
            opcode.write(output);
        }
        output.writeInt(this.PTR);
        if (null != this.OWNERFIELD) {
            this.OWNERFIELD.write(output);
        }
        for (Variable var : this.UNKNOWN2) {
            var.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        sum += this.FN_TYPE.calculateSize();
        sum += this.SCRIPTNAME.calculateSize();
        sum += this.BASENAME.calculateSize();
        sum += this.EVENT.calculateSize();
        sum += null != this.STATUS ? this.STATUS.calculateSize() : 0;
        sum += 2;
        sum += this.RETURNTYPE.calculateSize();
        sum += this.FN_DOCSTRING.calculateSize();
        sum += 5;
        sum += 2;
        sum += this.FN_PARAMS.stream().mapToInt(param -> param.calculateSize()).sum();
        sum += 2;
        sum += this.FN_LOCALS.stream().mapToInt(local -> local.calculateSize()).sum();
        sum += 2;
        sum += this.CODE.stream().mapToInt(opcode -> opcode.calculateSize()).sum();
        sum += 4;
        sum += null != this.OWNERFIELD ? this.OWNERFIELD.calculateSize() : 0;
        sum += 4;
        return sum += this.UNKNOWN2.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    void zero() {
        for (int i = 0; i < this.CODE.size(); ++i) {
            this.CODE.set(i, OpcodeData.NOP);
        }
    }

    public TString getScriptName() {
        return this.SCRIPTNAME;
    }

    public Script getScript() {
        return this.SCRIPT;
    }

    public IString getFName() {
        IString fname = IString.format("%s.%s", this.SCRIPTNAME, this.EVENT);
        return fname;
    }

    public List<FunctionParam> getFunctionParams() {
        return Collections.unmodifiableList(this.FN_PARAMS);
    }

    public List<FunctionLocal> getFunctionLocals() {
        return Collections.unmodifiableList(this.FN_LOCALS);
    }

    public List<OpcodeData> getOpcodeData() {
        return Collections.unmodifiableList(this.CODE);
    }

    public List<Variable> getUnknown2() {
        return Collections.unmodifiableList(this.UNKNOWN2);
    }

    public Variable getOwner() {
        return this.OWNERFIELD;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.FN_LOCALS.forEach(v -> v.addNames(analysis));
        this.FN_PARAMS.forEach(v -> v.addNames(analysis));
        this.UNKNOWN2.forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        assert (owner instanceof ActiveScript);
        this.OWNERFIELD.resolveRefs(ess, this);
        this.FN_LOCALS.forEach(v -> v.resolveRefs(ess, this));
        this.FN_PARAMS.forEach(v -> v.resolveRefs(ess, this));
        this.UNKNOWN2.forEach(v -> v.resolveRefs(ess, this));
        this.SCRIPTNAME.addRefHolder(this);
        this.BASENAME.addRefHolder(this);
        this.EVENT.addRefHolder(this);
        this.RETURNTYPE.addRefHolder(this);
        this.FN_DOCSTRING.addRefHolder(this);
        if (null != this.STATUS) {
            this.STATUS.addRefHolder(this);
        }
        if (this.OWNERFIELD instanceof Variable.Ref) {
            Variable.Ref ref = (Variable.Ref)this.OWNERFIELD;
            this.owner = ref.getReferent();
        }
    }

    public boolean isUndefined() {
        if (null == this.SCRIPT) {
            return !Script.IMPLICITSCRIPTS.contains(this.SCRIPTNAME);
        }
        return this.SCRIPT.isUndefined();
    }

    public boolean isStatic() {
        return null != this.FN_FLAGS ? this.FN_FLAGS.getFlag(0) : false;
    }

    public boolean isNative() {
        return null != this.FN_FLAGS ? this.FN_FLAGS.getFlag(1) : false;
    }

    public boolean isZeroed() {
        if (this.isNative()) {
            return false;
        }
        if (null == this.CODE) {
            return false;
        }
        return this.CODE.stream().allMatch(op -> OpcodeData.NOP.equals(op));
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        BUF.append(this.isZeroed() ? "ZEROED " : "");
        BUF.append(this.isUndefined() ? "#" : "");
        BUF.append(this.SCRIPTNAME);
        BUF.append(this.isUndefined() ? "#." : ".");
        BUF.append(this.EVENT);
        BUF.append("()");
        return BUF.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        SortedSet providers;
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html><h3>STACKFRAME");
        if (this.isZeroed()) {
            BUILDER.append(" (ZEROED)");
        }
        BUILDER.append("<br/>");
        if (!this.RETURNTYPE.isEmpty() && !this.RETURNTYPE.equals("None")) {
            BUILDER.append(this.RETURNTYPE).append(" ");
        }
        if (this.isUndefined()) {
            BUILDER.append("#");
        }
        BUILDER.append(String.format("%s.%s()", this.SCRIPTNAME, this.EVENT));
        if (this.isStatic()) {
            BUILDER.append(" static");
        }
        if (this.isNative()) {
            BUILDER.append(" native");
        }
        BUILDER.append("</h3>");
        if (this.isZeroed()) {
            BUILDER.append("<p><em>WARNING: FUNCTION TERMINATED!</em><br/>This function has been terminated and all of its instructions erased.</p>");
        } else if (this.isUndefined()) {
            BUILDER.append("<p><em>WARNING: SCRIPT MISSING!</em><br/>Selecting \"Remove Undefined Instances\" will terminate the entire thread containing this frame.</p>");
        }
        if (null != analysis && null != (providers = (SortedSet)analysis.FUNCTION_ORIGINS.get(this.getFName()))) {
            String probablyProvider = (String)providers.last();
            BUILDER.append(String.format("<p>Probably running code from mod %s.</p>", probablyProvider));
            if (providers.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                providers.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        if (this.OWNERFIELD instanceof Variable.Null) {
            BUILDER.append("<p>Owner: <em>UNOWNED</em></p>");
        } else if (null != this.owner) {
            BUILDER.append(String.format("<p>Owner: %s</p>", this.owner.toHTML()));
        } else if (this.isStatic()) {
            BUILDER.append("<p>Static method, no owner.</p>");
        } else {
            BUILDER.append(String.format("<p>Owner: %s</p>", this.OWNERFIELD.toHTML()));
        }
        BUILDER.append("<p>");
        BUILDER.append(String.format("Script: %s<br/>", null == this.SCRIPT ? this.SCRIPTNAME : this.SCRIPT.toHTML()));
        BUILDER.append(String.format("Base: %s<br/>", this.BASENAME));
        BUILDER.append(String.format("Event: %s<br/>", this.EVENT));
        BUILDER.append(String.format("Status: %s<br/>", this.STATUS));
        BUILDER.append(String.format("Flag: %s<br/>", this.FLAG));
        BUILDER.append(String.format("Function type: %s<br/>", this.FN_TYPE));
        BUILDER.append(String.format("Function return type: %s<br/>", this.RETURNTYPE));
        BUILDER.append(String.format("Function docstring: %s<br/>", this.FN_DOCSTRING));
        BUILDER.append(String.format("%d parameters, %d locals, %d values.<br/>", this.FN_PARAMS.size(), this.FN_LOCALS.size(), this.UNKNOWN2.size()));
        BUILDER.append(String.format("Status: %s<br/>", this.STATUS));
        BUILDER.append(String.format("Function flags: %s<br/>", this.FN_FLAGS));
        BUILDER.append(String.format("Function user flags:<br/>%s", this.FN_USERFLAGS.toHTML()));
        BUILDER.append(String.format("Opcode version: %d.%d<br/>", this.OPCODE_MAJORVERSION, this.OPCODE_MINORVERSION));
        BUILDER.append("</p>");
        if (this.CODE.size() > 0) {
            BUILDER.append("<hr/><p>PAPYRUS BYTECODE:</p>");
            BUILDER.append("<code><pre>");
            ArrayList<OpcodeData> CODE = new ArrayList<OpcodeData>(this.CODE);
            CODE.subList(0, this.PTR).forEach(v -> BUILDER.append(String.format("   %s\n", v)));
            BUILDER.append(String.format("==><b>%s</b>\n", CODE.get(this.PTR)));
            CODE.subList(this.PTR + 1, this.CODE.size()).forEach(v -> BUILDER.append(String.format("   %s\n", v)));
            BUILDER.append("</pre></code>");
        } else {
            BUILDER.append("<p><em>Papyrus bytecode not available.</em></p>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        SortedSet<String> OWNERS = analysis.SCRIPT_ORIGINS.get(this.SCRIPTNAME);
        if (null == OWNERS) {
            return false;
        }
        return OWNERS.contains(mod);
    }

    static String preMap(List<OpcodeData> instructions, List<MemberDesc> locals, List<MemberDesc> types, Map<Parameter, Parameter> terms, int ptr) {
        StringBuilder BUF = new StringBuilder();
        for (int i = 0; i < instructions.size(); ++i) {
            OpcodeData op = instructions.get(i);
            if (null == op) continue;
            ArrayList<Parameter> params = new ArrayList<Parameter>(op.getParameters());
            boolean del = StackFrame.makeTerm(op.getOpcode(), params, types, terms);
            if (del) {
                BUF.append(i == ptr ? "<b>==></b>" : "   ");
                BUF.append("<em><font color=\"lightgray\">");
                BUF.append((Object)op.getOpcode());
                params.forEach(p -> BUF.append(", ").append(p.toValueString()));
                BUF.append("<font color=\"black\"></em>\n");
                continue;
            }
            BUF.append(i == ptr ? "<b>==>" : "   ");
            BUF.append((Object)op.getOpcode());
            params.forEach(p -> BUF.append(", ").append(p.toValueString()));
            BUF.append(i == ptr ? "</b>\n" : "\n");
        }
        return BUF.toString();
    }

    static boolean makeTerm(Opcode op, List<Parameter> args, List<MemberDesc> types, Map<Parameter, Parameter> terms) {
        switch (op) {
            case IADD: 
            case FADD: 
            case STRCAT: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s + %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ISUB: 
            case FSUB: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s - %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case IMUL: 
            case FMUL: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s * %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case IDIV: 
            case FDIV: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s / %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case IMOD: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s %% %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case RETURN: {
                StackFrame.replaceVariables(args, terms, -1);
                return false;
            }
            case CALLMETHOD: {
                StackFrame.replaceVariables(args, terms, 2);
                String method = args.get(0).toValueString();
                String obj = args.get(1).toValueString();
                List subArgs = args.subList(3, args.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, StackFrame.paramList(subArgs));
                return StackFrame.processTerm(args, terms, 2, term);
            }
            case CALLPARENT: {
                StackFrame.replaceVariables(args, terms, 1);
                String method = args.get(0).toValueString();
                List subArgs = args.subList(3, args.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                String term = String.format("parent.%s%s", method, StackFrame.paramList(subArgs));
                return StackFrame.processTerm(args, terms, 1, term);
            }
            case CALLSTATIC: {
                StackFrame.replaceVariables(args, terms, 2);
                String obj = args.get(0).toValueString();
                String method = args.get(1).toValueString();
                List subArgs = args.subList(3, args.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, StackFrame.paramList(subArgs));
                return StackFrame.processTerm(args, terms, 2, term);
            }
            case NOT: {
                StackFrame.replaceVariables(args, terms, 0);
                String term = String.format("!%s", args.get(1).paren());
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case INEG: 
            case FNEG: {
                StackFrame.replaceVariables(args, terms, 0);
                String term = String.format("-%s", args.get(1).paren());
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ASSIGN: {
                StackFrame.replaceVariables(args, terms, 0);
                String term = String.format("%s", args.get(1));
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case CAST: {
                StackFrame.replaceVariables(args, terms, 0);
                String dest = args.get(0).toValueString();
                String arg = args.get(1).paren();
                TString type = types.stream().filter(t -> t.getName().equals(dest)).findFirst().get().getType();
                String term = type.equals(IString.get("bool")) ? arg : String.format("(%s)%s", type, arg);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case PROPGET: {
                StackFrame.replaceVariables(args, terms, 2);
                String obj = args.get(1).toValueString();
                String prop = args.get(0).toValueString();
                String term = String.format("%s.%s", obj, prop);
                return StackFrame.processTerm(args, terms, 2, term);
            }
            case PROPSET: {
                StackFrame.replaceVariables(args, terms, -1);
                return false;
            }
            case CMP_EQ: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s == %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case CMP_LT: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s < %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case CMP_LE: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s <= %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case CMP_GT: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s > %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case CMP_GE: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(1).paren();
                String operand2 = args.get(2).paren();
                String term = String.format("%s >= %s", operand1, operand2);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ARR_CREATE: {
                int size = args.get(1).getIntValue();
                String dest = args.get(0).toValueString();
                TString type = types.stream().filter(t -> t.getName().equals(dest)).findFirst().get().getType();
                String subtype = ((IString)type).toString().substring(0, type.length() - 2);
                String term = String.format("new %s[%s]", subtype, size);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ARR_LENGTH: {
                StackFrame.replaceVariables(args, terms, 0);
                String term = String.format("%s.length", args.get(1));
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ARR_GET: {
                StackFrame.replaceVariables(args, terms, 0);
                String operand1 = args.get(2).toValueString();
                String operand2 = args.get(1).toValueString();
                String term = String.format("%s[%s]", operand2, operand1);
                return StackFrame.processTerm(args, terms, 0, term);
            }
            case ARR_SET: {
                StackFrame.replaceVariables(args, terms, -1);
                return false;
            }
            case JMPT: 
            case JMPF: {
                StackFrame.replaceVariables(args, terms, -1);
                return false;
            }
        }
        return false;
    }

    static boolean processTerm(List<Parameter> args, Map<Parameter, Parameter> terms, int destPos, String term) {
        if (destPos >= args.size() || args.get(destPos).getType() != Parameter.Type.IDENTIFIER) {
            return false;
        }
        Parameter dest = args.get(destPos);
        if (!dest.isTemp()) {
            return false;
        }
        terms.put(dest, Parameter.createTerm(term));
        return true;
    }

    static void replaceVariables(List<Parameter> args, Map<Parameter, Parameter> terms, int exclude) {
        for (int i = 0; i < args.size(); ++i) {
            Parameter arg = args.get(i);
            if (terms.containsKey(arg) && i != exclude) {
                args.set(i, terms.get(arg));
                continue;
            }
            if (!arg.isAutovar()) continue;
            Matcher MATCHER = AUTOVAR_REGEX.matcher(arg.toValueString());
            MATCHER.matches();
            String prop = MATCHER.group(1);
            terms.put(arg, Parameter.createTerm(prop));
            args.set(i, terms.get(arg));
        }
    }

    static <T> String paramList(List<T> params) {
        return params.stream().map(p -> p.toString()).collect(Collectors.joining(", ", "(", ")"));
    }
}

