/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import restringer.Analysis;
import restringer.Game;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.WString;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.TString;

public class StringTable
extends ArrayList<TString>
implements PapyrusElement {
    private final boolean STBCORRECTION;
    private final Game GAME;

    public TString read(LittleEndianInput input) throws IOException {
        int index;
        Objects.requireNonNull(input);
        if (this.GAME.isStr32()) {
            index = input.readInt();
        } else {
            index = input.readUnsignedShort();
            if (index == 65535 && !this.STBCORRECTION) {
                index = input.readInt();
            }
        }
        if (index < 0 || index >= this.size()) {
            throw new IOException(String.format("Invalid TString index: %d / %d", index, this.size()));
        }
        TString newString = (TString)this.get(index);
        return newString;
    }

    public StringTable(LittleEndianInput input, Game game, boolean applySTBCorrection) throws IOException {
        int strCount;
        this.GAME = Objects.requireNonNull(game);
        if (this.GAME.isStr32()) {
            strCount = input.readInt();
            this.STBCORRECTION = false;
        } else {
            strCount = input.readUnsignedShort();
            if (strCount == 65535) {
                strCount = input.readInt();
            }
            if (strCount < 20000 && applySTBCorrection) {
                strCount |= 0x10000;
                this.STBCORRECTION = true;
            } else {
                this.STBCORRECTION = false;
            }
        }
        try {
            this.ensureCapacity(strCount);
            for (int i = 0; i < strCount; ++i) {
                try {
                    WString WSTR = WString.read(input);
                    TString TSTR = this.GAME.isStr32() ? new TString32(WSTR, i) : new TString16(WSTR, i);
                    this.add(TSTR);
                    continue;
                }
                catch (IOException | Error | RuntimeException ex) {
                    throw new IOException("Error reading string #" + i, ex);
                }
            }
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d strings.", this.size(), strCount), ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        if (this.STBCORRECTION) {
            throw new IOException("String-Table-Bug correction in effect. Cannot write save.");
        }
        if (this.GAME.isStr32()) {
            output.writeInt(this.size());
        } else if (this.size() > 65520) {
            output.writeShort(65535);
            output.writeInt(this.size());
        } else {
            output.writeShort(this.size());
        }
        for (TString tstr : this) {
            try {
                tstr.writeFull(output);
            }
            catch (IOException ex) {
                throw new IOException("Error writing string #" + tstr.getINDEX(), ex);
            }
        }
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        sum = this.GAME.isStr32() ? (sum += 4) : (this.size() > 65520 ? (sum += 6) : (sum += 2));
        return sum += this.parallelStream().mapToInt(v -> v.calculateFullSize()).sum();
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    public boolean containsMatching(String val) {
        return this.stream().anyMatch(v -> v.equals(val));
    }

    public TString addString(String val) {
        Optional<TString> match = this.stream().filter(v -> v.equals(val)).findFirst();
        if (match.isPresent()) {
            return match.get();
        }
        TString tstr = this.GAME.isStr32() ? new TString32(val, this.size()) : new TString16(val, this.size());
        this.add(tstr);
        return tstr;
    }

    public boolean isSTBCorrection() {
        return this.STBCORRECTION;
    }

    private final class TString32
    extends TString {
        private TString32(WString wstr, int index) {
            super(wstr, index);
        }

        private TString32(CharSequence cs, int index) {
            super(cs, index);
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.getINDEX());
        }

        @Override
        public int calculateSize() {
            return 4;
        }
    }

    private final class TString16
    extends TString {
        private TString16(WString wstr, int index) {
            super(wstr, index);
        }

        private TString16(CharSequence cs, int index) {
            super(cs, index);
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            if (this.getINDEX() > 65520) {
                output.writeShort(65535);
                output.writeInt(this.getINDEX());
            } else {
                output.writeShort(this.getINDEX());
            }
        }

        @Override
        public int calculateSize() {
            return this.getINDEX() > 65520 ? 6 : 2;
        }
    }
}

