/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StructData;
import restringer.ess.papyrus.StructDef;
import restringer.ess.papyrus.StructDefMap;
import restringer.ess.papyrus.TString;

public class Struct
extends GameElement {
    private StructData data;

    public Struct(LittleEndianInput input, StructDefMap defs, PapyrusContext ctx) throws IOException {
        super(input, defs, ctx);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        super.write(output);
    }

    @Override
    public int calculateSize() {
        return super.calculateSize();
    }

    public TString getStructDefName() {
        return super.getDefinitionName();
    }

    public StructDef getStructDef() {
        assert (super.getDefinition() instanceof StructDef);
        return (StructDef)super.getDefinition();
    }

    public StructData getData() {
        return this.data;
    }

    public void setData(StructData newData) {
        this.data = newData;
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"struct://%s\">%s</a>", this.getID(), this.toString());
    }

    public String toString() {
        StringBuilder BUF = new StringBuilder();
        if (this.isUndefined()) {
            BUF.append("#").append(this.getStructDefName()).append("#: ");
        } else {
            BUF.append(this.getStructDefName()).append(": ");
        }
        BUF.append(" (").append(this.getID()).append(")");
        return BUF.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.getStructDef()) {
            BUILDER.append(String.format("<html><h3>STRUCTURE of %s</h3>", this.getStructDef().toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>STRUCTURE of %s</h3>", this.getStructDefName()));
        }
        BUILDER.append(String.format("<p>ID: %s</p>", this.getID()));
        BUILDER.append(String.format("<p>Flag: %s</p>", this.data.getFlag()));
        List<ScriptInstance> REFERRING_INSTANCES = save.getPapyrus().getInstances().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<Reference> REFERRING_REFS = save.getPapyrus().getReferences().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ArrayInfo> REFERRING_ARRAYS = save.getPapyrus().getArrays().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        List<ActiveScript> REFERRING_THREADS = save.getPapyrus().getActiveScripts().values().stream().filter(t -> t.getData().getStackFrames().stream().anyMatch(s -> s.getOwner().hasRef(this.getID()))).collect(Collectors.toList());
        List<Struct> REFERRING_STRUCTS = save.getPapyrus().getStructs().values().stream().filter(v -> v.getData().getMembers().stream().anyMatch(m -> m.hasRef(this.getID()))).collect(Collectors.toList());
        BUILDER.append(String.format("<p>There are %d threads with stackframes attached to this struct.</p>", REFERRING_THREADS.size()));
        if (0 < REFERRING_THREADS.size() && REFERRING_THREADS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_THREADS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d instances holding refs to this struct.</p>", REFERRING_INSTANCES.size()));
        if (0 < REFERRING_INSTANCES.size() && REFERRING_INSTANCES.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_INSTANCES.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d references holding refs to this struct.</p>", REFERRING_REFS.size()));
        if (0 < REFERRING_REFS.size() && REFERRING_REFS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_REFS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d arrays holding refs to this struct.</p>", REFERRING_ARRAYS.size()));
        if (0 < REFERRING_ARRAYS.size() && REFERRING_ARRAYS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_ARRAYS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>There are %d struct holding refs to this struct.</p>", REFERRING_STRUCTS.size()));
        if (0 < REFERRING_STRUCTS.size() && REFERRING_STRUCTS.size() < 50) {
            BUILDER.append("<ul>");
            REFERRING_STRUCTS.forEach(i -> BUILDER.append(String.format("<li>%s</a>", i.toHTML())));
            BUILDER.append("</ul>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public void addNames(Analysis analysis) {
        assert (null != this.data);
        this.data.addNames(analysis);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        super.resolveRefs(ess, owner);
        this.data.resolveRefs(ess, this);
    }
}

