/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Flags;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.StructMap;
import restringer.ess.papyrus.Variable;

public final class StructData
implements PapyrusElement,
HasID {
    private final EID ID;
    private final Flags.Byte FLAG;
    private final ArrayList<Variable> MEMBERS = new ArrayList();

    public StructData(LittleEndianInput input, StructMap structs, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(structs);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
        this.FLAG = Flags.readByteFlags(input);
        int memberCount = input.readInt();
        this.MEMBERS.ensureCapacity(memberCount);
        int i = 0;
        try {
            for (i = 0; i < memberCount; ++i) {
                Variable var = Variable.read(input, ctx);
                this.MEMBERS.add(var);
            }
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d members.", i, memberCount), ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        output.writeESSElement(this.FLAG);
        output.writeInt(this.MEMBERS.size());
        int i = 0;
        for (Variable var : this.MEMBERS) {
            output.writeESSElement(var);
            ++i;
        }
    }

    @Override
    public int calculateSize() {
        int sum = 4;
        sum += this.FLAG.calculateSize();
        sum += this.ID.calculateSize();
        return sum += this.MEMBERS.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public Flags.Byte getFlag() {
        return this.FLAG;
    }

    public List<Variable> getMembers() {
        return this.MEMBERS;
    }

    @Override
    public void addNames(Analysis analysis) {
        this.MEMBERS.forEach(v -> v.addNames(analysis));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.MEMBERS.forEach(var -> var.resolveRefs(ess, owner));
    }

    public String toString() {
        return this.ID.toString() + this.MEMBERS;
    }
}

