/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.stream.Collectors;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.Definition;
import restringer.ess.papyrus.MemberDesc;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.TString;

public final class StructDef
extends Definition {
    private final TString NAME;
    private final List<MemberDesc> MEMBERS;
    private int instanceCount;

    public StructDef(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.NAME = ctx.STRINGS.read(input);
        int memberCount = input.readInt();
        this.MEMBERS = new ArrayList<MemberDesc>(memberCount);
        for (int i = 0; i < memberCount; ++i) {
            MemberDesc member = new MemberDesc(input, ctx);
            this.MEMBERS.add(member);
        }
        this.instanceCount = 0;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        this.NAME.write(output);
        output.writeInt(this.MEMBERS.size());
        for (MemberDesc member : this.MEMBERS) {
            member.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 4;
        sum += this.NAME.calculateSize();
        return sum += this.MEMBERS.stream().mapToInt(member -> member.calculateSize()).sum();
    }

    @Override
    public TString getName() {
        return this.NAME;
    }

    public List<MemberDesc> getMembers() {
        return Collections.unmodifiableList(this.MEMBERS);
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.MEMBERS.forEach(member -> member.resolveRefs(ess, this));
        this.NAME.addRefHolder(this);
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"structdef://%s\">%s</a>", this.NAME, this.NAME);
    }

    public String toString() {
        return this.NAME.toString();
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        SortedSet mods;
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html>");
        BUILDER.append(String.format("<h3>STRUCTURE DEFINITION %ss</h3>", this.NAME));
        if (null != analysis && null != (mods = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.NAME))) {
            if (mods.size() > 1) {
                BUILDER.append("<p>WARNING: MORE THAN ONE MOD PROVIDES THIS SCRIPT!<br />Exercise caution when editing or deleting this script!</p>");
            }
            String probablyProvider = (String)mods.last();
            BUILDER.append(String.format("<p>This script probably came from \"%s\".</p>", probablyProvider));
            BUILDER.append("<p>Full list of providers:</p>");
            BUILDER.append("<ul>");
            mods.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
            BUILDER.append("</ul>");
        }
        BUILDER.append(String.format("<p>Contains %d member variables.</p>", this.MEMBERS.size()));
        List<Struct> STRUCTS = save.getPapyrus().getStructs().values().stream().filter(instance -> instance.getStructDef() == this).collect(Collectors.toList());
        BUILDER.append(String.format("<p>There are %d instances of this structure definition.</p>", STRUCTS.size()));
        if (STRUCTS.size() < 20) {
            BUILDER.append("<ul>");
            STRUCTS.forEach(i -> {
                String s = String.format("<li>%s</a>", i.toHTML());
                BUILDER.append(s);
            });
            BUILDER.append("</ul>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return false;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    void incrementInstanceCount() {
        ++this.instanceCount;
    }
}

