/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedSet;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.FunctionMessageData;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptMap;

public final class SuspendedStack
implements PapyrusElement,
AnalyzableElement,
Linkable,
HasID {
    private final EID ID;
    private final byte FLAG;
    private final FunctionMessageData MESSAGE;
    private String cachedToString = null;

    public SuspendedStack(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        this.ID = EID.read4byte(input);
        this.FLAG = input.readByte();
        this.MESSAGE = this.FLAG > 0 ? new FunctionMessageData(input, this, scripts, ctx) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        output.writeByte(this.FLAG);
        if (this.FLAG > 0) {
            this.MESSAGE.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        sum += this.ID.calculateSize();
        return sum += this.FLAG > 0 ? this.MESSAGE.calculateSize() : 0;
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public FunctionMessageData getMessage() {
        return this.MESSAGE;
    }

    public Script getScript() {
        if (null == this.MESSAGE) {
            return null;
        }
        return this.MESSAGE.getScript();
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"suspended://%s\">%s</a>", this.ID, this.toString());
    }

    public String toString() {
        if (null != this.cachedToString) {
            return this.cachedToString;
        }
        this.cachedToString = null != this.MESSAGE ? (this.isUndefined() ? "STACK #" + this.MESSAGE.getScriptName() + "# (" + this.ID + ")" : "STACK " + this.MESSAGE.getScriptName() + " (" + this.ID + ")") : "STACK (" + this.ID + ")";
        return this.cachedToString;
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        SortedSet mods;
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append(String.format("<html><h3>SUSPENDEDSTACK</h3>", new Object[0]));
        if (null != analysis && null != this.MESSAGE && null != (mods = (SortedSet)analysis.SCRIPT_ORIGINS.get(this.MESSAGE.getScriptName()))) {
            String mod = (String)mods.last();
            BUILDER.append(String.format("<p>Probably running code from mod %s.</p>", mod));
        }
        if (null != this.MESSAGE) {
            BUILDER.append(String.format("<p>Function: %s</p>", this.MESSAGE.getFName()));
        }
        BUILDER.append(String.format("<p>Flag: %02x</p>", this.FLAG));
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return null != this.MESSAGE && this.MESSAGE.matches(analysis, mod);
    }

    @Override
    public void addNames(Analysis analysis) {
        if (null != this.MESSAGE) {
            this.MESSAGE.addNames(analysis);
        }
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (null != this.MESSAGE) {
            this.MESSAGE.resolveRefs(ess, this);
        }
    }

    public boolean isUndefined() {
        if (null != this.MESSAGE) {
            return this.MESSAGE.isUndefined();
        }
        return false;
    }
}

