/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ChangeForm;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.RefID;
import restringer.ess.WString;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.ScriptInstance;

public abstract class TString
extends WString
implements PapyrusElement,
AnalyzableElement {
    private final int INDEX;
    private final Collection<Element> HOLDERS;

    protected TString(WString wstr, int index) {
        super(wstr);
        this.INDEX = index;
        this.HOLDERS = new ArrayList<Element>(1);
    }

    protected TString(CharSequence cs, int index) {
        super(cs);
        this.INDEX = index;
        this.HOLDERS = new ArrayList<Element>(1);
    }

    public void writeFull(LittleEndianDataOutput output) throws IOException {
        super.write(output);
    }

    public int calculateFullSize() {
        return super.calculateSize();
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TString) {
            return this.equals((TString)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(TString other) {
        Objects.requireNonNull(other);
        return this.INDEX == other.INDEX;
    }

    public void addRefHolder(Element newHolder) {
        Objects.requireNonNull(newHolder);
        this.HOLDERS.add(newHolder);
    }

    public int getINDEX() {
        assert (this.INDEX >= 0);
        return this.INDEX;
    }

    @Override
    public String getInfo(Analysis analysis, ESS save) {
        Objects.requireNonNull(save);
        LinkedHashSet<Element> temp = new LinkedHashSet<Element>(this.HOLDERS.size());
        temp.addAll(this.HOLDERS);
        this.HOLDERS.clear();
        this.HOLDERS.addAll(temp);
        temp.clear();
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html><h3>STRING</h3>");
        BUILDER.append(String.format("<p>Value: \"%s\".</p>", this));
        BUILDER.append(String.format("<p>Length: %d</p>", this.length()));
        if (null != analysis) {
            Map OWNERS = (Map)analysis.STRING_ORIGINS.get(this);
            if (null != OWNERS) {
                int total = OWNERS.values().stream().mapToInt(k -> k).sum();
                BUILDER.append(String.format("<p>This string appears %d times in the script files of %d mods.</p><ul>", total, OWNERS.size()));
                OWNERS.forEach((mod, count) -> BUILDER.append(String.format("<li>String appears %d times in the scripts of mod \"%s\".", count, mod)));
                BUILDER.append("</ul>");
            } else {
                BUILDER.append("<p>String origin could not be determined.</p>");
            }
        }
        if (this.HOLDERS.isEmpty()) {
            BUILDER.append("<p>The string could not be found in the savefile. This may mean that something has gone VERY WRONG.</p>");
        } else {
            BUILDER.append(String.format("<p>This string occurs %d times in this save.</p>", this.HOLDERS.size()));
            HashMap<Plugin, Integer> PLUGINS = new HashMap<Plugin, Integer>();
            this.HOLDERS.forEach(holder -> {
                ChangeForm form;
                RefID ref;
                if (holder instanceof ScriptInstance) {
                    ScriptInstance instance = (ScriptInstance)holder;
                    RefID ref2 = instance.getRefID();
                    if (null != ref2 && null != ref2.getPlugin()) {
                        PLUGINS.merge(ref2.getPlugin(), 1, Integer::sum);
                    }
                } else if (holder instanceof ChangeForm && null != (ref = (form = (ChangeForm)holder).getRefID()) && null != ref.getPlugin()) {
                    PLUGINS.merge(ref.getPlugin(), 1, Integer::sum);
                }
            });
            BUILDER.append('\n');
            if (PLUGINS.isEmpty()) {
                BUILDER.append(String.format("<p>This string could not be backtraced to any plugins.</p>", PLUGINS.size()));
            } else {
                BUILDER.append(String.format("<p>This string was backtraced to %d plugins.</p><ul>", PLUGINS.size()));
                PLUGINS.forEach((p, c) -> BUILDER.append(String.format("<li>String was backtraced %d times to plugin %s.", c, p.toHTML())));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        Map<String, Integer> OWNERS = analysis.STRING_ORIGINS.get(this);
        return null != OWNERS && OWNERS.keySet().size() == 1 && OWNERS.keySet().contains(mod);
    }
}

