/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.RefID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class Unknown4
implements PapyrusElement,
Linkable {
    public final String STRING;
    private final Variable VARIABLE;
    private final RefID REFID;
    private final Byte BYTE;
    private final Integer INT;
    private final Integer UNKNOWN_4BYTES;
    private final TString TSTRING;
    private final Short UNKNOWN_SHORT;

    public Unknown4(LittleEndianInput input, byte unknown3, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        assert (1 <= unknown3 && unknown3 <= 3);
        if (unknown3 == 2) {
            this.VARIABLE = Variable.read(input, ctx);
            this.STRING = null;
            this.REFID = null;
            this.TSTRING = null;
            this.UNKNOWN_SHORT = null;
            this.BYTE = null;
            this.INT = null;
            this.UNKNOWN_4BYTES = null;
            return;
        }
        switch (this.STRING = input.readLString()) {
            case "QuestStage": {
                this.REFID = new RefID(input);
                this.TSTRING = null;
                this.UNKNOWN_SHORT = input.readShort();
                this.BYTE = input.readByte();
                this.INT = ctx.GAME.isFO4() ? Integer.valueOf(input.readInt()) : null;
                this.UNKNOWN_4BYTES = null;
                break;
            }
            case "ScenePhaseResults": {
                this.REFID = new RefID(input);
                this.INT = input.readInt();
                this.UNKNOWN_4BYTES = input.readInt();
                this.TSTRING = null;
                this.UNKNOWN_SHORT = null;
                this.BYTE = null;
                break;
            }
            case "SceneActionResults": {
                this.REFID = new RefID(input);
                this.INT = input.readInt();
                this.UNKNOWN_4BYTES = input.readInt();
                this.TSTRING = null;
                this.UNKNOWN_SHORT = null;
                this.BYTE = null;
                break;
            }
            case "SceneResults": {
                this.REFID = new RefID(input);
                this.UNKNOWN_4BYTES = input.readInt();
                this.TSTRING = null;
                this.UNKNOWN_SHORT = null;
                this.BYTE = null;
                this.INT = null;
                break;
            }
            case "TerminalRunResults": {
                this.BYTE = input.readByte();
                this.INT = input.readInt();
                this.REFID = new RefID(input);
                this.TSTRING = ctx.STRINGS.read(input);
                this.UNKNOWN_SHORT = null;
                this.UNKNOWN_4BYTES = null;
                break;
            }
            default: {
                this.REFID = null;
                this.TSTRING = null;
                this.UNKNOWN_SHORT = null;
                this.BYTE = null;
                this.INT = null;
                this.UNKNOWN_4BYTES = null;
            }
        }
        this.VARIABLE = unknown3 == 3 ? Variable.read(input, ctx) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        assert (null != this.STRING || null != this.VARIABLE);
        if (null == this.STRING) {
            this.VARIABLE.write(output);
            return;
        }
        output.writeLString(this.STRING);
        switch (this.STRING) {
            case "QuestStage": {
                output.writeESSElement(this.REFID);
                output.writeShort(this.UNKNOWN_SHORT.shortValue());
                output.writeByte(this.BYTE.byteValue());
                if (null == this.INT) break;
                output.writeInt(this.INT);
                break;
            }
            case "ScenePhaseResults": {
                output.writeESSElement(this.REFID);
                output.writeInt(this.INT);
                output.writeInt(this.UNKNOWN_4BYTES);
                break;
            }
            case "SceneActionResults": {
                output.writeESSElement(this.REFID);
                output.writeInt(this.INT);
                output.writeInt(this.UNKNOWN_4BYTES);
                break;
            }
            case "SceneResults": {
                output.writeESSElement(this.REFID);
                output.writeInt(this.UNKNOWN_4BYTES);
                break;
            }
            case "TerminalRunResults": {
                output.writeByte(this.BYTE.byteValue());
                output.writeInt(this.INT);
                output.writeESSElement(this.REFID);
                output.writeESSElement(this.TSTRING);
                break;
            }
        }
        if (null != this.VARIABLE) {
            this.VARIABLE.write(output);
        }
    }

    @Override
    public int calculateSize() {
        assert (null != this.STRING || null != this.VARIABLE);
        if (null == this.STRING) {
            return this.VARIABLE.calculateSize();
        }
        int sum = 4 + this.STRING.length();
        sum += null == this.REFID ? 0 : this.REFID.calculateSize();
        sum += null == this.TSTRING ? 0 : this.TSTRING.calculateSize();
        sum += null == this.UNKNOWN_SHORT ? 0 : 2;
        sum += null == this.BYTE ? 0 : 1;
        sum += null == this.INT ? 0 : 4;
        sum += null == this.UNKNOWN_4BYTES ? 0 : 4;
        return sum += null == this.VARIABLE ? 0 : this.VARIABLE.calculateSize();
    }

    @Override
    public void addNames(Analysis analysis) {
        if (null != this.VARIABLE) {
            this.VARIABLE.addNames(analysis);
        }
        if (null != this.REFID) {
            this.REFID.addNames(analysis);
        }
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (null != this.VARIABLE) {
            this.VARIABLE.resolveRefs(ess, owner);
        }
        if (null != this.REFID) {
            this.REFID.resolveRefs(ess, owner);
        }
        if (null != this.TSTRING) {
            this.TSTRING.addRefHolder(owner);
        }
    }

    @Override
    public String toHTML() {
        assert (null != this.STRING || null != this.VARIABLE);
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("UNK4");
        if (null == this.STRING) {
            BUILDER.append(": ").append(this.VARIABLE);
        }
        BUILDER.append("(").append(this.STRING).append("): ");
        switch (this.STRING) {
            case "QuestStage": {
                BUILDER.append(this.REFID.toHTML()).append(" ");
                BUILDER.append(this.TSTRING).append(" ");
                break;
            }
            case "ScenePhaseResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
            case "SceneActionResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
            case "SceneResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
        }
        if (null != this.VARIABLE) {
            BUILDER.append("(").append(this.VARIABLE.toHTML()).append(")");
        }
        return BUILDER.toString();
    }

    public String toString() {
        assert (null != this.STRING || null != this.VARIABLE);
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("UNK4");
        if (null == this.STRING) {
            BUILDER.append(": ").append(this.VARIABLE);
        }
        BUILDER.append("(").append(this.STRING).append("): ");
        switch (this.STRING) {
            case "QuestStage": {
                BUILDER.append(this.REFID).append(" ");
                BUILDER.append(this.TSTRING).append(" ");
                break;
            }
            case "ScenePhaseResults": {
                BUILDER.append(this.REFID);
                break;
            }
            case "SceneActionResults": {
                BUILDER.append(this.REFID);
                break;
            }
            case "SceneResults": {
                BUILDER.append(this.REFID);
                break;
            }
        }
        if (null != this.VARIABLE) {
            BUILDER.append("(").append(this.VARIABLE).append(")");
        }
        return BUILDER.toString();
    }
}

