/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.Analysis;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.RefID;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StringTable;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Type;

public abstract class Variable
implements PapyrusElement,
Linkable {
    public static Variable read(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        Type TYPE2 = Type.read(input);
        switch (TYPE2) {
            case NULL: {
                return new Null(input);
            }
            case REF: {
                return new Ref(input, ctx);
            }
            case STRING: {
                return new Str(input, ctx);
            }
            case INTEGER: {
                return new Int(input);
            }
            case FLOAT: {
                return new Flt(input);
            }
            case BOOLEAN: {
                return new Bool(input);
            }
            case VARIANT: {
                return new Variant(input, ctx);
            }
            case STRUCT: {
                return new Struct(input, ctx);
            }
            case REF_ARRAY: 
            case STRING_ARRAY: 
            case INTEGER_ARRAY: 
            case FLOAT_ARRAY: 
            case BOOLEAN_ARRAY: 
            case VARIANT_ARRAY: 
            case STRUCT_ARRAY: {
                return new Array(TYPE2, input, ctx);
            }
        }
        throw new IOException();
    }

    @Override
    public void addNames(Analysis analysis) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    public abstract Type getType();

    @Override
    public String toHTML() {
        return this.toString();
    }

    public String toTypeString() {
        return this.getType().toString();
    }

    public boolean hasRef() {
        return false;
    }

    public boolean hasRef(EID id) {
        return false;
    }

    public EID getRef() {
        return null;
    }

    public GameElement getReferent() {
        return null;
    }

    public abstract String toValueString();

    public static final class Array
    extends Variable {
        private final Type TYPE;
        private final EID ARRAYID;
        private final TString REFTYPE;
        private ArrayInfo array;

        protected Array(Type type, LittleEndianInput input, PapyrusContext ctx) throws IOException {
            Objects.requireNonNull(type);
            Objects.requireNonNull(input);
            this.TYPE = type;
            this.REFTYPE = this.TYPE.isRefType() ? ctx.STRINGS.read(input) : null;
            this.ARRAYID = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
            this.array = null;
        }

        public EID getArrayID() {
            return this.ARRAYID;
        }

        public ArrayInfo getArray() {
            return this.array;
        }

        public Type getElementType() {
            return Type.values()[this.TYPE.ordinal() - 7];
        }

        @Override
        public Type getType() {
            return this.TYPE;
        }

        @Override
        public boolean hasRef() {
            return true;
        }

        @Override
        public boolean hasRef(EID id) {
            return Objects.equals(this.ARRAYID, id);
        }

        @Override
        public EID getRef() {
            return this.getArrayID();
        }

        @Override
        public GameElement getReferent() {
            return null;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            if (this.TYPE.isRefType()) {
                this.REFTYPE.write(output);
            }
            output.writeESSElement(this.ARRAYID);
        }

        @Override
        public int calculateSize() {
            int sum = 1;
            sum += this.TYPE.isRefType() ? this.REFTYPE.calculateSize() : 0;
            return sum += this.ARRAYID.calculateSize();
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
            if (!this.getArrayID().isZero()) {
                this.array = ess.getPapyrus().getArrays().getOrDefault(this.getArrayID(), null);
                assert (null != this.array);
                assert (owner instanceof PapyrusElement);
                this.array.addRefHolder((PapyrusElement)owner);
            }
        }

        @Override
        public String toTypeString() {
            if (null == this.array) {
                if (this.TYPE.isRefType()) {
                    return "" + this.REFTYPE + "[ ]";
                }
                return this.getElementType() + "[ ]";
            }
            if (this.TYPE.isRefType()) {
                return this.TYPE + ":" + "" + this.REFTYPE + "[" + Integer.toString(this.array.getLength()) + "]";
            }
            return this.TYPE + ":" + this.getElementType() + "[" + Integer.toString(this.array.getLength()) + "]";
        }

        @Override
        public String toValueString() {
            if (null != this.getArray()) {
                return "" + this.ARRAYID + ": " + this.getArray().toValueString();
            }
            return this.ARRAYID.toString();
        }

        @Override
        public String toHTML() {
            return String.format("%s : <a href=\"%s\">%s</a>", this.toTypeString(), this.ARRAYID, this.ARRAYID);
        }

        public String toString() {
            return this.toTypeString() + " " + this.ARRAYID;
        }
    }

    public static final class Bool
    extends Variable {
        private final int VALUE;

        public Bool(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.VALUE = input.readInt();
        }

        public Bool(boolean val) {
            this.VALUE = val ? 1 : 0;
        }

        public boolean getValue() {
            return this.VALUE != 0;
        }

        @Override
        public int calculateSize() {
            return 5;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            output.writeInt(this.VALUE);
        }

        @Override
        public Type getType() {
            return Type.BOOLEAN;
        }

        @Override
        public String toValueString() {
            return Boolean.toString(this.VALUE != 0);
        }

        public String toString() {
            return this.getType() + ":" + this.toValueString();
        }
    }

    public static final class Flt
    extends Variable {
        private final float VALUE;

        public Flt(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.VALUE = input.readFloat();
        }

        public Flt(float val) {
            this.VALUE = val;
        }

        public float getValue() {
            return this.VALUE;
        }

        @Override
        public int calculateSize() {
            return 5;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            output.writeFloat(this.VALUE);
        }

        @Override
        public Type getType() {
            return Type.FLOAT;
        }

        @Override
        public String toValueString() {
            return Float.toString(this.VALUE);
        }

        public String toString() {
            return this.getType() + ":" + this.toValueString();
        }
    }

    public static final class Int
    extends Variable {
        private final int VALUE;

        public Int(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.VALUE = input.readInt();
        }

        public Int(int val) {
            this.VALUE = val;
        }

        public int getValue() {
            return this.VALUE;
        }

        @Override
        public int calculateSize() {
            return 5;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            output.writeInt(this.VALUE);
        }

        @Override
        public Type getType() {
            return Type.INTEGER;
        }

        @Override
        public String toValueString() {
            return Integer.toString(this.VALUE);
        }

        public String toString() {
            return this.getType() + ":" + this.toValueString();
        }
    }

    public static final class Str
    extends Variable {
        private final StringTable STRINGS;
        private final TString VALUE;

        public Str(LittleEndianInput input, PapyrusContext ctx) throws IOException {
            Objects.requireNonNull(input);
            this.STRINGS = Objects.requireNonNull(ctx.STRINGS);
            this.VALUE = this.STRINGS.read(input);
        }

        public Str(Str template, String newValue) {
            Objects.requireNonNull(template);
            Objects.requireNonNull(newValue);
            this.STRINGS = template.STRINGS;
            this.VALUE = this.STRINGS.addString(newValue);
        }

        public TString getValue() {
            return this.VALUE;
        }

        @Override
        public int calculateSize() {
            return 1 + this.VALUE.calculateSize();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            this.VALUE.write(output);
        }

        @Override
        public Type getType() {
            return Type.STRING;
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
            this.VALUE.addRefHolder(owner);
        }

        @Override
        public String toValueString() {
            return "\"" + this.VALUE + "\"";
        }

        public String toString() {
            return this.getType() + ":" + this.toValueString();
        }
    }

    public static final class Struct
    extends AbstractRef {
        public Struct(LittleEndianInput input, PapyrusContext ctx) throws IOException {
            super(input, ctx);
        }

        public Struct(TString type, EID id) {
            super(type, id);
        }

        public Struct derive(long id, ESS ess) {
            Struct derivative = new Struct(this.getRefType(), this.getRef().derive(id));
            derivative.resolveRefs(ess, null);
            return derivative;
        }

        @Override
        public Type getType() {
            return Type.STRUCT;
        }
    }

    public static final class Variant
    extends Variable {
        private final Variable VALUE;

        public Variant(LittleEndianInput input, PapyrusContext ctx) throws IOException {
            Variable var;
            Objects.requireNonNull(input);
            this.VALUE = var = Variable.read(input, ctx);
        }

        public Variable getValue() {
            return this.VALUE;
        }

        @Override
        public int calculateSize() {
            return 1 + this.VALUE.calculateSize();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeESSElement(this.getType());
            output.writeESSElement(this.VALUE);
        }

        @Override
        public Type getType() {
            return Type.VARIANT;
        }

        @Override
        public boolean hasRef() {
            return this.VALUE.hasRef();
        }

        @Override
        public boolean hasRef(EID id) {
            return this.VALUE.hasRef(id);
        }

        @Override
        public EID getRef() {
            return this.VALUE.getRef();
        }

        @Override
        public GameElement getReferent() {
            return this.VALUE.getReferent();
        }

        @Override
        public String toValueString() {
            return this.VALUE.toValueString();
        }

        public String toString() {
            return this.getType() + ":" + this.VALUE.toString();
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
            this.VALUE.resolveRefs(ess, owner);
        }
    }

    public static final class Ref
    extends AbstractRef {
        public Ref(LittleEndianInput input, PapyrusContext ctx) throws IOException {
            super(input, ctx);
        }

        public Ref(TString type, EID id) {
            super(type, id);
        }

        public Ref derive(long id, ESS ess) {
            Ref derivative = new Ref(this.getRefType(), this.getRef().derive(id));
            derivative.resolveRefs(ess, null);
            return derivative;
        }

        @Override
        public Type getType() {
            return Type.REF;
        }
    }

    private static abstract class AbstractRef
    extends Variable {
        private final TString REFTYPE;
        private final EID REF;
        private final RefID ref;
        private GameElement referent;

        public AbstractRef(LittleEndianInput input, PapyrusContext ctx) throws IOException {
            Objects.requireNonNull(input);
            this.REFTYPE = ctx.STRINGS.read(input);
            this.REF = ctx.GAME.isID64() ? EID.read8byte(input) : EID.read4byte(input);
            this.ref = new RefID(this.REF);
        }

        public AbstractRef(TString type, EID id) {
            this.REF = Objects.requireNonNull(id);
            this.REFTYPE = Objects.requireNonNull(type);
            this.ref = new RefID(this.REF);
        }

        public boolean isNull() {
            return this.REF.isZero();
        }

        public TString getRefType() {
            return this.REFTYPE;
        }

        @Override
        public boolean hasRef() {
            return true;
        }

        @Override
        public boolean hasRef(EID id) {
            return Objects.equals(this.REF, id);
        }

        @Override
        public EID getRef() {
            return this.REF;
        }

        @Override
        public GameElement getReferent() {
            return this.referent;
        }

        @Override
        public int calculateSize() {
            int sum = 1;
            sum += this.REFTYPE.calculateSize();
            return sum += this.REF.calculateSize();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            this.REFTYPE.write(output);
            output.writeESSElement(this.REF);
        }

        @Override
        public void addNames(Analysis analysis) {
            this.ref.addNames(analysis);
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
            if (ess.getPapyrus().getInstances().containsKey(this.REF)) {
                this.referent = (GameElement)ess.getPapyrus().getInstances().get(this.REF);
            } else if (ess.getPapyrus().getReferences().containsKey(this.REF)) {
                this.referent = (GameElement)ess.getPapyrus().getReferences().get(this.REF);
            } else if (ess.getPapyrus().getStructs().containsKey(this.REF)) {
                this.referent = (GameElement)ess.getPapyrus().getStructs().get(this.REF);
            } else if (this.REF.isZero()) {
                this.referent = null;
            } else {
                System.err.printf("A variable's referent was missing: \nVar = %s\nOwner = %s\n", this, owner);
                this.referent = null;
            }
            if (null != owner) {
                this.REFTYPE.addRefHolder(owner);
            }
        }

        @Override
        public String toTypeString() {
            return this.REFTYPE.toString();
        }

        @Override
        public String toValueString() {
            return this.REF.toString() + " (" + this.REFTYPE + ")";
        }

        @Override
        public String toHTML() {
            if (null != this.referent) {
                if (this.referent instanceof ScriptInstance) {
                    return String.format("%s : <a href=\"instance://%s\">%s</a> (<a href=\"script://%s\">%s</a>)", this.getType(), this.REF, this.REF, this.REFTYPE, this.REFTYPE);
                }
                if (this.referent instanceof Reference) {
                    return String.format("%s : <a href=\"reference://%s\">%s</a> (<a href=\"script://%s\">%s</a>)", this.getType(), this.REF, this.REF, this.REFTYPE, this.REFTYPE);
                }
            }
            return String.format("%s : %s (<a href=\"script://%s\">%s</a>)", this.getType(), this.REF, this.REFTYPE, this.REFTYPE);
        }

        public String toString() {
            return this.getType() + " : " + this.toValueString();
        }
    }

    public static final class Null
    extends Variable {
        private final int VALUE;

        public Null(LittleEndianInput input) throws IOException {
            this.VALUE = input.readInt();
        }

        @Override
        public int calculateSize() {
            return 5;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.getType().write(output);
            output.writeInt(this.VALUE);
        }

        @Override
        public Type getType() {
            return Type.NULL;
        }

        @Override
        public String toValueString() {
            return "NULL";
        }

        public String toString() {
            return "NULL";
        }
    }
}

