/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.ini4j.Ini;
import restringer.Game;
import restringer.Mod;

public abstract class Configurator {
    private static final Logger LOG = Logger.getLogger(Configurator.class.getCanonicalName());
    static final File MO_DEFAULT_DIR = new File("C:\\Program Files (x86)\\Mod Organizer");
    static final File MOD_DEFAULT_DIR = new File(System.getProperty("user.home"));
    static final String MODS_PATH = "mods";
    static final String PROFILES_PATH = "profiles";
    static final String INI_PATH = "ModOrganizer.ini";
    static final String MODLIST_PATH = "modlist.txt";
    static final String MODLIST_PATTERN = "^([+-])(.+)$";
    static final Pattern MODLIST_REGEX = Pattern.compile("^([+-])(.+)$");
    private static final FileFilter SAVE_FILTER = f -> Game.VALUES.stream().anyMatch(v -> v.REGEX.matcher(f.getName()).matches());
    private static final String TXT_PATTERN = ".+\\.(txt)";
    private static final Pattern TXT_REGEX = Pattern.compile(".+\\.(txt)");
    private static final FileFilter MOD_FILTER = file -> file.isDirectory() && file.getName().equalsIgnoreCase(MODS_PATH);
    private static final FileChooser.ExtensionFilter FX_FILTER = new FileChooser.ExtensionFilter("Skyrim / Fallout 4 saves", new String[]{"*.ESS", "*.FOS"});
    private static final Preferences PREFS = Preferences.userNodeForPackage(Configurator.class);
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/Configurator");

    public static File selectPluginsExport(JFrame parent, File savefile) {
        File selection;
        block8: {
            LOG.info("Choosing an export file.");
            FileChooser CHOOSER = new FileChooser();
            CHOOSER.setTitle(RES.getString("ENTER_EXPORT_NAME"));
            CHOOSER.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(RES.getString("PLUGINS_LIST"), new String[]{"*.txt"}));
            File previousExport = Configurator.getPreviousPluginsExport();
            if (null != savefile) {
                CHOOSER.setInitialFileName(String.format("Plugins - %s.txt", savefile.getName()));
            }
            if (null != previousExport) {
                LOG.fine("Trying to use the pre-existing export directory.");
                if (Configurator.validatePluginsExport(previousExport)) {
                    CHOOSER.setInitialDirectory(previousExport.getParentFile());
                    if (null == savefile) {
                        CHOOSER.setInitialFileName(previousExport.getName());
                    }
                }
            }
            while (true) {
                String TITLE;
                String MSG;
                if (null == (selection = CHOOSER.showSaveDialog(null))) {
                    LOG.fine("User cancelled.");
                    return null;
                }
                if (!selection.getName().matches(TXT_PATTERN)) {
                    LOG.fine("Correcting file extension.");
                    selection = new File(selection.getParent(), selection.getName() + ".txt");
                }
                if (selection.exists() && !selection.canWrite()) {
                    MSG = String.format(RES.getString("FILE_NOT_WRITEABLE"), selection.getAbsolutePath());
                    TITLE = RES.getString("UNWRITEABLE");
                    LOG.warning(MSG);
                    JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                    continue;
                }
                if (!selection.exists()) break block8;
                MSG = RES.getString("FILE_EXISTS_REPLACE");
                TITLE = RES.getString("FILE_EXISTS");
                LOG.warning(MSG);
                int overwrite = JOptionPane.showConfirmDialog(parent, MSG, TITLE, 2, 2);
                if (overwrite == 0) break;
            }
            Configurator.setPreviousPluginsExport(selection);
            return selection;
        }
        Configurator.setPreviousPluginsExport(selection);
        return selection;
    }

    public static File selectNewSaveFile(JFrame parent, Game game) {
        File selection;
        LOG.info("Choosing a savegame.");
        FileChooser CHOOSER = new FileChooser();
        CHOOSER.setTitle(RES.getString("SELECT_NEW_SAVEGAME"));
        CHOOSER.getExtensionFilters().add((Object)game.FX_FILTER);
        File previousSave = Configurator.getPreviousSave();
        if (null != previousSave) {
            LOG.fine("Trying to use the pre-existing save directory.");
            if (Configurator.validateNewSavegame(previousSave)) {
                CHOOSER.setInitialDirectory(previousSave.getParentFile());
            } else if (Configurator.validateSaveDirectory(previousSave.getParentFile())) {
                CHOOSER.setInitialDirectory(previousSave.getParentFile());
            }
        } else {
            String HOME = System.getProperty("user.home");
            File f = new File(HOME);
            CHOOSER.setInitialDirectory(f);
        }
        while (true) {
            if (null == (selection = CHOOSER.showSaveDialog(null))) {
                LOG.fine("User cancelled.");
                return null;
            }
            if (!game.testFilename(selection)) {
                LOG.fine("Correcting file extension.");
                selection = new File(selection.getParent(), selection.getName() + "." + game.EXT);
            }
            if (!selection.exists() || selection.canWrite()) break;
            String MSG = String.format(RES.getString("FILE_NOT_WRITEABLE"), selection.getAbsolutePath());
            String TITLE = RES.getString("UNWRITEABLE");
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        Configurator.setPreviousSave(selection);
        return selection;
    }

    public static File confirmSaveFile(JFrame parent, Game game) {
        LOG.info("Choosing a savegame.");
        File previousSave = Configurator.getPreviousSave();
        if (previousSave.exists() && !previousSave.canWrite()) {
            String MSG = String.format(RES.getString("FILE_NOT_WRITEABLE"), previousSave.getAbsolutePath());
            String TITLE = RES.getString("UNWRITEABLE");
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
            return null;
        }
        if (previousSave.exists()) {
            String MSG = RES.getString("FILE_EXISTS_REPLACE");
            String TITLE = RES.getString("FILE_EXISTS");
            LOG.warning(MSG);
            int overwrite = JOptionPane.showConfirmDialog(parent, MSG, TITLE, 1, 2);
            switch (overwrite) {
                case 0: {
                    return previousSave;
                }
                case 2: {
                    return null;
                }
            }
            return Configurator.selectNewSaveFile(parent, game);
        }
        return previousSave;
    }

    public static File selectSaveFile(JFrame parent) {
        File selection;
        LOG.info("Choosing a savegame.");
        FileChooser CHOOSER = new FileChooser();
        CHOOSER.setTitle(RES.getString("SELECT_SAVEGAME"));
        CHOOSER.getExtensionFilters().add((Object)FX_FILTER);
        File previousSave = Configurator.getPreviousSave();
        if (null != previousSave) {
            LOG.fine("Trying to use the pre-existing savegame.");
            if (Configurator.validateSavegame(previousSave)) {
                CHOOSER.setInitialDirectory(previousSave.getParentFile());
                CHOOSER.setInitialFileName(previousSave.getName());
            } else if (Configurator.validateSaveDirectory(previousSave.getParentFile())) {
                CHOOSER.setInitialDirectory(previousSave.getParentFile());
            }
        } else {
            String HOME = System.getProperty("user.home");
            File f = new File(HOME);
            CHOOSER.setInitialDirectory(f);
        }
        while (true) {
            if (null == (selection = CHOOSER.showOpenDialog(null))) {
                LOG.fine("User cancelled.");
                return null;
            }
            if (Configurator.validateSavegame(selection)) break;
            String MSG = RES.getString("INVALID_SAVEGAME");
            String TITLE = RES.getString("INVALID");
            LOG.warning(MSG);
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        Configurator.setPreviousSave(selection);
        return selection;
    }

    public static File selectMod(JFrame parent) {
        File selection;
        LOG.info("Choosing a mod directory.");
        DirectoryChooser CHOOSER = new DirectoryChooser();
        CHOOSER.setTitle(RES.getString("SELECT_MOD"));
        if (!Configurator.validateModPath(Configurator.getUserModDirectory())) {
            if (Configurator.validateModOrganizerDirectory(Configurator.getModOrganizerDirectory())) {
                Configurator.setUserModDirectory(new File(Configurator.getModOrganizerDirectory(), MODS_PATH));
            } else if (Configurator.validateModOrganizerDirectory(MO_DEFAULT_DIR)) {
                Configurator.setUserModDirectory(new File(MO_DEFAULT_DIR, MODS_PATH));
                Configurator.setModOrganizerDirectory(MO_DEFAULT_DIR);
            } else {
                Configurator.setUserModDirectory(MOD_DEFAULT_DIR);
            }
        }
        while (true) {
            if (null == (selection = CHOOSER.showDialog(null))) {
                LOG.fine("User cancelled.");
                return null;
            }
            if (Configurator.validateModPath(selection)) break;
            String MSG = RES.getString("INVALID_MOD");
            String TITLE = RES.getString("INVALID");
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        Configurator.setUserModDirectory(selection.getParentFile());
        return selection;
    }

    public static File selectOutputDirectory(File prevDir, JFrame parent) {
        String MSG;
        File selection;
        LOG.info("Choosing an output path.");
        JFileChooser CHOOSER = new JFileChooser();
        CHOOSER.setDialogTitle(RES.getString("SELECT_PATCH_DIR"));
        CHOOSER.setFileSelectionMode(1);
        CHOOSER.setMultiSelectionEnabled(false);
        if (Configurator.validateOutputPath(prevDir)) {
            LOG.fine("Trying to use the pre-existing output path.");
            CHOOSER.setSelectedFile(prevDir);
        } else if (null != prevDir) {
            LOG.fine("Searching up the tree from the pre-existing output path.");
            while (!prevDir.exists() || !prevDir.canRead()) {
                prevDir = prevDir.getParentFile();
            }
            CHOOSER.setCurrentDirectory(prevDir);
        } else if (Configurator.validateOutputPath(Configurator.getUserOutputDirectory())) {
            LOG.fine("Trying to use previous profile's output directory.");
            CHOOSER.setCurrentDirectory(Configurator.getUserOutputDirectory());
        } else if (Configurator.validateModOrganizerDirectory(Configurator.getModOrganizerDirectory())) {
            LOG.fine("Trying to use the Mod Organizer path.");
            CHOOSER.setCurrentDirectory(new File(Configurator.getModOrganizerDirectory(), MODS_PATH));
        } else if (Configurator.validateModOrganizerDirectory(MO_DEFAULT_DIR)) {
            LOG.fine("Trying to use the default Mod Organizer path.");
            Configurator.setModOrganizerDirectory(MO_DEFAULT_DIR);
            CHOOSER.setCurrentDirectory(new File(MO_DEFAULT_DIR, MODS_PATH));
        }
        while (true) {
            String TITLE;
            Configurator.loadChooserPrefs(CHOOSER);
            int result = CHOOSER.showDialog(parent, RES.getString("SELECT"));
            selection = CHOOSER.getSelectedFile();
            Configurator.saveChooserPrefs(CHOOSER);
            if (null == selection || result == 1) {
                LOG.fine("User cancelled.");
                return null;
            }
            if (Configurator.validateOutputPath(selection)) break;
            if (!selection.exists()) {
                MSG = String.format(RES.getString("DIR_NONEXISTENT"), selection.getAbsolutePath());
                TITLE = RES.getString("NONEXISTENT");
                LOG.warning(MSG);
                JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                continue;
            }
            if (!selection.canWrite()) {
                MSG = String.format(RES.getString("DIRECTORY_NOT_WRITEABLE"), selection.getAbsolutePath());
                TITLE = RES.getString("UNWRITEABLE");
                LOG.warning(MSG);
                JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                continue;
            }
            MSG = String.format(RES.getString("INVALID_PATCH_DIR"), selection.getAbsolutePath());
            TITLE = RES.getString("INVALID");
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        assert (Configurator.validateOutputPath(selection));
        MSG = String.format("User selected outut path directory \"%s\".", selection.getAbsolutePath());
        LOG.info(MSG);
        Configurator.setUserOutputDirectory(selection);
        return selection;
    }

    public static File selectModOrganizerDirectory(JFrame parent) {
        String MSG;
        File selection;
        LOG.info("Choosing the ModOrganizer path.");
        JFileChooser CHOOSER = new JFileChooser();
        CHOOSER.setDialogTitle(RES.getString("SELECT_MO_DIR"));
        CHOOSER.setFileSelectionMode(1);
        CHOOSER.setMultiSelectionEnabled(false);
        if (Configurator.validateModOrganizerDirectory(Configurator.getModOrganizerDirectory())) {
            LOG.fine("Choosing a ModOrganizer path: trying the pre-existing path.");
            CHOOSER.setSelectedFile(Configurator.getModOrganizerDirectory());
        } else if (Configurator.validateModOrganizerDirectory(MO_DEFAULT_DIR)) {
            LOG.fine("Choosing a ModOrganizer path: trying a default value.");
            CHOOSER.setSelectedFile(MO_DEFAULT_DIR);
        }
        while (true) {
            String TITLE;
            Configurator.loadChooserPrefs(CHOOSER);
            int result = CHOOSER.showDialog(parent, RES.getString("SELECT"));
            selection = CHOOSER.getSelectedFile();
            Configurator.saveChooserPrefs(CHOOSER);
            if (null == selection || result == 1) {
                LOG.fine("User cancelled.");
                return null;
            }
            if (Configurator.validateModOrganizerDirectory(selection)) break;
            if (!selection.exists()) {
                MSG = String.format(RES.getString("DIR_NONEXISTENT"), selection.getAbsolutePath());
                TITLE = RES.getString("NONEXISTENT");
                LOG.warning(MSG);
                JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                continue;
            }
            if (!selection.canRead()) {
                MSG = String.format(RES.getString("DIR_UNREADABLE"), selection.getAbsolutePath());
                TITLE = RES.getString("MO DIRECTORY");
                LOG.warning(MSG);
                JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                continue;
            }
            if (selection.listFiles(MOD_FILTER).length == 0) {
                MSG = RES.getString("NO_MODS_DIR");
                TITLE = RES.getString("INVALID");
                LOG.warning(MSG);
                JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
                continue;
            }
            MSG = String.format(RES.getString("NOT_MO"), selection.getAbsolutePath());
            TITLE = RES.getString("INVALID");
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        MSG = String.format("User selected ModOrganizer path directory \"%s\".", selection.getAbsolutePath());
        LOG.fine(MSG);
        assert (Configurator.validateModOrganizerDirectory(selection));
        Configurator.setModOrganizerDirectory(selection);
        return selection;
    }

    public static File selectGameDirectory(JFrame parent, Game game) {
        File selection;
        LOG.info(String.format("Choosing the %s directory.", new Object[]{game}));
        JFileChooser CHOOSER = new JFileChooser();
        CHOOSER.setDialogTitle(String.format(RES.getString("SELECT_GAME_DIR"), game.NAME));
        CHOOSER.setFileSelectionMode(1);
        CHOOSER.setMultiSelectionEnabled(false);
        File PREV_DIR = Configurator.getGameDirectory(game);
        if (Configurator.validateGameDirectory(game, PREV_DIR)) {
            LOG.fine("Trying to use the stored value for the game directory.");
            CHOOSER.setSelectedFile(PREV_DIR);
            CHOOSER.setCurrentDirectory(PREV_DIR);
        }
        while (true) {
            Configurator.loadChooserPrefs(CHOOSER);
            int result = CHOOSER.showOpenDialog(parent);
            selection = CHOOSER.getSelectedFile();
            Configurator.saveChooserPrefs(CHOOSER);
            if (null == selection || result == 1) {
                return null;
            }
            if (Configurator.validateGameDirectory(game, selection)) break;
            String MSG = String.format(RES.getString("NOT_GAMEDIR"), game.NAME);
            String TITLE = RES.getString("INVALID");
            LOG.warning(MSG);
            JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
        }
        assert (Configurator.validateGameDirectory(game, selection));
        Configurator.setGameDirectory(game, selection);
        return selection;
    }

    public static boolean validateModOrganizerDirectory(File dir) {
        if (null == dir) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        if (!dir.canRead()) {
            return false;
        }
        return dir.listFiles(MOD_FILTER).length > 0;
    }

    public static boolean validateGameDirectory(Game game, File dir) {
        FileFilter filter = file -> file.isDirectory() && file.getName().equalsIgnoreCase("data") && file.getParentFile().getName().equalsIgnoreCase(game.DIR) && new File(file.getParentFile(), game.EXE).exists();
        if (!(null != dir && dir.isDirectory() && dir.exists() && dir.canRead())) {
            return false;
        }
        if (filter.accept(dir)) {
            return true;
        }
        return 0 < dir.listFiles(filter).length;
    }

    public static boolean validateOutputPath(File dir) {
        if (null == dir) {
            return false;
        }
        if (dir.exists() && dir.isFile()) {
            return false;
        }
        if (dir.exists() && dir.isDirectory()) {
            return dir.canWrite();
        }
        dir.mkdir();
        dir.delete();
        return true;
    }

    public static boolean validateModPath(File dir) {
        if (null == dir) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        return dir.canRead();
    }

    public static boolean validateNewSavegame(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists() && !file.isFile()) {
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        return file.getParentFile().canWrite();
    }

    public static boolean validateSavegame(File file) {
        if (null == file) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        return SAVE_FILTER.accept(file);
    }

    public static boolean validateNewExport(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists() && !file.isFile()) {
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        return file.getParentFile().canWrite();
    }

    public static boolean validatePluginsExport(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists() && !file.isFile()) {
            return false;
        }
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        return file.getParentFile().canWrite();
    }

    public static boolean validateSaveDirectory(File dir) {
        if (null == dir) {
            return false;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (!dir.exists()) {
            return false;
        }
        return dir.canRead();
    }

    public static List<Mod> analyzeModOrganizer(Game game, File moDir) {
        assert (Configurator.validateModOrganizerDirectory(moDir));
        LOG.info(RES.getString("ATTEMPTING TO ANALYZE MO"));
        File PROFILE_DIR = new File(moDir, PROFILES_PATH);
        File INI_FILE = new File(moDir, INI_PATH);
        File MOD_DIR = new File(moDir, MODS_PATH);
        try {
            LOG.info(RES.getString("LOADING MODORGANIZER.INI"));
            Ini INI = new Ini();
            INI.getConfig().setLowerCaseOption(true);
            INI.load(INI_FILE);
            LOG.fine(RES.getString("MODORGANIZER.INI LOADED"));
            LOG.info(RES.getString("IMPORTING SELECTED_PROFILE"));
            String profilePath = INI.get("General", "selected_profile", String.class);
            LOG.fine(String.format(RES.getString("SELECTED PROFILE"), profilePath));
            File PROFILE = new File(PROFILE_DIR, profilePath);
            File MOD_LIST = new File(PROFILE, MODLIST_PATH);
            LOG.info(RES.getString("READING PROFILE"));
            LinkedList<String> MODNAMES = new LinkedList<String>();
            try (BufferedReader input = new BufferedReader(new FileReader(MOD_LIST));){
                LOG.fine(RES.getString("READING  MODLIST.TXT"));
                while (input.ready()) {
                    String line = input.readLine();
                    Matcher matcher = MODLIST_REGEX.matcher(line);
                    if (!matcher.matches() || !matcher.group(1).equals("+")) continue;
                    MODNAMES.add(matcher.group(2));
                }
                LOG.fine(String.format(RES.getString("CONTAINED MOD NAMES"), MODNAMES.size()));
            }
            List<Mod> MODS = MODNAMES.stream().map(name -> new Mod(game, new File(MOD_DIR, (String)name))).collect(Collectors.toList());
            return MODS;
        }
        catch (IOException ex) {
            LOG.severe(RES.getString("SOMETHING WENT WRONG"));
            return null;
        }
    }

    private static void saveChooserPrefs(JFileChooser chooser) {
        PREFS.putInt("chooserWidth", chooser.getSize().width);
        PREFS.putInt("chooserHeight", chooser.getSize().height);
        PREFS.putInt("chooserX", chooser.getLocation().x);
        PREFS.putInt("chooserY", chooser.getLocation().y);
    }

    private static void loadChooserPrefs(JFileChooser chooser) {
        int width = PREFS.getInt("chooserWidth", chooser.getSize().width);
        int height = PREFS.getInt("chooserHeight", chooser.getSize().height);
        int x = PREFS.getInt("chooserX", chooser.getLocation().x);
        int y = PREFS.getInt("chooserY", chooser.getLocation().y);
        chooser.setSize(width, height);
        chooser.setLocation(x, y);
    }

    static File getGameDirectory(Game game) {
        String path = "";
        switch (game) {
            case SKYRIM_LE: {
                path = PREFS.get("skyrimLEDirectory", "");
                break;
            }
            case SKYRIM_SE: {
                path = PREFS.get("skyrimSEDirectory", "");
                break;
            }
            case FALLOUT4: {
                path = PREFS.get("fallout4Directory", "");
            }
        }
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setGameDirectory(Game game, File dir) {
        switch (game) {
            case SKYRIM_LE: {
                PREFS.put("skyrimLEDirectory", dir.getPath());
                break;
            }
            case SKYRIM_SE: {
                PREFS.put("skyrimSEDirectory", dir.getPath());
                break;
            }
            case FALLOUT4: {
                PREFS.put("fallout4Directory", dir.getPath());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    static File getSkyrimSEDirectory() {
        String path = PREFS.get("skyrimSEDirectory", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setSkyrimSEDirectory(File dir) {
        PREFS.put("skyrimSEDirectory", dir.getPath());
    }

    static File getFO4Directory() {
        String path = PREFS.get("fo4Directory", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setFO4Directory(File dir) {
        PREFS.put("fo4Directory", dir.getPath());
    }

    static File getUserModDirectory() {
        String path = PREFS.get("userModDirectory", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setUserModDirectory(File dir) {
        PREFS.put("userModDirectory", dir.getPath());
    }

    static File getUserOutputDirectory() {
        String path = PREFS.get("userOutputDirectory", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setUserOutputDirectory(File dir) {
        PREFS.put("userOutputDirectory", dir.getPath());
    }

    static File getModOrganizerDirectory() {
        String path = PREFS.get("modOrganizerDirectory", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setModOrganizerDirectory(File dir) {
        PREFS.put("modOrganizerDirectory", dir.getPath());
    }

    static File getPreviousSave() {
        String path = PREFS.get("previousSave", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setPreviousSave(File file) {
        PREFS.put("previousSave", file.getPath());
    }

    static File getPreviousPluginsExport() {
        String path = PREFS.get("previousPluginsExport", "");
        if (path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    static void setPreviousPluginsExport(File file) {
        PREFS.put("previousPluginsExport", file.getPath());
    }

    private static void error(JFrame parent, String msgKey, String titleKey) {
        String MSG = RES.getString(msgKey);
        String TITLE = RES.getString(titleKey);
        LOG.warning(MSG);
        JOptionPane.showMessageDialog(parent, MSG, TITLE, 0);
    }

    private static void warning(JFrame parent, String msgKey, String titleKey) {
        String MSG = RES.getString(msgKey);
        String TITLE = RES.getString(titleKey);
        LOG.warning(MSG);
        JOptionPane.showMessageDialog(parent, MSG, TITLE, 2);
    }
}

