/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import restringer.ess.Element;
import restringer.ess.papyrus.HasID;
import restringer.gui.ThreadsafeArray;

public final class FilterTreeModel
implements TreeModel {
    private Node root = null;
    final List<TreeModelListener> LISTENERS = new LinkedList<TreeModelListener>();

    public Node node(Element element, Collection<? extends Element> children) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(children);
        Node NODE = new Node(element, false);
        ArrayList<Node> childNodes = new ArrayList<Node>(children.size());
        children.forEach(child -> {
            Node childNode = new Node((Element)child, true);
            childNodes.add(childNode);
        });
        NODE.addAll(childNodes);
        return NODE;
    }

    public Node root(Element element, Collection<Node> children) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(children);
        Node NODE = new Node(element, false);
        NODE.addAll(children);
        return NODE;
    }

    public Node elementContainer(String name, Collection<? extends Element> children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(children);
        Node NODE = new Node(name);
        ArrayList<Node> childNodes = new ArrayList<Node>(children.size());
        children.forEach(child -> {
            Node childNode = new Node((Element)child, true);
            childNodes.add(childNode);
        });
        NODE.addAll(childNodes);
        return NODE;
    }

    public Node nodeContainer(String name, Collection<Node> children) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(children);
        Node NODE = new Node(name);
        NODE.addAll(children);
        return NODE;
    }

    public Node node(Element element, Element child) {
        Objects.requireNonNull(element);
        Node NODE = new Node(element, false);
        if (null != child) {
            Node CHILD = new Node(child, true);
            NODE.addAll(Collections.singleton(CHILD));
        }
        return NODE;
    }

    public Node leaf(Element element) {
        Objects.requireNonNull(element);
        return new Node(element, true);
    }

    public Map<Element, Node> parsePaths(TreePath[] paths) {
        Objects.requireNonNull(paths);
        LinkedHashMap<Element, Node> ELEMENTS = new LinkedHashMap<Element, Node>(paths.length);
        for (TreePath path : paths) {
            if (null == path) continue;
            Node NODE = (Node)path.getLastPathComponent();
            if (NODE.hasElement()) {
                ELEMENTS.put(NODE.getElement(), NODE);
                continue;
            }
            ELEMENTS.putAll(NODE.parsePath());
        }
        return ELEMENTS;
    }

    public List<Element> getElements() {
        if (null == this.root) {
            return new LinkedList<Element>();
        }
        return this.root.getElements();
    }

    public void defilter() {
        if (null == this.root) {
            return;
        }
        this.root.defilter();
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this.root, this.root.getPath()));
    }

    public synchronized void filter(Predicate<Node> filter) {
        Objects.requireNonNull(filter);
        if (null == this.root) {
            return;
        }
        this.root.filter(filter);
        this.LISTENERS.forEach(l -> l.treeStructureChanged(new TreeModelEvent((Object)this.root, this.root.getPath())));
    }

    public TreePath rebuildPath(TreePath path) {
        Objects.requireNonNull(path);
        if (path.getPathCount() < 1) {
            return null;
        }
        TreePath newPath = new TreePath(this.root);
        Node newNode = this.root;
        for (int i = 1; i < path.getPathCount(); ++i) {
            Node originalNode = (Node)path.getPathComponent(i);
            Optional<Node> child = newNode.CHILDREN.stream().filter((? super T n) -> ((Node)n).NAME.equals(originalNode.NAME)).findFirst();
            if (!child.isPresent() && originalNode.hasElement() && originalNode.getElement() instanceof HasID) {
                HasID original = (HasID)originalNode.getElement();
                child = newNode.CHILDREN.stream().filter((? super T n) -> n.hasElement() && n.getElement() instanceof HasID).filter((? super T n) -> ((HasID)n.getElement()).getID() == original.getID()).findAny();
            }
            if (!child.isPresent()) {
                return newPath;
            }
            newNode = child.get();
            newPath = newPath.pathByAddingChild(newNode);
        }
        return newPath;
    }

    public TreePath findPath(Element element) {
        if (null == this.root) {
            return null;
        }
        TreePath path = this.root.findPath(element);
        if (null != path) {
            return path;
        }
        path = this.root.findPathUnfiltered(element);
        if (null != path) {
            this.root.defilter(path, 0);
            return path;
        }
        return null;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node newRoot) {
        this.root = Objects.requireNonNull(newRoot);
    }

    @Override
    public Object getChild(Object parent, int index) {
        assert (parent instanceof Node);
        Node NODE = (Node)parent;
        return NODE.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        assert (parent instanceof Node);
        Node NODE = (Node)parent;
        return NODE.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        assert (parent instanceof Node);
        assert (child instanceof Node);
        Node PARENT = (Node)parent;
        Node CHILD = (Node)child;
        return PARENT.getIndex(CHILD);
    }

    @Override
    public boolean isLeaf(Object node) {
        assert (node instanceof Node);
        Node NODE = (Node)node;
        return NODE.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.LISTENERS.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.LISTENERS.remove(l);
    }

    private void fireTreeNodesChanged(TreeModelEvent event) {
        this.LISTENERS.forEach(listener -> listener.treeNodesChanged(event));
    }

    private void fireTreeNodesInserted(TreeModelEvent event) {
        this.LISTENERS.forEach(listener -> listener.treeNodesInserted(event));
    }

    private void fireTreeNodesRemoved(TreeModelEvent event) {
        this.LISTENERS.forEach(listener -> listener.treeNodesRemoved(event));
    }

    public final class Node
    implements Comparable<Node> {
        private final Element ELEMENT;
        private final String NAME;
        private Node parent = null;
        private final ThreadsafeArray<Node> CHILDREN;
        private final ThreadsafeArray<Node> FILTERED;
        private boolean isSelfFiltered;
        private boolean isFiltered;
        private int leafCount;

        private Node(Element element, boolean leaf) {
            this.ELEMENT = Objects.requireNonNull(element);
            this.NAME = this.ELEMENT.toString();
            if (leaf) {
                this.CHILDREN = null;
                this.FILTERED = null;
            } else {
                this.CHILDREN = new ThreadsafeArray();
                this.FILTERED = new ThreadsafeArray();
            }
            this.isFiltered = false;
            this.isSelfFiltered = false;
            this.leafCount = 1;
        }

        private Node(String name) {
            this.NAME = Objects.requireNonNull(name);
            this.ELEMENT = null;
            this.CHILDREN = new ThreadsafeArray();
            this.FILTERED = new ThreadsafeArray();
            this.isFiltered = false;
            this.isSelfFiltered = false;
            this.leafCount = 0;
        }

        public void addAll(Collection<Node> children) {
            if (this.isLeaf()) {
                throw new UnsupportedOperationException("Not supported.");
            }
            children.forEach(child -> child.setParent(this));
            this.CHILDREN.addAll(children);
            this.FILTERED.addAll(children);
            this.countLeaves();
            FilterTreeModel.this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.getPath()));
        }

        public void remove(Node child) {
            if (this.isLeaf()) {
                throw new UnsupportedOperationException("Not supported.");
            }
            if (!this.FILTERED.contains(child)) {
                return;
            }
            int idx = this.getIndex(child);
            this.CHILDREN.remove(child);
            this.FILTERED.remove(child);
            child.setParent(null);
            this.countLeaves();
            int[] childIndex = new int[]{idx};
            Object[] childNode = new Node[]{child};
            FilterTreeModel.this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.getPath(), childIndex, childNode));
            if (this.FILTERED.isEmpty() && this.isSelfFiltered) {
                this.isFiltered = true;
            }
        }

        public List<Element> getElements() {
            LinkedList<Element> collected = new LinkedList<Element>();
            if (this.hasElement() && !this.isFiltered()) {
                collected.add(this.ELEMENT);
            }
            if (!this.isLeaf()) {
                this.FILTERED.forEach(v -> {
                    if (v.hasElement() && v.isLeaf() && !v.isFiltered()) {
                        collected.add(v.getElement());
                    } else {
                        collected.addAll(v.getElements());
                    }
                });
            }
            return collected;
        }

        public Element getElement() {
            return this.ELEMENT;
        }

        public TreePath findPath(Element element) {
            if (this.ELEMENT == element) {
                return this.getPath();
            }
            if (!this.isLeaf()) {
                for (Node child : this.FILTERED) {
                    TreePath path = child.findPath(element);
                    if (null == path) continue;
                    return path;
                }
            }
            return null;
        }

        public TreePath findPathUnfiltered(Element element) {
            if (this.ELEMENT == element) {
                return this.getPath();
            }
            if (!this.isLeaf()) {
                for (Node child : this.CHILDREN) {
                    TreePath path = child.findPathUnfiltered(element);
                    if (null == path) continue;
                    return path;
                }
            }
            return null;
        }

        public void defilter(TreePath path, int depth) {
            Objects.requireNonNull(path);
            assert (depth < path.getPathCount());
            Node head = (Node)path.getPathComponent(depth);
            assert (head == this);
            if (depth + 1 < path.getPathCount() && !this.isLeaf()) {
                Node next = (Node)path.getPathComponent(depth + 1);
                if (this.CHILDREN.contains(next) && !this.FILTERED.contains(next)) {
                    this.FILTERED.add(next);
                    this.countLeaves();
                    int[] childIndex = new int[]{this.FILTERED.size() - 1};
                    Object[] childNode = new Node[]{next};
                    FilterTreeModel.this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.getPath(), childIndex, childNode));
                }
                next.defilter(path, depth + 1);
            }
        }

        public synchronized void defilter() {
            this.isFiltered = false;
            this.isSelfFiltered = false;
            if (!this.isLeaf()) {
                this.CHILDREN.forEach(child -> child.defilter());
                this.FILTERED.clear();
                this.FILTERED.addAll(this.CHILDREN);
                this.countLeaves();
            }
        }

        public synchronized boolean filter(Predicate<Node> filter) {
            Objects.requireNonNull(filter);
            boolean bl = this.isSelfFiltered = null != this.parent && !filter.test(this);
            if (this.isLeaf()) {
                this.isFiltered = this.isSelfFiltered;
                return this.isFiltered;
            }
            if (this.hasElement() && !this.isSelfFiltered && this.parent != null) {
                this.FILTERED.clear();
                this.FILTERED.addAll(this.CHILDREN);
                this.isFiltered = this.isSelfFiltered;
                this.countLeaves();
                return this.isFiltered;
            }
            this.FILTERED.clear();
            this.FILTERED.addAllUnless(this.CHILDREN, c -> c.filter(filter));
            this.isFiltered = this.isSelfFiltered && this.FILTERED.isEmpty();
            this.countLeaves();
            return this.isFiltered;
        }

        public synchronized void sort() {
            if (!this.isLeaf()) {
                this.CHILDREN.sort((n1, n2) -> n1.toString().compareToIgnoreCase(n2.toString()));
                this.FILTERED.clear();
                this.FILTERED.addAll(this.CHILDREN);
            }
        }

        private Map<Element, Node> parsePath() {
            LinkedHashMap<Element, Node> ELEMENTS = new LinkedHashMap<Element, Node>();
            if (!this.isLeaf()) {
                this.FILTERED.forEach(child -> {
                    if (child.hasElement()) {
                        ELEMENTS.put(child.ELEMENT, (Node)child);
                    }
                    ELEMENTS.putAll(child.parsePath());
                });
            }
            return ELEMENTS;
        }

        private int getLeafCount() {
            if (this.isLeaf() || this.hasElement()) {
                return 1;
            }
            return this.leafCount;
        }

        private void countLeaves() {
            this.leafCount = this.isLeaf() || this.hasElement() ? 1 : this.FILTERED.stream().mapToInt(n -> n.getLeafCount()).sum();
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node newParent) {
            this.parent = newParent;
        }

        public TreePath getPath() {
            if (null == this.parent) {
                return new TreePath(this);
            }
            return this.parent.getPath().pathByAddingChild(this);
        }

        public Node getChildAt(int childIndex) {
            if (this.isLeaf()) {
                throw new IllegalStateException("Leaves don't have children!!");
            }
            if (childIndex >= this.FILTERED.size()) {
                return null;
            }
            return (Node)this.FILTERED.get(childIndex);
        }

        public int getChildCount() {
            if (this.isLeaf()) {
                return 0;
            }
            return this.FILTERED.size();
        }

        public int getIndex(Node node) {
            if (this.isLeaf()) {
                return -1;
            }
            return this.FILTERED.indexOf(node);
        }

        public boolean hasElement() {
            return null != this.ELEMENT;
        }

        public boolean isLeaf() {
            return null == this.CHILDREN;
        }

        public boolean isFiltered() {
            return this.isFiltered;
        }

        public String getName() {
            return this.NAME;
        }

        public String toString() {
            if (this.hasElement()) {
                return this.NAME;
            }
            if (null != this.NAME) {
                return this.NAME + " (" + this.leafCount + ")";
            }
            return "(root)";
        }

        @Override
        public int compareTo(Node o) {
            int cmp = this.getName().compareToIgnoreCase(o.getName());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(this.hashCode(), o.hashCode());
        }
    }
}

